/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.coreplugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.MessageEvent;
import org.gvsig.andami.messages.NotificationListener;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.SingletonWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.coreplugin.Consola;

public class NotificationDialogNew
extends JPanel
implements IWindow,
SingletonWindow,
NotificationListener {
    private static final long serialVersionUID = 4363640321917006480L;
    JPanelConsole console;
    JPanelButtons buttons;
    JPanelDescription description;

    public NotificationDialogNew() {
        this.setLayout(new GridBagLayout());
        this.description = new JPanelDescription();
        this.console = new JPanelConsole();
        this.buttons = new JPanelButtons(this.console);
        this.addComppnent(this, this.description, 0, 0, 3, 1, 1.0, 1.0, 1, 10);
        this.addComppnent(this, this.buttons, 0, 1, 3, 1, 0.0, 0.0, 0, 12);
        this.addComppnent(this, this.console, 0, 2, 3, 1, 1.0, 2.0, 1, 10);
        this.setVisible(true);
        this.hideConsole();
    }

    void addComppnent(JPanel panel, JComponent component, int gridx, int gridy, int width, int height, double weightx, double weighty, int fill, int anchor) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = gridx;
        constraints.gridy = gridy;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.weightx = weightx;
        constraints.weighty = weighty;
        constraints.fill = fill;
        constraints.anchor = anchor;
        constraints.ipadx = 2;
        constraints.ipady = 2;
        panel.add((Component)component, constraints);
        component.setVisible(true);
    }

    public void setDescription(String description) {
        this.description.setDescription(description);
    }

    public void closeWindow() {
        PluginServices.getMDIManager().closeWindow((IWindow)this);
    }

    public void hideConsole() {
        this.buttons.hideConsole();
    }

    public void showConsole() {
        this.buttons.showConsole();
    }

    public Object getWindowModel() {
        return "notification-dialog";
    }

    public WindowInfo getWindowInfo() {
        WindowInfo info = new WindowInfo(23);
        info.setTitle(PluginServices.getText((Object)this, (String)"Warning"));
        info.setHeight(this.getPreferredSize().height);
        info.setWidth(this.getPreferredSize().width);
        return info;
    }

    public Object getWindowProfile() {
        return WindowInfo.PROPERTIES_PROFILE;
    }

    public void errorEvent(MessageEvent e) {
        if (e.getMessages() != null) {
            for (int i = 0; i < e.getMessages().length; ++i) {
                this.setDescription(e.getMessages()[i]);
            }
        }
        if (!this.canShowWindow(e.getExceptions())) {
            try {
                PluginServices.getMainFrame().getStatusBar().message(this.description.getDescription(), 0);
            }
            catch (Throwable i) {
                // empty catch block
            }
            return;
        }
        PluginServices.getMDIManager().restoreCursor();
        if (SwingUtilities.isEventDispatchThread()) {
            PluginServices.getMDIManager().addCentredWindow((IWindow)this);
        } else {
            final NotificationDialogNew win = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginServices.getMDIManager().addCentredWindow(win);
                }
            });
        }
    }

    public void warningEvent(MessageEvent e) {
        if (e.getMessages() != null) {
            for (int i = 0; i < e.getMessages().length; ++i) {
                this.setDescription(e.getMessages()[i]);
            }
        }
        if (!this.canShowWindow(e.getExceptions())) {
            try {
                PluginServices.getMainFrame().getStatusBar().message(this.description.getDescription(), 0);
            }
            catch (Throwable i) {
                // empty catch block
            }
            return;
        }
        PluginServices.getMDIManager().restoreCursor();
        if (SwingUtilities.isEventDispatchThread()) {
            PluginServices.getMDIManager().addCentredWindow((IWindow)this);
        } else {
            final NotificationDialogNew win = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PluginServices.getMDIManager().addCentredWindow(win);
                }
            });
        }
    }

    public void infoEvent(MessageEvent e) {
    }

    private boolean canShowWindow(Throwable[] ths) {
        if (ths == null) {
            return true;
        }
        try {
            for (int n = 0; n < ths.length; ++n) {
                StackTraceElement[] stack_ee = ths[n].getStackTrace();
                for (int i = 0; i < stack_ee.length; ++i) {
                    StackTraceElement se = stack_ee[i];
                    if (!se.getClassName().startsWith("org.gvsig.fmap.mapcontrol.MapControl")) continue;
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    class JPanelConsole
    extends JPanel {
        private static final long serialVersionUID = -6651900105647107644L;

        JPanelConsole() {
            BorderLayout layout = new BorderLayout();
            this.setLayout(new BorderLayout());
            TitledBorder border = BorderFactory.createTitledBorder("Console");
            this.setBorder(border);
            this.setLayout(layout);
            this.add((Component)Consola.consolaFrame, "Center");
        }
    }

    class JPanelButtons
    extends JPanel {
        private static final long serialVersionUID = 1529755877776747074L;
        JButton close = null;
        JButton showDetails = null;
        JButton hideDetails = null;
        JPanel console = null;

        JPanelButtons(JPanel console) {
            this.console = console;
            this.setLayout(new FlowLayout());
            this.close = this.getCloseButton();
            this.showDetails = this.getShowDetailsButton();
            this.hideDetails = this.getHideDetailsButton();
            this.add(this.close);
            this.add(this.showDetails);
            this.add(this.hideDetails);
            this.hideConsole();
        }

        private JButton getCloseButton() {
            JButton button = new JButton(PluginServices.getText((Object)this, (String)"aceptar"));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NotificationDialogNew.this.closeWindow();
                }
            });
            return button;
        }

        private JButton getShowDetailsButton() {
            JButton button = new JButton(PluginServices.getText((Object)this, (String)"detalles") + " >>>");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPanelButtons.this.showConsole();
                }
            });
            return button;
        }

        private JButton getHideDetailsButton() {
            JButton button = new JButton(PluginServices.getText((Object)this, (String)"detalles") + " <<<");
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JPanelButtons.this.hideConsole();
                }
            });
            return button;
        }

        public void hideConsole() {
            this.showDetails.setVisible(true);
            this.hideDetails.setVisible(false);
            this.console.setVisible(false);
        }

        public void showConsole() {
            this.showDetails.setVisible(false);
            this.hideDetails.setVisible(true);
            this.console.setVisible(true);
        }
    }

    class JPanelDescription
    extends JPanel {
        private static final long serialVersionUID = 1529755877776747074L;
        JTextArea description = null;
        JLabel image;

        JPanelDescription() {
            GridBagLayout layout = new GridBagLayout();
            this.setLayout(layout);
            Border border = BorderFactory.createEmptyBorder();
            this.setBorder(border);
            this.image = new JLabel();
            this.image.setIcon(IconThemeHelper.getImageIcon((String)"show-console"));
            NotificationDialogNew.this.addComppnent(this, this.image, 0, 0, 1, 1, 0.0, 0.0, 0, 10);
            this.description = new JTextArea();
            this.description.setEditable(false);
            this.description.setOpaque(false);
            this.description.setText("");
            JScrollPane scrollPanel = new JScrollPane(this.description);
            scrollPanel.setBorder(BorderFactory.createEmptyBorder());
            scrollPanel.setPreferredSize(new Dimension(600, 200));
            NotificationDialogNew.this.addComppnent(this, scrollPanel, 1, 0, 1, 1, 1.0, 1.0, 1, 10);
        }

        public String getDescription() {
            return this.description.getText();
        }

        public void setDescription(String description) {
            this.description.setText(description);
        }
    }
}

