/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.ExpressionSyntaxException;
import org.gvsig.expressionevaluator.I18N;
import org.gvsig.expressionevaluator.LexicalAnalyzer;
import org.gvsig.expressionevaluator.spi.DMSNumberFormat;
import org.gvsig.tools.lang.Cloneable;

public abstract class AbstractLexicalAnalyzer
implements LexicalAnalyzer {
    protected static final char EOF = '\u0000';
    private NumberFormat nf;
    private ParsePosition nfPos;
    private Stack<Integer> states;
    private String source;
    private int position = 0;
    private int maxposition = 0;
    private int lineno;
    private int column;
    protected Buffer buffer;
    protected LexicalAnalyzer.Token token;
    protected Map<String, Integer> tokens;
    protected boolean useBracketsForIdentifiers = false;

    public AbstractLexicalAnalyzer(String source) {
        this.source = source;
        this.states = new Stack();
        this.buffer = new Buffer();
        this.token = this.createToken();
        this.nf = NumberFormat.getInstance(Locale.UK);
        this.nf.setGroupingUsed(false);
        this.nfPos = new ParsePosition(0);
        this.tokens = new HashMap<String, Integer>();
    }

    public AbstractLexicalAnalyzer() {
        this(null);
    }

    protected LexicalAnalyzer.Token createToken() {
        return new DefaultToken();
    }

    @Override
    public LexicalAnalyzer clone() throws CloneNotSupportedException {
        AbstractLexicalAnalyzer other = (AbstractLexicalAnalyzer)super.clone();
        other.nf = NumberFormat.getInstance(Locale.UK);
        other.nfPos = new ParsePosition(0);
        other.buffer = this.buffer.clone();
        other.token = this.token.clone();
        other.states = new Stack();
        other.states.addAll(this.states);
        other.tokens = new HashMap<String, Integer>(this.tokens);
        return other;
    }

    @Override
    public void setSource(String source) {
        this.source = source;
        this.position = 0;
        this.maxposition = 0;
    }

    @Override
    public String getSource() {
        return this.source;
    }

    @Override
    public LexicalAnalyzer.Token next() {
        return this.getToken();
    }

    @Override
    public LexicalAnalyzer.Token look() {
        this.save_state();
        try {
            LexicalAnalyzer.Token token = this.getToken();
            return token;
        }
        finally {
            this.restore_state();
        }
    }

    protected abstract LexicalAnalyzer.Token getToken();

    @Override
    public void save_state() {
        this.states.push(this.position);
    }

    @Override
    public void restore_state() {
        this.position = this.states.pop();
    }

    @Override
    public void drop_state() {
        this.states.pop();
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public int getMaxPosition() {
        return this.maxposition;
    }

    private RowCol calcualteRowAndColumn(int position) {
        String s = this.source;
        int max = s.length();
        if (max > position) {
            max = position;
        }
        int line = 1;
        int col = 0;
        for (int i = 0; i < max; ++i) {
            if (s.charAt(i) == '\n') {
                ++line;
                col = 0;
            }
            ++col;
        }
        return new RowCol(line, col);
    }

    @Override
    public int getLine() {
        RowCol rowcol = this.calcualteRowAndColumn(this.position);
        this.lineno = rowcol.row;
        this.column = rowcol.col;
        return this.lineno;
    }

    @Override
    public int getMaxLine() {
        RowCol rowcol = this.calcualteRowAndColumn(this.maxposition);
        return rowcol.row;
    }

    @Override
    public int getColumn() {
        RowCol rowcol = this.calcualteRowAndColumn(this.position);
        this.lineno = rowcol.row;
        this.column = rowcol.col;
        return this.column;
    }

    @Override
    public int getMaxColumn() {
        RowCol rowcol = this.calcualteRowAndColumn(this.maxposition);
        return rowcol.col;
    }

    @Override
    public boolean isEOF() {
        return this.position >= this.source.length();
    }

    protected void skipblanks() {
        if (this.isEOF()) {
            return;
        }
        char ch = this.getch();
        while (ch != '\u0000' && Character.isWhitespace(ch)) {
            ch = this.getch();
        }
        this.ungetch();
    }

    protected char lookch() {
        if (this.position >= this.source.length()) {
            return '\u0000';
        }
        return this.source.charAt(this.position);
    }

    protected char getch() {
        if (this.position >= this.source.length()) {
            return '\u0000';
        }
        ++this.column;
        char ch = this.source.charAt(this.position++);
        if (this.position > this.maxposition) {
            this.maxposition = this.position;
        }
        return ch;
    }

    protected void ungetch() {
        --this.position;
        if (this.position < 0) {
            this.position = 0;
        }
        --this.column;
        if (this.column < 0) {
            this.column = 0;
        }
    }

    protected void parseString() {
        this.buffer.clear();
        char ch = this.getch();
        while (true) {
            if (ch == '\u0000') {
                throw new ExpressionSyntaxException(I18N.End_of_string_was_expected_and_end_of_source_was_found(), this);
            }
            if (ch == '\'') {
                ch = this.getch();
                if (ch == '\u0000') break;
                if (ch != '\'') {
                    this.ungetch();
                    break;
                }
            }
            this.buffer.add(ch);
            ch = this.getch();
        }
        this.token.set(1, this.buffer.toString());
    }

    protected void parseDMSNumber() {
        Object sign = null;
        this.skipblanks();
        char ch = this.getch();
        if (ch != '@') {
            throw new ExpressionSyntaxException(I18N.Wrong_special_number_start(), this);
        }
        final AbstractLexicalAnalyzer la = this;
        DMSNumberFormat parser = new DMSNumberFormat(true){

            @Override
            protected void skipblanks() {
                la.skipblanks();
            }

            @Override
            protected char getch() {
                return la.getch();
            }

            @Override
            public boolean isEOF() {
                return la.isEOF();
            }

            @Override
            protected void ungetch() {
                la.ungetch();
            }
        };
        double dd = parser.parse();
        this.token.set(3, String.format("@%s%d\u00ba %d' %f\"", parser.getSign() < 0 ? "-" : "+", parser.getDegrees(), parser.getMinutes(), parser.getSeconds()), dd);
    }

    protected void parseNumber() {
        this.nfPos.setIndex(this.position);
        Number n = this.nf.parse(this.source, this.nfPos);
        if (this.nfPos.getIndex() == this.position) {
            throw new ExpressionRuntimeException(I18N.Expected_a_number_at_position_XpositionX(this.nfPos.getIndex()));
        }
        String literal = this.source.substring(this.position, this.nfPos.getIndex());
        this.position = this.nfPos.getIndex();
        if (literal.indexOf(46) > -1 || literal.indexOf(44) > -1) {
            n = n.doubleValue();
        }
        if (n instanceof Long) {
            long l = (Long)n;
            if (l > Integer.MIN_VALUE && l < Integer.MAX_VALUE) {
                this.token.set(2, literal, (int)l);
            } else {
                this.token.set(2, literal, n);
            }
        } else if (n instanceof Integer) {
            this.token.set(2, literal, n);
        } else {
            this.token.set(3, literal, n);
        }
    }

    @Override
    public void setUseBracketsForIdentifiers(boolean useBracketsForIdentifiers) {
        this.useBracketsForIdentifiers = useBracketsForIdentifiers;
    }

    @Override
    public boolean getUseBracketsForIdentifiers() {
        return this.useBracketsForIdentifiers;
    }

    @Override
    public String getSourceContext() {
        String s = StringUtils.left((String)this.source, (int)this.maxposition) + "[*]" + StringUtils.mid((String)this.source, (int)this.maxposition, (int)200);
        if (s.length() > 200) {
            s = "..." + StringUtils.mid((String)s, (int)(this.maxposition - 100), (int)200) + "...";
        }
        return s;
    }

    protected class Buffer
    implements Cloneable {
        StringBuilder builder = new StringBuilder();

        public Buffer clone() throws CloneNotSupportedException {
            Buffer other = (Buffer)super.clone();
            other.builder = new StringBuilder(this.builder);
            return other;
        }

        public void clear() {
            this.builder.delete(0, this.builder.length());
        }

        public void add(char ch) {
            this.builder.append(ch);
        }

        public int length() {
            return this.builder.length();
        }

        public String toString() {
            return this.builder.toString();
        }
    }

    protected class DefaultToken
    implements LexicalAnalyzer.Token {
        private int type;
        private String literal;
        private Object value;

        @Override
        public LexicalAnalyzer.Token clone() throws CloneNotSupportedException {
            DefaultToken other = (DefaultToken)super.clone();
            return other;
        }

        @Override
        public void set(int type, String literal) {
            this.set(type, literal, literal);
        }

        @Override
        public void set(int type, String literal, Object value) {
            this.literal = literal;
            this.type = type;
            this.value = value;
        }

        @Override
        public int getType() {
            return this.type;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public String getLiteral() {
            return this.literal;
        }

        @Override
        public void setLiteral(String literal) {
            this.literal = literal;
        }

        @Override
        public boolean is(String ... values) {
            for (String theValue : values) {
                if (!(StringUtils.isBlank((CharSequence)this.literal) ? StringUtils.isBlank((CharSequence)theValue) : !StringUtils.isBlank((CharSequence)theValue) && theValue.trim().equalsIgnoreCase(this.literal.trim()))) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return String.format("{%d,%s,%s}", this.type, Objects.toString(this.literal), Objects.toString(this.value));
        }
    }

    public static class RowCol {
        private final int row;
        private final int col;

        public RowCol(int row, int col) {
            this.row = row;
            this.col = col;
        }
    }
}

