/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.xml;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public class XMLEncodingUtils {
    InputStream _is;

    public XMLEncodingUtils(InputStream is) {
        if (is == null) {
            throw new IllegalArgumentException();
        }
        this._is = is;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getEncoding() {
        int srcCount = 0;
        String enc = null;
        char[] srcBuf = new char[128];
        int chk = 0;
        try {
            int i;
            while (srcCount < 4 && (i = this._is.read()) != -1) {
                chk = chk << 8 | i;
                srcBuf[srcCount++] = (char)i;
            }
            if (srcCount != 4) return enc;
            switch (chk) {
                case 65279: {
                    return "UTF-32BE";
                }
                case -131072: {
                    return "UTF-32LE";
                }
                case 60: {
                    enc = "UTF-32BE";
                    srcBuf[0] = 60;
                    srcCount = 1;
                    return enc;
                }
                case 0x3C000000: {
                    enc = "UTF-32LE";
                    srcBuf[0] = 60;
                    srcCount = 1;
                    return enc;
                }
                case 3932223: {
                    enc = "UTF-16BE";
                    srcBuf[0] = 60;
                    srcBuf[1] = 63;
                    srcCount = 2;
                    return enc;
                }
                case 1006649088: {
                    enc = "UTF-16LE";
                    srcBuf[0] = 60;
                    srcBuf[1] = 63;
                    srcCount = 2;
                    return enc;
                }
                case 1010792557: {
                    while ((i = this._is.read()) != -1) {
                        srcBuf[srcCount++] = (char)i;
                        if (i != 62) continue;
                        String s = new String(srcBuf, 0, srcCount);
                        int i0 = s.indexOf("encoding");
                        if (i0 == -1) break;
                        while (s.charAt(i0) != '\"' && s.charAt(i0) != '\'') {
                            ++i0;
                        }
                        char deli = s.charAt(i0++);
                        int i1 = s.indexOf(deli, i0);
                        enc = s.substring(i0, i1);
                        break;
                    }
                }
                default: {
                    if ((chk & 0xFFFF0000) == -16842752) {
                        enc = "UTF-16BE";
                        srcBuf[0] = (char)(srcBuf[2] << 8 | srcBuf[3]);
                        srcCount = 1;
                        return enc;
                    }
                    if ((chk & 0xFFFF0000) == -131072) {
                        enc = "UTF-16LE";
                        srcBuf[0] = (char)(srcBuf[3] << 8 | srcBuf[2]);
                        srcCount = 1;
                        return enc;
                    }
                    if ((chk & 0xFFFFFF00) != -272908544) return enc;
                    enc = "UTF-8";
                    srcBuf[0] = srcBuf[3];
                    srcCount = 1;
                }
            }
            return enc;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public InputStreamReader getReader() {
        String encoding = this.getEncoding();
        if (encoding == null) {
            return null;
        }
        try {
            return new InputStreamReader(this._is, encoding);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static InputStreamReader getReader(InputStream is) {
        XMLEncodingUtils util = new XMLEncodingUtils(is);
        return util.getReader();
    }

    public static String getEncoding(InputStream is) {
        XMLEncodingUtils util = new XMLEncodingUtils(is);
        return util.getEncoding();
    }

    public static InputStreamReader getReader(File file) throws FileNotFoundException {
        BufferedInputStream bs = new BufferedInputStream(new FileInputStream(file));
        XMLEncodingUtils util = new XMLEncodingUtils(bs);
        return util.getReader();
    }

    public static String getEncoding(File file) throws FileNotFoundException {
        BufferedInputStream bs = new BufferedInputStream(new FileInputStream(file));
        XMLEncodingUtils util = new XMLEncodingUtils(bs);
        return util.getEncoding();
    }
}

