/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.texteditor;

import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import org.gvsig.texteditor.DefaultJTextEditor;
import org.gvsig.texteditor.JTextEditor;
import org.gvsig.texteditor.TextEditorManager;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.viewer.AbstractJViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJTextEditor
extends AbstractJViewer
implements JTextEditor {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultJTextEditor.class);
    protected JPanel panel = new JPanel();
    protected ChangeListenerHelper changeListeners = ToolsSwingLocator.getToolsSwingManager().createChangeListenerHelper();
    protected ActionListener updateCaretPositionListener;

    public AbstractJTextEditor(TextEditorManager factory) {
        super((ViewerFactory)factory);
        JTextComponent textComponent = this.getJTextComponent();
        Document textDocument = textComponent.getDocument();
        textDocument.addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                AbstractJTextEditor.this.changeListeners.fireEvent(new ChangeEvent((Object)AbstractJTextEditor.this));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                AbstractJTextEditor.this.changeListeners.fireEvent(new ChangeEvent((Object)AbstractJTextEditor.this));
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                AbstractJTextEditor.this.changeListeners.fireEvent(new ChangeEvent((Object)AbstractJTextEditor.this));
            }
        });
        textComponent.addCaretListener(e -> {
            if (this.updateCaretPositionListener == null) {
                return;
            }
            int lineNumber = 1;
            int columnNumber = 0;
            int currentPosition = textComponent.getCaretPosition();
            try {
                String strText = textDocument.getText(0, currentPosition);
                char[] arrText = strText.toCharArray();
                for (int i = 0; i < strText.length(); ++i) {
                    if (arrText[i] != '\n') continue;
                    ++lineNumber;
                }
                columnNumber = currentPosition - strText.lastIndexOf(10);
            }
            catch (BadLocationException ble) {
                System.err.println(ble);
            }
            this.updateCaretPositionListener.actionPerformed(new UpdateCaretPositionActionEventImpl((Object)this, lineNumber, columnNumber, true));
        });
    }

    public JComponent asJComponent() {
        return this.panel;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.addChangeListener(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.changeListeners.getChangeListeners();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.removeChangeListener(listener);
    }

    public void removeAllChangeListener() {
        this.changeListeners.removeAllChangeListener();
    }

    public boolean hasChangeListeners() {
        return this.changeListeners.hasChangeListeners();
    }

    public void selectLine(int line) {
        JTextComponent editor = this.getJTextComponent();
        editor.requestFocusInWindow();
        String code = editor.getText();
        int lineCounter = 0;
        int initialSelection = 0;
        int finalSelection = 0;
        for (int j = 0; j < code.length(); ++j) {
            if (code.charAt(j) != '\n') continue;
            if (++lineCounter == line - 1) {
                initialSelection = j;
            }
            if (lineCounter != line && (finalSelection != 0 || j != code.length() - 1)) continue;
            finalSelection = j;
        }
        editor.select(initialSelection, finalSelection);
    }

    public void gotoline(int line) {
        JTextComponent component = this.getJTextComponent();
        Element root = component.getDocument().getDefaultRootElement();
        int lineno = Math.max(line, 1);
        int maxlines = root.getElementCount();
        lineno = Math.min(lineno, maxlines);
        int startOfLineOffset = root.getElement(lineno - 1).getStartOffset();
        component.setCaretPosition(startOfLineOffset);
        Container container = SwingUtilities.getAncestorOfClass(JViewport.class, component);
        if (container == null) {
            return;
        }
        int y = -1;
        try {
            Rectangle r = component.modelToView(component.getCaretPosition());
            JViewport viewport = (JViewport)container;
            int extentHeight = viewport.getExtentSize().height;
            int viewHeight = viewport.getViewSize().height;
            y = Math.max(0, r.y - (extentHeight - r.height) / 2);
            y = Math.min(y, viewHeight - extentHeight);
            viewport.setViewPosition(new Point(0, y));
        }
        catch (BadLocationException ble) {
            LOGGER.warn("Can't set view position (y=" + y + ").", (Throwable)ble);
        }
        try {
            component.setCaretPosition(startOfLineOffset + 1);
        }
        catch (Exception e) {
            LOGGER.warn("Can't set caret position (position=" + (startOfLineOffset + 1) + ").", (Throwable)e);
        }
    }

    public int getLineCount() {
        JTextComponent textComponent = this.getJTextComponent();
        Element map = textComponent.getDocument().getDefaultRootElement();
        return map.getElementCount();
    }

    public void addUpdateCaretPositionActionListener(ActionListener listener) {
        this.updateCaretPositionListener = listener;
    }

    public boolean isModified() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    protected static class UpdateCaretPositionActionEventImpl
    extends ActionEvent
    implements JTextEditor.UpdateCaretPositionActionEvent {
        private final int line;
        private final int column;
        private final boolean hasLineAndCol;

        public UpdateCaretPositionActionEventImpl(Object comp, int line, int column, boolean hasLineAndCol) {
            super(comp, 1, "UpdateCaretPosition");
            this.line = line;
            this.column = column;
            this.hasLineAndCol = hasLineAndCol;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public boolean hasLineAndColumn() {
            return this.hasLineAndCol;
        }
    }
}

