/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClipboardMonitor
extends Observable
implements ClipboardOwner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClipboardMonitor.class);
    private static ClipboardMonitor monitor = null;
    private final Map<Observer, FlavorListener> listeners = new HashMap<Observer, FlavorListener>();

    public ClipboardMonitor() {
        this.gainOwnership();
    }

    public Clipboard getClipboard() {
        Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
        return clip;
    }

    private void gainOwnership() {
        LOGGER.debug("gainOwnership");
        Clipboard clip = this.getClipboard();
        try {
            Transferable content = clip.getContents(null);
            clip.setContents(content, this);
            this.setChanged();
            this.notifyObservers(content);
        }
        catch (Exception ex) {
            LOGGER.debug("Can't gain clipboard ownership", (Throwable)ex);
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        LOGGER.debug("lostOwnership");
        new Thread(() -> {
            try {
                Thread.sleep(200L);
                this.gainOwnership();
            }
            catch (Exception e) {
                LOGGER.debug("Retry gain clipboard ownership failed", (Throwable)e);
            }
        }).start();
    }

    public static final ClipboardMonitor getMonitor() {
        if (monitor == null) {
            monitor = new ClipboardMonitor();
        }
        return monitor;
    }

    public void put(String data) {
        this.put(data, "text/plain");
    }

    public void put(String data, String type) {
        Transferable ss;
        LOGGER.debug("put " + StringUtils.abbreviate((String)data, (int)30));
        switch (StringUtils.lowerCase((String)type)) {
            default: {
                ss = new StringSelection(data);
                break;
            }
            case "text/html": {
                ss = new HtmlSelection(data);
            }
        }
        Clipboard clip = this.getClipboard();
        ClipboardOwner owner = ss;
        clip.setContents(ss, owner);
    }

    public String getString() {
        LOGGER.debug("getString");
        try {
            Clipboard clip = this.getClipboard();
            Transferable t = clip.getContents(null);
            if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return (String)t.getTransferData(DataFlavor.stringFlavor);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("getString return null", (Throwable)ex);
            return null;
        }
        LOGGER.debug("getString return null");
        return null;
    }

    public boolean hasString() {
        LOGGER.debug("hasString");
        try {
            Clipboard clip = this.getClipboard();
            boolean available = clip.isDataFlavorAvailable(DataFlavor.stringFlavor);
            return !available;
        }
        catch (Exception ex) {
            LOGGER.debug("hasString error, return true", (Throwable)ex);
            return true;
        }
    }

    @Override
    public synchronized void addObserver(Observer o) {
        LOGGER.debug("addObserver " + Objects.toString(o));
        if (o == null || this.listeners.containsKey(o)) {
            return;
        }
        Clipboard clip = this.getClipboard();
        FlavorListener listener = e -> o.update(monitor, null);
        super.addObserver(o);
        clip.addFlavorListener(listener);
        this.listeners.put(o, listener);
    }

    @Override
    public synchronized void deleteObserver(Observer o) {
        LOGGER.debug("deleteObserver" + Objects.toString(o));
        if (o == null) {
            return;
        }
        Clipboard clip = this.getClipboard();
        FlavorListener listener = this.listeners.get(o);
        super.deleteObserver(o);
        this.listeners.remove(o);
        if (listener == null) {
            return;
        }
        clip.removeFlavorListener(listener);
    }

    private static class HtmlSelection
    implements Transferable,
    ClipboardOwner {
        private static List<DataFlavor> htmlFlavors = new ArrayList<DataFlavor>(3);
        private final String html;

        public HtmlSelection(String html) {
            this.html = html;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return htmlFlavors.toArray(new DataFlavor[htmlFlavors.size()]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return htmlFlavors.contains(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
            if (String.class.equals(flavor.getRepresentationClass())) {
                return this.html;
            }
            if (Reader.class.equals(flavor.getRepresentationClass())) {
                return new StringReader(this.html);
            }
            if (InputStream.class.equals(flavor.getRepresentationClass())) {
                return new StringBufferInputStream(this.html);
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }

        static {
            try {
                htmlFlavors.add(new DataFlavor("text/html;class=java.lang.String"));
            }
            catch (ClassNotFoundException ex) {
                LOGGER.warn("", (Throwable)ex);
            }
            try {
                htmlFlavors.add(new DataFlavor("text/html;class=java.io.Reader"));
            }
            catch (ClassNotFoundException ex) {
                LOGGER.warn("", (Throwable)ex);
            }
            try {
                htmlFlavors.add(new DataFlavor("text/html;charset=unicode;class=java.io.InputStream"));
            }
            catch (ClassNotFoundException ex) {
                LOGGER.warn("", (Throwable)ex);
            }
        }
    }
}

