/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability.spinner.model;

import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.AbstractSpinnerModel;
import javax.swing.JFormattedTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.swing.impl.usability.spinner.editor.DynFieldFormatter;

public class NullSpinnerHandler {
    private DynFieldFormatter formatter = null;
    private DynField dynField = null;
    private Locale loc = null;
    private Object iniValue = null;
    private Object curValue = null;
    private Comparable start = null;
    private Comparable end = null;
    private AbstractSpinnerModel model = null;
    private boolean isNotFirstTime;
    private boolean valid = true;

    private static int getInitialCalendarField(DynField dynField, Locale loc) {
        DynFieldFormatter formatter = DynFieldFormatter.getInstance(dynField, loc);
        return formatter.getCalendarField();
    }

    public NullSpinnerHandler(DynField field) {
        this(field, Locale.getDefault());
    }

    public NullSpinnerHandler(DynField dynField, Locale loc) {
        this.init(dynField, loc, (Comparable)dynField.getMinValue(), (Comparable)dynField.getMaxValue());
    }

    public Date getDate() {
        if (this.formatter.isDate()) {
            return (Date)this.getValue();
        }
        return null;
    }

    public NullSpinnerDateModel getDateModel() {
        if (this.model == null) {
            this.model = new NullSpinnerDateModel(this, this.start, this.end);
        }
        return (NullSpinnerDateModel)this.model;
    }

    public DynFieldFormatter getDynFieldFormatter() {
        return this.formatter;
    }

    private Comparable getEnd() {
        return this.end;
    }

    public DynFieldFormatter getFormatter() {
        return this.formatter;
    }

    public AbstractSpinnerModel getModel() {
        if (this.model == null) {
            this.initDefaultModel();
            if (this.formatter.isNumber()) {
                return new SpinnerNumberModel();
            }
            return this.model;
        }
        return this.model;
    }

    public Object getNextValue() {
        Object next = this.formatter.getNextValue(this.getValue());
        return this.getEnd() == null || this.getEnd().compareTo(next) >= 0 ? next : null;
    }

    public NullSpinnerNumberModel getNumberModel() {
        if (this.model == null) {
            this.model = new NullSpinnerNumberModel(this, this.start, this.end);
        }
        return (NullSpinnerNumberModel)this.model;
    }

    public Object getPreviousValue() {
        Object prev = this.formatter.getPreviousValue(this.getValue());
        return this.getStart() == null || this.getStart().compareTo(prev) <= 0 ? prev : null;
    }

    private Comparable getStart() {
        return this.start;
    }

    public Object getValue() {
        if (this.isFirstTime() && this.curValue == null) {
            if (this.formatter.isDate()) {
                return new Date();
            }
            if (this.isNumber()) {
                return 0;
            }
            return null;
        }
        return this.curValue;
    }

    public Object getValueFromTexField(JFormattedTextField textField) {
        String txt = textField.getText();
        return this.parseOrNull(txt);
    }

    protected void init(DynField dynField, Locale loc, Comparable start, Comparable end) {
        this.dynField = dynField;
        this.loc = loc;
        this.start = start;
        this.end = end;
        this.formatter = DynFieldFormatter.getInstance(dynField, loc);
        this.initDefaultModel();
    }

    private void initDefaultModel() {
        this.model = this.formatter.isDate() ? new NullSpinnerDateModel(this, this.start, this.end) : new NullSpinnerNumberModel(this, this.start, this.end);
    }

    public boolean isDate() {
        return this.formatter.isDate();
    }

    private boolean isFirstTime() {
        return !this.isNotFirstTime;
    }

    public boolean isNumber() {
        return this.formatter.isNumber();
    }

    public Object parseOrNull(String txt) {
        try {
            return this.formatter.parse(txt);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public void setDefaultValueOn(boolean isSet) {
        this.isNotFirstTime = !isSet;
    }

    public void setValue(Object value) {
        if (this.isFirstTime() || value == null || value.equals("")) {
            this.curValue = null;
        } else {
            if (!this.formatter.isValidType(value)) {
                throw new IllegalArgumentException(value.toString());
            }
            this.curValue = value;
        }
    }

    public class NullSpinnerNumberModel
    extends SpinnerNumberModel {
        private static final long serialVersionUID = -3645717385964526394L;
        private NullSpinnerHandler model;

        public NullSpinnerNumberModel(NullSpinnerHandler theModel, Comparable minimum, Comparable maximum) {
            super((Number)0, minimum, maximum, (Number)1);
            this.model = theModel;
            this.setValue(null);
        }

        public Object format(Object value) {
            return this.model.getFormatter().format(value);
        }

        public NumberFormat getFormat() {
            return NullSpinnerHandler.this.getFormatter().getNumberFormatter();
        }

        @Override
        public Object getNextValue() {
            return this.model.getNextValue();
        }

        @Override
        public Object getPreviousValue() {
            return this.model.getPreviousValue();
        }

        @Override
        public Object getValue() {
            return this.model.getValue();
        }

        @Override
        public void setValue(Object value) {
            this.model.setValue(value);
            if (NullSpinnerHandler.this.isFirstTime()) {
                this.fireStateChanged();
            }
            if (value != null) {
                super.setValue(value);
            }
        }
    }

    public class NullSpinnerDateModel
    extends SpinnerDateModel {
        private static final long serialVersionUID = -400734052278449520L;
        private NullSpinnerHandler model;

        public NullSpinnerDateModel(NullSpinnerHandler theModel, Comparable start, Comparable end) {
            super(new Date(), start, end, NullSpinnerHandler.this.getDynFieldFormatter().getCalendarField());
            this.model = theModel;
            this.setValue(null);
        }

        public Object format(Object value) {
            return this.model.getFormatter().format(value);
        }

        @Override
        public int getCalendarField() {
            return super.getCalendarField();
        }

        public SimpleDateFormat getFormat() {
            return NullSpinnerHandler.this.getFormatter().getDateFormatter();
        }

        @Override
        public Object getNextValue() {
            Object next = this.model.getNextValue();
            return next;
        }

        @Override
        public Object getPreviousValue() {
            Object prev = this.model.getPreviousValue();
            return prev;
        }

        @Override
        public Object getValue() {
            return this.model.getValue();
        }

        @Override
        public void setCalendarField(int calendarField) {
            try {
                super.setCalendarField(calendarField);
            }
            catch (IllegalArgumentException e) {
                if (this.getValue() != null) {
                    throw new IllegalArgumentException(e);
                }
                this.fireStateChanged();
            }
            this.model.getFormatter().setCalendarField(this.getCalendarField());
        }

        @Override
        public void setValue(Object value) {
            Object oldValue = this.getValue();
            this.model.setValue(value);
            if (value != null) {
                super.setValue(value);
            } else if (oldValue == null) {
                if (value != null) {
                    this.fireStateChanged();
                }
            } else if (!oldValue.equals(value)) {
                this.fireStateChanged();
            }
        }
    }
}

