/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.image;

import com.jeta.forms.gui.effects.ImagePainter;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class ImageComponent
extends JComponent {
    private int m_halign = 0;
    private int m_valign = 3;
    private Icon m_icon;
    private Dimension m_pref_size = new Dimension(16, 16);
    private ImagePainter m_painter;
    private Rectangle m_painter_rect;

    public int getHorizontalAlignment() {
        return this.m_halign;
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        this.m_pref_size.setSize(insets.left + insets.right + this.getIconWidth(), insets.top + insets.bottom + this.getIconHeight());
        return this.m_pref_size;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getVerticalAlignment() {
        return this.m_valign;
    }

    public Icon getIcon() {
        return this.m_icon;
    }

    public int getIconHeight() {
        if (this.m_icon == null) {
            return 16;
        }
        return this.m_icon.getIconHeight();
    }

    public int getIconWidth() {
        if (this.m_icon == null) {
            return 16;
        }
        return this.m_icon.getIconWidth();
    }

    public void setHorizontalAlignment(int align) {
        this.m_halign = align;
        this.m_painter = null;
    }

    public void setIcon(Icon icon) {
        this.m_icon = icon;
        if (icon != null) {
            this.m_pref_size.setSize(Math.max(16, icon.getIconWidth()), Math.max(16, icon.getIconHeight()));
        }
        this.m_painter = null;
        this.revalidate();
    }

    public void setVerticalAlignment(int align) {
        this.m_valign = align;
        this.m_painter = null;
    }

    public void paintComponent(Graphics g) {
        Color bg;
        super.paintComponent(g);
        Insets insets = this.getInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        if (this.m_painter == null) {
            this.m_painter = new ImagePainter(this.m_icon, this.getHorizontalAlignment(), this.getVerticalAlignment());
        }
        if (this.m_painter_rect == null) {
            this.m_painter_rect = new Rectangle();
        }
        this.m_painter_rect.setBounds(x, y, width, height);
        if (this.isOpaque() && (bg = this.getBackground()) != null) {
            Rectangle clip_rect = g.getClipBounds();
            if (this.m_painter_rect.intersects(clip_rect)) {
                Rectangle rect = this.m_painter_rect.intersection(clip_rect);
                g.setClip(rect.x, rect.y, rect.width, rect.height);
                Color old_color = g.getColor();
                g.setColor(bg);
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
                g.setColor(old_color);
            }
            g.setClip(clip_rect.x, clip_rect.y, clip_rect.width, clip_rect.height);
        }
        this.m_painter.paint(this, g, this.m_painter_rect);
    }
}

