/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.line;

import com.jeta.forms.components.line.LineComponent;
import com.jeta.forms.store.properties.LineProperty;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.util.Iterator;

public class VerticalLineComponent
extends LineComponent {
    public static final int CENTER = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;

    public boolean isHorizontal() {
        return false;
    }

    public void paintComponent(Graphics g) {
        int x1 = 0;
        int y1 = 0;
        int y2 = 0;
        Insets insets = this.getInsets();
        y1 = insets.top;
        int height = this.getHeight() - (insets.top + insets.bottom);
        if (height < 0) {
            return;
        }
        y2 = height + y1;
        int total_thickness = this.getThickness();
        if (this.getPosition() == 0) {
            x1 = (this.getWidth() - total_thickness) / 2;
        } else if (this.getPosition() != 1) {
            x1 = this.getWidth() - total_thickness;
        }
        Graphics2D g2 = (Graphics2D)g;
        Stroke old_stroke = g2.getStroke();
        Color old_color = g2.getColor();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            LineProperty prop = (LineProperty)iter.next();
            Stroke s = prop.getStroke();
            g2.setStroke(s);
            g2.setColor(prop.getColor());
            int x = x1 + prop.getThickness() / 2;
            g2.drawLine(x, y1, x, y2);
            x1 += prop.getThickness();
        }
        g2.setColor(old_color);
        g2.setStroke(old_stroke);
    }
}

