/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;

public class IconMemento
extends AbstractJETAPersistable
implements Cloneable {
    static final long serialVersionUID = 7200914507339096976L;
    public static final int VERSION = 1;
    private byte[] m_image_bytes;
    private transient ImageIcon m_icon;

    public IconMemento() {
    }

    public IconMemento(File f) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(fis);
            byte[] buff = new byte[1024];
            int read = bis.read(buff);
            while (read > 0) {
                bos.write(buff, 0, read);
                read = bis.read(buff);
            }
            if (bos.size() > 0) {
                this.m_image_bytes = bos.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ImageIcon getImageIcon() {
        if (this.m_icon == null && this.m_image_bytes != null) {
            this.m_icon = new ImageIcon(this.m_image_bytes);
        }
        return this.m_icon;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj) {
            return false;
        }
        if (!(obj instanceof IconMemento)) {
            return false;
        }
        IconMemento iconMemento = (IconMemento)obj;
        if (null == this.m_image_bytes && null != iconMemento.m_image_bytes || null != this.m_image_bytes && null == iconMemento.m_image_bytes || null != this.m_image_bytes && null != iconMemento.m_image_bytes && iconMemento.m_image_bytes.length != this.m_image_bytes.length) {
            return false;
        }
        for (int i = 0; i < this.m_image_bytes.length; ++i) {
            if (this.m_image_bytes[i] == iconMemento.m_image_bytes[i]) continue;
            return false;
        }
        return true;
    }

    public Object clone() {
        IconMemento other = null;
        try {
            other = (IconMemento)super.clone();
            other.m_image_bytes = this.m_image_bytes;
            this.m_icon = null;
            other.m_icon = this.getImageIcon();
            this.m_icon = null;
            this.getImageIcon();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return other;
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        int version = in.readVersion();
        this.m_image_bytes = (byte[])in.readObject("imagebytes");
    }

    public void write(JETAObjectOutput out) throws IOException {
        out.writeVersion(1);
        out.writeObject("imagebytes", this.m_image_bytes);
    }
}

