/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.properties;

import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jeta.forms.store.properties.JETAProperty;
import com.jeta.forms.store.properties.TransformProperty;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class TransformOptionsProperty
extends JETAProperty
implements TransformProperty {
    static final long serialVersionUID = -1652327155513571580L;
    public static final int VERSION = 3;
    private transient HashMap m_options = new HashMap();
    private int m_default_value;
    private Method m_getter;
    private String m_getter_name;
    private Method m_setter;
    private String m_setter_name;
    private transient JETABean m_bean;

    public TransformOptionsProperty() {
    }

    public TransformOptionsProperty(String propName, String getMethod, String setMethod, Object[][] options) {
        super(propName);
        this.m_getter_name = getMethod;
        this.m_setter_name = setMethod;
        for (int index = 0; index < options.length; ++index) {
            String option = (String)options[index][0];
            Integer value = (Integer)options[index][1];
            if (index == 0) {
                this.m_default_value = value;
            }
            this.m_options.put(option, value);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Integer) {
            return ((Integer)obj).intValue() == this.getPropertyValue();
        }
        if (obj instanceof TransformOptionsProperty) {
            TransformOptionsProperty prop = (TransformOptionsProperty)obj;
            return prop.getPropertyValue() == this.getPropertyValue();
        }
        return false;
    }

    public JETABean getBean() {
        return this.m_bean;
    }

    public Object getCurrentItem() {
        int pval = this.getPropertyValue();
        Iterator iter = this.m_options.keySet().iterator();
        while (iter.hasNext()) {
            String option = (String)iter.next();
            Integer ival = (Integer)this.m_options.get(option);
            if (ival != pval) continue;
            return option;
        }
        return null;
    }

    public Collection getOptions() {
        return this.m_options.keySet();
    }

    public int getPropertyValue() {
        try {
            Integer ival = (Integer)this.m_getter.invoke((Object)this.getBean().getDelegate(), new Object[0]);
            return ival;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.m_default_value;
        }
    }

    public Method getWriteMethod() {
        return this.m_setter;
    }

    public boolean isTransient() {
        return true;
    }

    public void setBean(JETABean bean) {
        try {
            this.m_bean = bean;
            if (bean != null) {
                Class<?> c = bean.getDelegate().getClass();
                this.m_getter = c.getMethod(this.m_getter_name, new Class[0]);
                this.m_setter = c.getMethod(this.m_setter_name, Integer.TYPE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setValue(Object option) {
        try {
            Integer ival = null;
            if (option instanceof String) {
                String sval = (String)option;
                ival = (Integer)this.m_options.get(sval);
                if (ival == null) {
                    try {
                        ival = Integer.valueOf((String)option);
                    }
                    catch (Exception e) {}
                }
            } else if (option instanceof Integer) {
                ival = (Integer)option;
            } else if (option instanceof TransformOptionsProperty) {
                ival = new Integer(((TransformOptionsProperty)option).getPropertyValue());
            }
            if (ival != null) {
                this.m_setter.invoke((Object)this.getBean().getDelegate(), ival);
            }
        }
        catch (Exception e) {
            if (option != null) {
                System.out.println("TransformOptionsProperty.setValue failed: " + option.getClass());
            }
            e.printStackTrace();
        }
    }

    public int size() {
        return this.m_options.size();
    }

    public void updateBean(JETABean jbean) {
        this.setBean(jbean);
    }

    public void read(JETAObjectInput in) throws ClassNotFoundException, IOException {
        int version = in.readVersion();
    }

    public void write(JETAObjectOutput out) throws IOException {
        out.writeVersion(3);
    }

    public String toString() {
        return "transform value: " + this.getPropertyValue();
    }
}

