/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.panelGroup;

import java.awt.BorderLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.gui.beans.Messages;
import org.gvsig.gui.beans.buttonspanel.IButtonsPanel;
import org.gvsig.gui.beans.panelGroup.IPanelGroup;
import org.gvsig.gui.beans.panelGroup.exceptions.EmptyPanelGroupException;
import org.gvsig.gui.beans.panelGroup.exceptions.EmptyPanelGroupGUIException;
import org.gvsig.gui.beans.panelGroup.exceptions.ListCouldntAddPanelException;
import org.gvsig.gui.beans.panelGroup.exceptions.PanelBaseException;
import org.gvsig.gui.beans.panelGroup.exceptions.PanelWithNoPreferredSizeDefinedException;
import org.gvsig.gui.beans.panelGroup.loaders.IPanelGroupLoader;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPanelGroup
extends JPanel
implements ChangeListener,
IPanelGroup,
IButtonsPanel {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPanelGroup.class);
    protected boolean accepted;
    private Hashtable properties;
    protected Object reference;
    protected ArrayList<IPanel> registeredPanels = null;
    protected final byte ACCEPT_ACTION = 0;
    protected final byte APPLY_ACTION = 1;
    protected final byte CANCEL_ACTION = (byte)2;
    protected IPanelGroup parentPanelGroup;

    public AbstractPanelGroup(Object reference) {
        this.reference = reference;
        this.initialize();
    }

    public final Collection<IPanel> values() {
        return this.registeredPanels;
    }

    protected void initialize() {
        this.accepted = false;
        this.parentPanelGroup = null;
        this.properties = new Hashtable();
        this.setLayout(new BorderLayout());
        this.registeredPanels = new ArrayList();
    }

    @Override
    public void loadPanels(IPanelGroupLoader loader) throws ListCouldntAddPanelException, EmptyPanelGroupException, EmptyPanelGroupGUIException {
        ArrayList<IPanel> panels = new ArrayList<IPanel>();
        ListCouldntAddPanelException listBaseException = null;
        if (this.registeredPanels.size() > 0) {
            return;
        }
        try {
            loader.loadPanels(panels);
        }
        catch (Exception e) {
            listBaseException = this.addCouldntAddPanelException(listBaseException, e);
        }
        if (panels.size() == 0) {
            if (listBaseException == null) {
                throw new EmptyPanelGroupException();
            }
            listBaseException.add((Object)new EmptyPanelGroupException());
            throw listBaseException;
        }
        for (IPanel panel : panels) {
            try {
                if (panel.remainsWithItsDefaultPreferredSize()) {
                    PanelWithNoPreferredSizeDefinedException exception = new PanelWithNoPreferredSizeDefinedException(panel.getLabel());
                    throw exception;
                }
                this.loadPanel(panel);
            }
            catch (PanelWithNoPreferredSizeDefinedException e) {
                logger.debug(Messages.getText("panel_adding_exception"), (Throwable)((Object)e));
                listBaseException = this.addCouldntAddPanelException(listBaseException, (Exception)((Object)e));
            }
            catch (Exception e) {
                logger.debug(Messages.getText("panel_adding_exception"), (Throwable)e);
                if (panel == null) {
                    listBaseException = this.addCouldntAddPanelException(listBaseException, (Exception)((Object)new PanelBaseException(e, "")));
                    continue;
                }
                listBaseException = this.addCouldntAddPanelException(listBaseException, (Exception)((Object)new PanelBaseException(e, panel.getLabel())));
            }
        }
        if (this.getPanelCount() == 0) {
            if (listBaseException != null) {
                listBaseException = this.addCouldntAddPanelException(listBaseException, (Exception)((Object)new EmptyPanelGroupException()));
                throw listBaseException;
            }
            throw new EmptyPanelGroupException();
        }
        if (this.getPanelInGUICount() == 0) {
            if (listBaseException != null) {
                listBaseException = this.addCouldntAddPanelException(listBaseException, (Exception)((Object)new EmptyPanelGroupGUIException()));
                throw listBaseException;
            }
            throw new EmptyPanelGroupGUIException();
        }
        if (listBaseException != null) {
            throw listBaseException;
        }
    }

    private ListCouldntAddPanelException addCouldntAddPanelException(ListCouldntAddPanelException l, Exception e) {
        if (l == null) {
            l = new ListCouldntAddPanelException();
        }
        l.add(e);
        return l;
    }

    protected void loadPanel(IPanel panel) {
        panel.setPanelGroup(this);
        panel.setReference(this.reference);
        this.registeredPanels.add(panel);
    }

    protected boolean belongsThisGroup(IPanel panel) {
        if (panel == null) {
            return false;
        }
        if (this.getReference() == null) {
            return panel.getReference() == null;
        }
        if (panel.getReference() == null) {
            return false;
        }
        return this.getReference().equals(panel.getReference());
    }

    @Override
    public boolean isAccepted() {
        return this.accepted;
    }

    @Override
    public Hashtable getProperties() {
        return this.properties;
    }

    @Override
    public Object getReference() {
        return this.reference;
    }

    @Override
    public void updateReference(Object reference) {
        this.reference = reference;
        for (Object panel : this.values().toArray()) {
            ((AbstractPanel)panel).setReference(reference);
        }
    }

    @Override
    public void accept() {
        this.executeAction((byte)0);
    }

    @Override
    public void apply() {
        this.executeAction((byte)1);
    }

    @Override
    public void cancel() {
        this.executeAction((byte)2);
    }

    @Override
    public abstract void stateChanged(ChangeEvent var1);

    @Override
    public void addPanel(IPanel panel) throws BaseException {
        BaseException baseException = null;
        ListCouldntAddPanelException listBaseException = null;
        if (panel.remainsWithItsDefaultPreferredSize()) {
            baseException = new PanelWithNoPreferredSizeDefinedException(panel.getLabel());
        } else {
            try {
                if (panel.getLabel() != null && this.belongsThisGroup(panel)) {
                    this.loadPanel(panel);
                }
            }
            catch (Exception e) {
                logger.debug(Messages.getText("panel_adding_exception"), (Throwable)e);
                baseException = panel == null ? new PanelBaseException(e, "") : new PanelBaseException(e, panel.getLabel());
            }
        }
        if (this.registeredPanels.size() == 0) {
            if (baseException == null) {
                throw new EmptyPanelGroupException();
            }
            listBaseException = new ListCouldntAddPanelException();
            listBaseException.add(baseException);
            listBaseException.add((Object)new EmptyPanelGroupException());
        }
        if (this.getPanelInGUICount() == 0) {
            if (listBaseException == null) {
                if (baseException == null) {
                    throw new EmptyPanelGroupGUIException();
                }
                listBaseException = new ListCouldntAddPanelException();
                listBaseException.add(baseException);
                listBaseException.add((Object)new EmptyPanelGroupGUIException());
            } else {
                listBaseException.add((Object)new EmptyPanelGroupGUIException());
            }
        }
        if (listBaseException != null) {
            throw listBaseException;
        }
        if (baseException != null) {
            throw baseException;
        }
    }

    @Override
    public void removePanel(IPanel panel) {
        if (this.belongsThisGroup(panel) && panel.getLabel() != null) {
            this.unLoadPanel(panel);
        }
    }

    protected void unLoadPanel(IPanel panel) {
        this.registeredPanels.remove(panel);
    }

    @Override
    public int getPanelCount() {
        return this.registeredPanels.size();
    }

    private void executeAction(byte action) {
        for (IPanel panel : this.registeredPanels) {
            if (!panel.hasChanged() && (panel.hasChanged() || !panel.isAlwaysApplicable())) continue;
            switch (action) {
                case 0: {
                    this.accepted = true;
                    panel.accept();
                    panel.resetChangedStatus();
                    break;
                }
                case 1: {
                    this.accepted = false;
                    panel.apply();
                    panel.resetChangedStatus();
                    break;
                }
                case 2: {
                    this.accepted = false;
                    panel.cancel();
                    panel.resetChangedStatus();
                }
            }
        }
    }

    @Override
    public void setParentPanelGroup(IPanelGroup parent) {
        this.parentPanelGroup = parent;
    }

    @Override
    public boolean isEnabledAcceptButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledAcceptButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledApplyButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledApplyButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledCancelButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledCancelButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledCloseButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledCloseButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledExitButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledExitButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledHideDetailsButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledHideDetailsButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledNoButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledNoButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledPauseButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledPauseButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledRestartButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledRestartButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledSaveButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledSaveButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledSeeDetailsButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledSeeDetailsButton();
        }
        return false;
    }

    @Override
    public boolean isEnabledYesButton() {
        if (this.parentPanelGroup != null) {
            return ((IButtonsPanel)((Object)this.parentPanelGroup)).isEnabledYesButton();
        }
        return false;
    }

    @Override
    public void setEnabledAcceptButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledAcceptButton(b);
        }
    }

    @Override
    public void setEnabledApplyButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledApplyButton(b);
        }
    }

    @Override
    public void setEnabledCancelButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledCancelButton(b);
        }
    }

    @Override
    public void setEnabledCloseButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledCloseButton(b);
        }
    }

    @Override
    public void setEnabledExitButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledExitButton(b);
        }
    }

    @Override
    public void setEnabledHideDetailsButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledHideDetailsButton(b);
        }
    }

    @Override
    public void setEnabledNoButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledNoButton(b);
        }
    }

    @Override
    public void setEnabledPauseButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledPauseButton(b);
        }
    }

    @Override
    public void setEnabledRestartButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledRestartButton(b);
        }
    }

    @Override
    public void setEnabledSaveButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledSaveButton(b);
        }
    }

    @Override
    public void setEnabledSeeDetailsButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledSeeDetailsButton(b);
        }
    }

    @Override
    public void setEnabledYesButton(boolean b) {
        if (this.parentPanelGroup != null) {
            ((IButtonsPanel)((Object)this.parentPanelGroup)).setEnabledYesButton(b);
        }
    }
}

