/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gui.beans.panelGroup.tabbedPanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.gui.beans.panelGroup.PanelGroupManager;
import org.gvsig.gui.beans.panelGroup.panels.AbstractPanel;
import org.gvsig.gui.beans.panelGroup.panels.IPanel;

public class TabbedPanel
extends AbstractPanelGroup
implements Serializable {
    private static final long serialVersionUID = -7979646227156641693L;
    private JTabbedPane jTabbedPane;

    public TabbedPanel(Object reference) {
        super(reference);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.setLayout(new BorderLayout());
        this.add((Component)this.getJTabbedPane(), "Center");
    }

    protected JTabbedPane getJTabbedPane() {
        if (this.jTabbedPane == null) {
            this.jTabbedPane = new JTabbedPane();
            this.jTabbedPane.setTabLayoutPolicy(1);
            this.jTabbedPane.addContainerListener(new ContainerListener(){

                @Override
                public void componentAdded(ContainerEvent e) {
                    TabbedPanel.this.dispatchEvent(e);
                }

                @Override
                public void componentRemoved(ContainerEvent e) {
                    TabbedPanel.this.dispatchEvent(e);
                }
            });
            this.jTabbedPane.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Object source = e.getSource();
                    if (source == null || !(source instanceof JTabbedPane)) {
                        return;
                    }
                    Container parent = ((JTabbedPane)source).getParent();
                    if (!(parent instanceof TabbedPanel)) {
                        return;
                    }
                    Component object = ((JTabbedPane)source).getSelectedComponent();
                    if (object != null && object instanceof AbstractPanel) {
                        ((TabbedPanel)parent).stateChanged(new ChangeEvent(object));
                    }
                }
            });
        }
        return this.jTabbedPane;
    }

    public int getSelectedIndex() {
        return this.getJTabbedPane().getSelectedIndex();
    }

    public void setSelectedIndex(int position) {
        this.getJTabbedPane().setSelectedIndex(position);
    }

    @Override
    protected void loadPanel(IPanel panel) {
        super.loadPanel(panel);
        if (((AbstractPanel)panel).isVisible()) {
            this.getJTabbedPane().add(panel.getLabel(), (JPanel)((Object)panel));
        }
    }

    @Override
    protected void unLoadPanel(IPanel panel) {
        super.unLoadPanel(panel);
        this.getJTabbedPane().remove((Component)((Object)panel));
    }

    @Override
    public IPanel getActivePanel() {
        if (this.getJTabbedPane().getSelectedComponent() instanceof IPanel) {
            return (IPanel)((Object)this.getJTabbedPane().getSelectedComponent());
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.registeredPanels.size() == 0) {
            return;
        }
        Object object = e.getSource();
        if (object != null) {
            ((IPanel)object).selected();
        }
    }

    @Override
    public synchronized void setPanelInGUI(IPanel panel, boolean b) {
        if (this.registeredPanels.size() == 0) {
            return;
        }
        if (this.registeredPanels.indexOf(panel) == -1) {
            return;
        }
        Vector<Component> tabPanels = new Vector<Component>(0, this.getJTabbedPane().getTabCount());
        for (int i = this.getJTabbedPane().getTabCount() - 1; i >= 0; --i) {
            if (!(this.getJTabbedPane().getComponentAt(i) instanceof AbstractPanel)) continue;
            tabPanels.add(this.getJTabbedPane().getComponentAt(i));
            this.getJTabbedPane().removeTabAt(i);
        }
        if (b) {
            for (IPanel regPanel : this.registeredPanels) {
                if (regPanel.equals(panel)) {
                    this.getJTabbedPane().add(panel.getLabel(), (JPanel)((Object)panel));
                    continue;
                }
                if (tabPanels.indexOf((Component)((Object)regPanel)) == -1) continue;
                this.getJTabbedPane().add(regPanel.getLabel(), (JPanel)((Object)regPanel));
            }
        } else {
            for (IPanel regPanel : this.registeredPanels) {
                if (tabPanels.indexOf((Component)((Object)regPanel)) == -1 || regPanel.equals(panel)) continue;
                this.getJTabbedPane().add(regPanel.getLabel(), (JPanel)((Object)regPanel));
            }
        }
        this.repaint();
    }

    @Override
    public synchronized boolean isPanelInGUI(IPanel panel) {
        if (!this.registeredPanels.contains(panel)) {
            return false;
        }
        for (int i = this.getJTabbedPane().getTabCount() - 1; i >= 0; --i) {
            Component object = this.getJTabbedPane().getComponentAt(i);
            if (!(object instanceof AbstractPanel) || !object.equals(panel)) continue;
            return true;
        }
        return false;
    }

    public void setEnabledAt(int index, boolean enabled) {
        this.getJTabbedPane().setEnabledAt(index, enabled);
    }

    public boolean isEnabledAt(int index) {
        return this.getJTabbedPane().isEnabledAt(index);
    }

    @Override
    public int getPanelInGUICount() {
        return this.getJTabbedPane().getTabCount();
    }

    public void addChangeListener(ChangeListener l) {
        this.getJTabbedPane().addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    static {
        PanelGroupManager.getManager().registerPanelGroup(TabbedPanel.class);
        PanelGroupManager.getManager().setDefaultType(TabbedPanel.class);
    }
}

