/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.List;
import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLocator;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.impl.InstanceUtils;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class CallStaticMethodFunction
extends AbstractFunction {
    public static final String NAME = "CALL_STATIC";

    public CallStaticMethodFunction() {
        super("Programming", NAME, Range.between((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), "The CALL_STATIC() function call a static mehod of a class.", "CALL_STATIC( className, methodName, arguments... )", null, "Object", false);
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        String theClassName = this.getStr(args, 0);
        String theMethodName = this.getStr(args, 1);
        int firstArg = 2;
        if (theClassName == null) {
            throw new NullPointerException("A class name name was expected to invoke and a null class name was received");
        }
        if (theMethodName == null) {
            throw new NullPointerException("A method name was expected to invoke and a null method name was received");
        }
        List loaders = ExpressionEvaluatorLocator.getManager().getClassLoaders();
        Class<?> theClass = null;
        for (ClassLoader loader : loaders) {
            try {
                theClass = loader.loadClass(theClassName);
                if (theClass == null) continue;
                break;
            }
            catch (Throwable throwable) {
            }
        }
        if (theClass == null) {
            throw new ExpressionRuntimeException("Can't localte the class '" + theClassName + "'.");
        }
        Object r = InstanceUtils.callmethod(theClass, theMethodName, args);
        return r;
    }
}

