/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.packagebuilder;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.gui.beans.wizard.WizardPanel;
import org.gvsig.gui.beans.wizard.WizardPanelActionListener;
import org.gvsig.gui.beans.wizard.WizardPanelWithLogo;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.InstallerLocator;
import org.gvsig.installer.lib.api.InstallerManager;
import org.gvsig.installer.lib.api.PackageInfo;
import org.gvsig.installer.swing.api.packagebuilder.PackageBuildder;
import org.gvsig.installer.swing.impl.packagebuilder.options.OutputOption;
import org.gvsig.installer.swing.impl.packagebuilder.options.PackageInfoOption;
import org.gvsig.installer.swing.impl.packagebuilder.options.ProgressOption;
import org.gvsig.installer.swing.impl.packagebuilder.options.SelectFolderToPackagingOption;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.locator.LocatorException;

public class BasePackageWizard
extends JPanel
implements WizardPanel,
PackageBuildder {
    private static final long serialVersionUID = 9205891710214122265L;
    private WizardPanelWithLogo wizardPanelWithLogo = null;
    private org.gvsig.tools.packageutils.PackageInfo packageInfo = null;
    private File folderToPackaging = null;
    private WizardPanelActionListener wizardListenerAdapter = null;
    private OutputOption outputOption = null;
    private OptionPanel packageInfoOption = null;
    private OptionPanel progressOption = null;
    private SelectFolderToPackagingOption selectFolderToPackagingOption = null;
    private final String packageType;
    private final File baseFolder;
    private final File outputFolder;
    private Set<PackageBuildder.BeforePackingListener> beforePackingListener = new HashSet<PackageBuildder.BeforePackingListener>();

    public BasePackageWizard(String packageType, File selectionFolder, File outputFolder) throws LocatorException {
        this.packageType = packageType;
        this.baseFolder = selectionFolder;
        this.outputFolder = outputFolder;
        this.initComponents();
    }

    private void initComponents() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.wizardPanelWithLogo = new WizardPanelWithLogo();
        this.setCancelButtonEnabled(true);
        this.setFinishButtonEnabled(false);
        this.packageInfo = ToolsLocator.getPackageManager().createPackageInfo();
        this.packageInfo.setType(this.packageType);
        this.addSelectFolderToPackagingOption(i18nManager.getTranslation("_Seleccione_la_carpeta_que_desea_empaquetar"));
        this.addPackageInfoOptionPanel();
        this.addOutputOptionPanel();
        this.addProgressOptionPanel();
        this.setFolderToPackaging(this.baseFolder);
        this.wizardPanelWithLogo.setWizardListener((WizardPanel)this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.wizardPanelWithLogo, "Center");
        this.setPreferredSize(new Dimension(700, 550));
    }

    public String getPackageType() {
        return this.packageType;
    }

    protected void addPackageInfoOptionPanel() {
        if (this.packageInfoOption == null) {
            this.packageInfoOption = new PackageInfoOption(this);
        }
        this.wizardPanelWithLogo.addOptionPanel(this.packageInfoOption);
    }

    protected void addOutputOptionPanel() {
        if (this.outputOption == null) {
            this.outputOption = new OutputOption(this);
        }
        this.wizardPanelWithLogo.addOptionPanel((OptionPanel)this.outputOption);
    }

    protected void addProgressOptionPanel() {
        if (this.progressOption == null) {
            this.progressOption = new ProgressOption(this);
        }
        this.wizardPanelWithLogo.addOptionPanel(this.progressOption);
    }

    protected void addSelectFolderToPackagingOption(String message) {
        if (this.selectFolderToPackagingOption == null) {
            this.selectFolderToPackagingOption = new SelectFolderToPackagingOption(this, message);
        }
        this.wizardPanelWithLogo.addOptionPanel((OptionPanel)this.selectFolderToPackagingOption);
    }

    public void setNextButtonEnabled(boolean isEnabled) {
        this.wizardPanelWithLogo.setNextButtonEnabled(isEnabled);
    }

    public void setCancelButtonEnabled(boolean isEnabled) {
        this.wizardPanelWithLogo.setCancelButtonEnabled(isEnabled);
    }

    public void setFinishButtonEnabled(boolean isEnabled) {
        this.wizardPanelWithLogo.setFinishButtonEnabled(isEnabled);
    }

    public void setBackButtonEnabled(boolean isEnabled) {
        this.wizardPanelWithLogo.setBackButtonEnabled(isEnabled);
    }

    public WizardPanelActionListener getWizardPanelActionListener() {
        if (this.wizardListenerAdapter == null) {
            this.wizardListenerAdapter = new WizardPanelActionListener(){

                public void finish(WizardPanel wizardPanel) {
                    BasePackageWizard.this.setVisible(false);
                }

                public void cancel(WizardPanel wizardPanel) {
                    BasePackageWizard.this.setVisible(false);
                }
            };
        }
        return this.wizardListenerAdapter;
    }

    public void setWizardPanelActionListener(WizardPanelActionListener wizardActionListener) {
        throw new RuntimeException("Esto falta por ver que hace");
    }

    public void setFolderToPackaging(File file) {
        this.folderToPackaging = file;
        if (this.selectFolderToPackagingOption != null) {
            this.selectFolderToPackagingOption.setCurrentFolder(file);
        }
        this.packageInfo.setType(this.packageType);
        this.packageInfo.setCode(FilenameUtils.getBaseName((String)file.getName()));
        this.packageInfo.setName(FilenameUtils.getBaseName((String)file.getName()));
        File pinfo = new File(file, "package.info");
        if (pinfo.exists()) {
            try {
                ToolsLocator.getPackageManager().readPacakgeInfo(this.packageInfo, pinfo);
                this.packageInfo.setType(this.packageType);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public File getFolderToPackaging() {
        return this.folderToPackaging;
    }

    public org.gvsig.tools.packageutils.PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public URL getDownloadURL() {
        return this.outputOption.getDownloadURL();
    }

    public File getPackageIndexFile() {
        return this.outputOption.getPackageIndexFile();
    }

    public boolean shouldCreateIndex() {
        return this.outputOption.shouldCreateIndex();
    }

    public File getPackageFile() {
        return this.outputOption.getPackageFile();
    }

    public void addOptionPanel(OptionPanel optionPanel) {
        this.wizardPanelWithLogo.addOptionPanel(optionPanel);
    }

    public File getDefaultPackageBundleFile() {
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        String fname = installerManager.getPackageFileName((PackageInfo)this.getPackageInfo());
        return new File(this.outputFolder, fname);
    }

    public File getDefaultPackageIndexBundleFile() {
        InstallerManager installerManager = InstallerLocator.getInstallerManager();
        String fname = installerManager.getPackageIndexFileName((PackageInfo)this.getPackageInfo());
        return new File(this.outputFolder, fname);
    }

    public JComponent asJComponent() {
        return this;
    }

    public void addBeforePackingListener(PackageBuildder.BeforePackingListener listener) {
        this.beforePackingListener.add(listener);
    }

    public Collection<PackageBuildder.BeforePackingListener> getBeforePackingListeners() {
        return this.beforePackingListener;
    }
}

