/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.desktop.installer.izpack;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class CopyJRE {
    public static final long ONE_KB = 1024L;
    public static final long ONE_MB = 0x100000L;
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;

    public boolean run(AbstractUIProcessHandler handler, String[] args) {
        File java_home = new File(System.getProperties().getProperty("java.home"));
        File f = new File(java_home, "package.info");
        if (!f.exists()) {
            return true;
        }
        handler.logOutput("Installing JRE plugin (This may take a while)...", false);
        try {
            File installation_folder = new File(args[0]);
            File target = CopyJRE.getFile(installation_folder, "gvSIG", "extensiones", "jre");
            CopyJRE.doCopyDirectory(java_home, target, true);
            File java_bin = CopyJRE.getFile(installation_folder, "gvSIG", "extensiones", "jre", "bin", "java");
            java_bin.setExecutable(true, false);
        }
        catch (Exception ex) {
            handler.logOutput("Can't install JRE plugin. " + ex.toString(), false);
            return false;
        }
        handler.logOutput("JRE plugin installed.", false);
        return true;
    }

    public static File getFile(File directory, String ... names) {
        if (directory == null) {
            throw new NullPointerException("directory must not be null");
        }
        if (names == null) {
            throw new NullPointerException("names must not be null");
        }
        File file = directory;
        for (String name : names) {
            file = new File(file, name);
        }
        return file;
    }

    private static void doCopyDirectory(File srcDir, File destDir, boolean preserveFileDate) throws IOException {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles == null) {
            throw new IOException("Failed to list contents of " + srcDir);
        }
        if (destDir.exists()) {
            if (!destDir.isDirectory()) {
                throw new IOException("Destination '" + destDir + "' exists but is not a directory");
            }
        } else if (!destDir.mkdirs() && !destDir.isDirectory()) {
            throw new IOException("Destination '" + destDir + "' directory cannot be created");
        }
        if (!destDir.canWrite()) {
            throw new IOException("Destination '" + destDir + "' cannot be written to");
        }
        for (File srcFile : srcFiles) {
            File dstFile = new File(destDir, srcFile.getName());
            if (srcFile.isDirectory()) {
                CopyJRE.doCopyDirectory(srcFile, dstFile, preserveFileDate);
                continue;
            }
            CopyJRE.doCopyFile(srcFile, dstFile, preserveFileDate);
        }
        if (preserveFileDate) {
            destDir.setLastModified(srcDir.lastModified());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doCopyFile(File srcFile, File destFile, boolean preserveFileDate) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' exists but is a directory");
        }
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel input = null;
        FileChannel output = null;
        try {
            long remain;
            long bytesCopied;
            fis = new FileInputStream(srcFile);
            fos = new FileOutputStream(destFile);
            input = fis.getChannel();
            output = fos.getChannel();
            long size = input.size();
            long count = 0L;
            for (long pos = 0L; pos < size && (bytesCopied = output.transferFrom(input, pos, count = (remain = size - pos) > 0x1E00000L ? 0x1E00000L : remain)) != 0L; pos += bytesCopied) {
            }
        }
        catch (Throwable throwable) {
            CopyJRE.closeQuietly(output, fos, input, fis);
            throw throwable;
        }
        CopyJRE.closeQuietly(output, fos, input, fis);
        long srcLen = srcFile.length();
        long dstLen = destFile.length();
        if (srcLen != dstLen) {
            throw new IOException("Failed to copy full contents from '" + srcFile + "' to '" + destFile + "' Expected length: " + srcLen + " Actual: " + dstLen);
        }
        if (preserveFileDate) {
            destFile.setLastModified(srcFile.lastModified());
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            CopyJRE.closeQuietly(closeable);
        }
    }
}

