/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.tools.swing.api.ChangeListenerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChangeListenerHelper
implements ChangeListenerHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultChangeListenerHelper.class);
    protected Set listeners = new HashSet();
    protected boolean enabled = true;

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public ChangeListener[] getChangeListeners() {
        return this.listeners.toArray(new ChangeListener[this.listeners.size()]);
    }

    public boolean hasChangeListeners() {
        return !this.listeners.isEmpty();
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void removeAllChangeListener() {
        this.listeners.clear();
    }

    public void fireEvent() {
        this.fireEvent(null);
    }

    public void fireEvent(ChangeEvent event) {
        if (!this.enabled) {
            return;
        }
        for (ChangeListener listener : this.listeners) {
            try {
                listener.stateChanged(event);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't fire change event,", (Throwable)ex);
            }
        }
    }

    public void setEnabledEvents(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabledEvents() {
        return this.enabled;
    }
}

