/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.gvsig.tools.swing.api.CompoundIcon;

public class DefaultCompoundIcon
implements CompoundIcon {
    private Icon[] icons;
    private int orientation;
    private int gap;
    private int alignmentX = 0;
    private int alignmentY = 0;

    public DefaultCompoundIcon(Icon ... icons) {
        this(0, icons);
    }

    public DefaultCompoundIcon(int orientation, Icon ... icons) {
        this(orientation, 0, icons);
    }

    public DefaultCompoundIcon(int orientation, int gap, Icon ... icons) {
        this(orientation, gap, 0, 0, icons);
    }

    public DefaultCompoundIcon(int orientation, int gap, int alignmentX, int alignmentY, Icon ... icons) {
        switch (orientation) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrent value '" + orientation + "' of orientation.");
            }
        }
        switch (alignmentX) {
            case 0: 
            case 2: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrent value '" + alignmentX + "' of AlignmentX.");
            }
        }
        switch (alignmentY) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrent value '" + alignmentY + "' of AlignmentY.");
            }
        }
        this.orientation = orientation;
        this.gap = gap;
        this.alignmentX = alignmentX;
        this.alignmentY = alignmentY;
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] != null) continue;
            String message = "Icon (" + i + ") cannot be null";
            throw new IllegalArgumentException(message);
        }
        this.icons = icons;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getGap() {
        return this.gap;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public int getIconCount() {
        return this.icons.length;
    }

    public Icon getIcon(int index) {
        return this.icons[index];
    }

    public int getIconWidth() {
        int width = 0;
        if (this.orientation == 0) {
            width += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                width += icon.getIconWidth();
            }
        } else {
            for (Icon icon : this.icons) {
                width = Math.max(width, icon.getIconWidth());
            }
        }
        return width;
    }

    public int getIconHeight() {
        int height = 0;
        if (this.orientation == 1) {
            height += (this.icons.length - 1) * this.gap;
            for (Icon icon : this.icons) {
                height += icon.getIconHeight();
            }
        } else {
            for (Icon icon : this.icons) {
                height = Math.max(height, icon.getIconHeight());
            }
        }
        return height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        switch (this.orientation) {
            default: {
                int height = this.getIconHeight();
                for (Icon icon : this.icons) {
                    int iconY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
                    icon.paintIcon(c, g, x, y + iconY);
                    x += icon.getIconWidth() + this.gap;
                }
                break;
            }
            case 1: {
                int width = this.getIconWidth();
                for (Icon icon : this.icons) {
                    int iconX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
                    icon.paintIcon(c, g, x + iconX, y);
                    y += icon.getIconHeight() + this.gap;
                }
                break;
            }
            case -1: {
                int width = this.getIconWidth();
                int height = this.getIconHeight();
                for (Icon icon : this.icons) {
                    int iconX = this.getOffset(width, icon.getIconWidth(), this.alignmentX);
                    int iconY = this.getOffset(height, icon.getIconHeight(), this.alignmentY);
                    icon.paintIcon(c, g, x + iconX, y + iconY);
                }
            }
        }
    }

    private int getOffset(int maxValue, int iconValue, int alignment) {
        float offset;
        switch (alignment) {
            case 1: {
                offset = (float)(maxValue - iconValue) * 0.0f;
                break;
            }
            case 2: {
                offset = (float)(maxValue - iconValue) * 0.0f;
                break;
            }
            default: {
                offset = (float)(maxValue - iconValue) * 0.5f;
                break;
            }
            case 3: {
                offset = (float)(maxValue - iconValue) * 1.0f;
                break;
            }
            case 4: {
                offset = (float)(maxValue - iconValue) * 1.0f;
            }
        }
        return Math.round(offset);
    }
}

