/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.gvsig.tools.swing.api.TableColumnAdjuster;

public class TableColumnAdjusterImpl
implements PropertyChangeListener,
TableModelListener,
TableColumnAdjuster {
    private JTable table;
    private int spacing;
    private boolean isColumnHeaderIncluded;
    private boolean isColumnDataIncluded;
    private boolean isOnlyAdjustLarger;
    private boolean isDynamicAdjustment;
    private Map<TableColumn, Integer> columnSizes;
    private JScrollPane scrollPane;
    private int sugestedLastColumnWidth;
    private ComponentListener lastColumnAdjuster;

    protected TableColumnAdjusterImpl(JTable table) {
        this(table, null, 6);
    }

    protected TableColumnAdjusterImpl(JTable table, JScrollPane scrollPane, int spacing) {
        this.scrollPane = scrollPane;
        this.lastColumnAdjuster = null;
        this.sugestedLastColumnWidth = 0;
        this.columnSizes = new HashMap<TableColumn, Integer>();
        this.table = table;
        this.spacing = spacing;
        if (this.scrollPane == null) {
            this.scrollPane = this.findScrollPane();
        }
        if (this.scrollPane != null) {
            this.lastColumnAdjuster = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    TableColumnAdjusterImpl.this.updateLastColumnWidth();
                }
            };
            this.scrollPane.addComponentListener(this.lastColumnAdjuster);
        }
        this.setColumnHeaderIncluded(true);
        this.setColumnDataIncluded(false);
        this.setOnlyAdjustLarger(false);
        this.setDynamicAdjustment(false);
    }

    public static TableColumnAdjusterImpl install(JTable table) {
        table.setAutoResizeMode(0);
        TableColumnAdjusterImpl tca = new TableColumnAdjusterImpl(table);
        table.addPropertyChangeListener(tca);
        tca.adjustColumns();
        return tca;
    }

    public void uninstall() {
        this.setDynamicAdjustment(false);
        if (this.lastColumnAdjuster != null) {
            this.table.removeComponentListener(this.lastColumnAdjuster);
        }
        this.table.removePropertyChangeListener(this);
    }

    private JScrollPane findScrollPane() {
        JViewport viewport;
        if (this.table.getParent() instanceof JViewport && (viewport = (JViewport)this.table.getParent()).getParent() instanceof JScrollPane) {
            JScrollPane sp = (JScrollPane)viewport.getParent();
            return sp;
        }
        return null;
    }

    private void updateLastColumnWidth() {
        TableColumnModel tcm = this.table.getColumnModel();
        if (tcm.getColumnCount() < 1) {
            return;
        }
        if (this.sugestedLastColumnWidth < 1) {
            this.sugestedLastColumnWidth = tcm.getColumn(tcm.getColumnCount() - 1).getWidth();
        }
        int with = 0;
        int lastColumn = tcm.getColumnCount() - 1;
        for (int i = 0; i < lastColumn; ++i) {
            with += tcm.getColumn(i).getWidth();
        }
        int visibleWith = this.scrollPane.getWidth();
        if (this.scrollPane.getVerticalScrollBar().isVisible()) {
            visibleWith -= this.scrollPane.getVerticalScrollBar().getWidth();
        }
        if (visibleWith > with + this.sugestedLastColumnWidth) {
            int lastColumnWidth = visibleWith - with;
            tcm.getColumn(lastColumn).setWidth(lastColumnWidth);
        } else {
            tcm.getColumn(lastColumn).setWidth(this.sugestedLastColumnWidth);
        }
        this.table.getTableHeader().setResizingColumn(tcm.getColumn(lastColumn));
    }

    public void adjustColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            this.adjustColumn(i);
        }
    }

    public void adjustColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        int columnHeaderWidth = this.getColumnHeaderWidth(column);
        int columnDataWidth = this.getColumnDataWidth(column);
        int preferredWidth = Math.max(columnHeaderWidth, columnDataWidth);
        this.updateTableColumn(column, preferredWidth);
    }

    private int getColumnHeaderWidth(int column) {
        if (!this.isColumnHeaderIncluded) {
            return 0;
        }
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Object value = tableColumn.getHeaderValue();
        TableCellRenderer renderer = tableColumn.getHeaderRenderer();
        if (renderer == null) {
            renderer = this.table.getTableHeader().getDefaultRenderer();
        }
        Component c = renderer.getTableCellRendererComponent(this.table, value, false, false, -1, column);
        return c.getPreferredSize().width;
    }

    private int getColumnDataWidth(int column) {
        if (!this.isColumnDataIncluded) {
            return 0;
        }
        int preferredWidth = 0;
        int maxWidth = this.table.getColumnModel().getColumn(column).getMaxWidth();
        for (int row = 0; row < this.table.getRowCount() && (preferredWidth = Math.max(preferredWidth, this.getCellDataWidth(row, column))) < maxWidth; ++row) {
        }
        return preferredWidth;
    }

    private int getCellDataWidth(int row, int column) {
        TableCellRenderer cellRenderer = this.table.getCellRenderer(row, column);
        Component c = this.table.prepareRenderer(cellRenderer, row, column);
        int width = c.getPreferredSize().width + this.table.getIntercellSpacing().width;
        return width;
    }

    private void updateTableColumn(int column, int width) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        if (!tableColumn.getResizable()) {
            return;
        }
        width += this.spacing;
        if (this.isOnlyAdjustLarger) {
            width = Math.max(width, tableColumn.getPreferredWidth());
        }
        this.columnSizes.put(tableColumn, tableColumn.getWidth());
        this.table.getTableHeader().setResizingColumn(tableColumn);
        tableColumn.setWidth(width);
    }

    public void restoreColumns() {
        TableColumnModel tcm = this.table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(); ++i) {
            this.restoreColumn(i);
        }
    }

    private void restoreColumn(int column) {
        TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
        Integer width = this.columnSizes.get(tableColumn);
        if (width != null) {
            this.table.getTableHeader().setResizingColumn(tableColumn);
            tableColumn.setWidth(width);
        }
    }

    public TableColumnAdjusterImpl setColumnHeaderIncluded(boolean isColumnHeaderIncluded) {
        this.isColumnHeaderIncluded = isColumnHeaderIncluded;
        return this;
    }

    public TableColumnAdjusterImpl setColumnDataIncluded(boolean isColumnDataIncluded) {
        this.isColumnDataIncluded = isColumnDataIncluded;
        return this;
    }

    public TableColumnAdjusterImpl setOnlyAdjustLarger(boolean isOnlyAdjustLarger) {
        this.isOnlyAdjustLarger = isOnlyAdjustLarger;
        return this;
    }

    public TableColumnAdjusterImpl setDynamicAdjustment(boolean isDynamicAdjustment) {
        if (this.isDynamicAdjustment != isDynamicAdjustment) {
            if (isDynamicAdjustment) {
                this.table.getModel().addTableModelListener(this);
            } else {
                this.table.getModel().removeTableModelListener(this);
            }
        }
        this.isDynamicAdjustment = isDynamicAdjustment;
        return this;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if ("model".equals(e.getPropertyName())) {
            if (this.isDynamicAdjustment) {
                TableModel model = (TableModel)e.getOldValue();
                model.removeTableModelListener(this);
                model = (TableModel)e.getNewValue();
                model.addTableModelListener(this);
            }
            this.adjustColumns();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (!this.isColumnDataIncluded) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            int column = this.table.convertColumnIndexToView(e.getColumn());
            if (e.getType() == 0 && column != -1) {
                if (this.isOnlyAdjustLarger) {
                    int row = e.getFirstRow();
                    TableColumn tableColumn = this.table.getColumnModel().getColumn(column);
                    if (tableColumn.getResizable()) {
                        int width = this.getCellDataWidth(row, column);
                        this.updateTableColumn(column, width);
                    }
                } else {
                    this.adjustColumn(column);
                }
            } else {
                this.adjustColumns();
            }
        });
    }

    private void installActions() {
        this.installColumnAction(true, true, "adjustColumn", "control ADD");
        this.installColumnAction(false, true, "adjustColumns", "control shift ADD");
        this.installColumnAction(true, false, "restoreColumn", "control SUBTRACT");
        this.installColumnAction(false, false, "restoreColumns", "control shift SUBTRACT");
        this.installToggleAction(true, false, "toggleDynamic", "control MULTIPLY");
        this.installToggleAction(false, true, "toggleLarger", "control DIVIDE");
    }

    private void installColumnAction(boolean isSelectedColumn, boolean isAdjust, String key, String keyStroke) {
        ColumnAction action = new ColumnAction(isSelectedColumn, isAdjust);
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        this.table.getInputMap().put(ks, key);
        this.table.getActionMap().put(key, action);
    }

    private void installToggleAction(boolean isToggleDynamic, boolean isToggleLarger, String key, String keyStroke) {
        ToggleAction action = new ToggleAction(isToggleDynamic, isToggleLarger);
        KeyStroke ks = KeyStroke.getKeyStroke(keyStroke);
        this.table.getInputMap().put(ks, key);
        this.table.getActionMap().put(key, action);
    }

    class ToggleAction
    extends AbstractAction {
        private final boolean isToggleDynamic;
        private final boolean isToggleLarger;

        public ToggleAction(boolean isToggleDynamic, boolean isToggleLarger) {
            this.isToggleDynamic = isToggleDynamic;
            this.isToggleLarger = isToggleLarger;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isToggleDynamic) {
                TableColumnAdjusterImpl.this.setDynamicAdjustment(!TableColumnAdjusterImpl.this.isDynamicAdjustment);
                return;
            }
            if (this.isToggleLarger) {
                TableColumnAdjusterImpl.this.setOnlyAdjustLarger(!TableColumnAdjusterImpl.this.isOnlyAdjustLarger);
                return;
            }
        }
    }

    class ColumnAction
    extends AbstractAction {
        private final boolean isSelectedColumn;
        private final boolean isAdjust;

        public ColumnAction(boolean isSelectedColumn, boolean isAdjust) {
            this.isSelectedColumn = isSelectedColumn;
            this.isAdjust = isAdjust;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.isSelectedColumn) {
                int[] columns = TableColumnAdjusterImpl.this.table.getSelectedColumns();
                for (int i = 0; i < columns.length; ++i) {
                    if (this.isAdjust) {
                        TableColumnAdjusterImpl.this.adjustColumn(columns[i]);
                        continue;
                    }
                    TableColumnAdjusterImpl.this.restoreColumn(columns[i]);
                }
            } else if (this.isAdjust) {
                TableColumnAdjusterImpl.this.adjustColumns();
            } else {
                TableColumnAdjusterImpl.this.restoreColumns();
            }
        }
    }
}

