/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller.nullablespinner;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import javax.swing.Action;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import org.gvsig.tools.swing.impl.pickercontroller.nullablespinner.NullableNumberEditorFormatter;

public class NullableEditor
extends JSpinner.DefaultEditor {
    private static final Action DISABLED_ACTION = new DisabledAction();

    public NullableEditor(JSpinner spinner) {
        super(spinner);
    }

    @Override
    public void dismiss(JSpinner spinner) {
        spinner.removeChangeListener(this);
    }

    @Override
    public JSpinner getSpinner() {
        for (Container c = this; c != null; c = c.getParent()) {
            if (!(c instanceof JSpinner)) continue;
            return (JSpinner)c;
        }
        return null;
    }

    @Override
    public JFormattedTextField getTextField() {
        return (JFormattedTextField)this.getComponent(0);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSpinner spinner = (JSpinner)e.getSource();
        this.getTextField().setValue(spinner.getValue());
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        JSpinner spinner = this.getSpinner();
        if (spinner == null) {
            return;
        }
        Object source = e.getSource();
        String name = e.getPropertyName();
        if (source instanceof JFormattedTextField) {
            JFormattedTextField.AbstractFormatter formatter;
            Object newValue;
            if ("value".equals(name)) {
                Object lastValue = spinner.getValue();
                try {
                    spinner.setValue(this.getTextField().getValue());
                }
                catch (IllegalArgumentException iae) {
                    try {
                        ((JFormattedTextField)source).setValue(lastValue);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            } else if ("editValid".equals(name) && (newValue = e.getNewValue()) instanceof Boolean && ((Boolean)newValue).booleanValue() && (formatter = this.getTextField().getFormatter()) instanceof NullableNumberEditorFormatter) {
                ((NullableNumberEditorFormatter)formatter).decorateTextField((Boolean)newValue);
            }
        }
    }

    @Override
    public void addLayoutComponent(String name, Component child) {
    }

    @Override
    public void removeLayoutComponent(Component child) {
    }

    private Dimension insetSize(Container parent) {
        Insets insets = parent.getInsets();
        int w = insets.left + insets.right;
        int h = insets.top + insets.bottom;
        return new Dimension(w, h);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Dimension preferredSize = this.insetSize(parent);
        if (parent.getComponentCount() > 0) {
            Dimension childSize = this.getComponent(0).getPreferredSize();
            preferredSize.width += childSize.width;
            preferredSize.height += childSize.height;
        }
        return preferredSize;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        Dimension minimumSize = this.insetSize(parent);
        if (parent.getComponentCount() > 0) {
            Dimension childSize = this.getComponent(0).getMinimumSize();
            minimumSize.width += childSize.width;
            minimumSize.height += childSize.height;
        }
        return minimumSize;
    }

    @Override
    public void layoutContainer(Container parent) {
        if (parent.getComponentCount() > 0) {
            Insets insets = parent.getInsets();
            int w = parent.getWidth() - (insets.left + insets.right);
            int h = parent.getHeight() - (insets.top + insets.bottom);
            this.getComponent(0).setBounds(insets.left, insets.top, w, h);
        }
    }

    @Override
    public void commitEdit() throws ParseException {
        JFormattedTextField ftf = this.getTextField();
        ftf.commitEdit();
    }

    @Override
    public int getBaseline(int width, int height) {
        super.getBaseline(width, height);
        Insets insets = this.getInsets();
        width = width - insets.left - insets.right;
        height = height - insets.top - insets.bottom;
        int baseline = this.getComponent(0).getBaseline(width, height);
        if (baseline >= 0) {
            return baseline + insets.top;
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return this.getComponent(0).getBaselineResizeBehavior();
    }

    private static class DisabledAction
    implements Action {
        private DisabledAction() {
        }

        @Override
        public Object getValue(String key) {
            return null;
        }

        @Override
        public void putValue(String key, Object value) {
        }

        @Override
        public void setEnabled(boolean b) {
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener l) {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
        }
    }
}

