/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.MutableSymbolTable;
import org.gvsig.expressionevaluator.PrettyFormatter;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.impl.DefaultInterpreter;
import org.gvsig.expressionevaluator.impl.HostExpressionUtils;
import org.gvsig.expressionevaluator.impl.function.programming.BreakFunction;
import org.gvsig.expressionevaluator.impl.function.programming.ReturnFunction;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class CodeBlockWithExceptFunction
extends AbstractFunction {
    public static final String NAME = "BLOCK_EXCEPT";

    public CodeBlockWithExceptFunction() {
        super("Programming", NAME, Range.between((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), "Evaluate each of the arguments sequentially.", "BLOCK_EXCEPT( {{arguments...}} )", null, "Object", false);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean useArgumentsInsteadObjects() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object call(Interpreter interpreter, Codes args) throws Exception {
        Object value = null;
        Code exceptionCode = (Code)args.get(args.size() - 2);
        Code declareCode = (Code)args.get(args.size() - 1);
        if (declareCode != null) {
            try {
                value = ((DefaultInterpreter)interpreter).runCode(declareCode);
            }
            catch (Exception ex) {
                if (exceptionCode == null) {
                    LOGGER.warn("Error in DECLARE calling " + this.code2string(declareCode), (Throwable)ex);
                    throw ex;
                }
                value = ((DefaultInterpreter)interpreter).runCode(exceptionCode);
            }
        }
        for (int argn = 0; argn < args.size() - 2; ++argn) {
            Code statement = (Code)args.get(argn);
            try {
                statement = HostExpressionUtils.resolveHostExpressions(statement, interpreter);
                value = ((DefaultInterpreter)interpreter).runCode(statement);
                continue;
            }
            catch (BreakFunction.BreakException | ReturnFunction.ReturnException ex) {
                throw ex;
            }
            catch (Exception ex) {
                if (exceptionCode == null) {
                    LOGGER.warn("Error in BEGIN/END calling line " + argn + ", " + this.code2string(statement), (Throwable)ex);
                    throw ex;
                }
                SymbolTable symbolTable = interpreter.getSymbolTable();
                if (symbolTable instanceof MutableSymbolTable) {
                    ((MutableSymbolTable)symbolTable).setVar("@ErrorMessage", (Object)ex.getMessage());
                    ((MutableSymbolTable)symbolTable).setVar("@ErrorStatement", (Object)this.getErrorStatement(statement));
                    ((MutableSymbolTable)symbolTable).setVar("@ErrorContext", (Object)this.getErrorContext(symbolTable));
                }
                value = ((DefaultInterpreter)interpreter).runCode(exceptionCode);
            }
        }
        return value;
    }

    private String getErrorContext(SymbolTable symbolTable) {
        try {
            StringBuilder builder = new StringBuilder();
            ArrayList names = new ArrayList(symbolTable.variables());
            Collections.sort(names);
            for (String name : names) {
                if (StringUtils.equalsIgnoreCase((CharSequence)"@ErrorContext", (CharSequence)name)) continue;
                String value = "##ERROR##";
                try {
                    value = Objects.toString(symbolTable.value(name));
                }
                catch (Throwable t) {
                    LOGGER.debug("Can't retrieve value for '" + name + "'.", t);
                }
                builder.append(name);
                builder.append("=");
                builder.append(value);
                builder.append(";\n");
            }
            return builder.toString();
        }
        catch (Throwable t) {
            return "##ERROR##";
        }
    }

    private String getErrorStatement(Code statement) {
        try {
            return statement.toString();
        }
        catch (Throwable t) {
            return "Unknown";
        }
    }

    private String code2string(Code code) {
        try {
            return Objects.toString(code, "");
        }
        catch (Exception ex2) {
            return "unknown";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(Codes args, Formatter<Code> formatter) {
        Code exceptionCode = (Code)args.get(args.size() - 2);
        Code declareCode = (Code)args.get(args.size() - 1);
        PrettyFormatter builder = PrettyFormatter.get(formatter);
        try {
            builder.push();
            if (declareCode != null) {
                builder.append((Object)"DECLARE ");
                builder.indent();
                if (Code.isFunction((Code)exceptionCode, (String)"BLOCK")) {
                    Code.Callable block = (Code.Callable)declareCode;
                    for (Code parameter : block.parameters()) {
                        builder.nl();
                        builder.append((Object)parameter.toString(formatter));
                        builder.append((Object)"; ");
                    }
                } else {
                    builder.nl();
                    builder.append((Object)declareCode.toString(formatter));
                }
                builder.unindent();
                builder.nl();
            }
            builder.append((Object)"BEGIN ");
            builder.indent();
            for (int argn = 0; argn < args.size() - 2; ++argn) {
                Code statement = (Code)args.get(argn);
                builder.nl();
                builder.append((Object)statement.toString(formatter));
                builder.append((Object)"; ");
            }
            if (exceptionCode != null) {
                builder.unindent();
                builder.nl();
                builder.append((Object)"EXCEPT ");
                builder.indent();
                if (Code.isFunction((Code)exceptionCode, (String)"BLOCK")) {
                    Code.Callable block = (Code.Callable)exceptionCode;
                    for (Code parameter : block.parameters()) {
                        builder.nl();
                        builder.append((Object)parameter.toString(formatter));
                        builder.append((Object)"; ");
                    }
                } else {
                    builder.nl();
                    builder.append((Object)exceptionCode.toString(formatter));
                    builder.append((Object)" ");
                }
            }
            builder.unindent();
            builder.nl();
            builder.append((Object)"END ");
            builder.nl();
            String string = builder.build();
            return string;
        }
        finally {
            builder.pop();
        }
    }
}

