/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.impl.function.programming;

import org.apache.commons.lang3.Range;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.AbstractFunction;

public class ReturnFunction
extends AbstractFunction {
    public static final String NAME = "RETURN";

    public ReturnFunction() {
        super("Programming", NAME, Range.between((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE)), null, "RETURN {{value}};", null, "Object", false);
    }

    public boolean isHidden() {
        return true;
    }

    public boolean allowConstantFolding() {
        return false;
    }

    public Object call(Interpreter interpreter, Object[] args) throws Exception {
        switch (args.length) {
            case 0: {
                throw new ReturnException((Object)null);
            }
            case 1: {
                throw new ReturnException(args[0]);
            }
        }
        throw new ReturnException(args);
    }

    public String toString(Codes args, Formatter<Code> formatter) {
        StringBuilder builder = new StringBuilder();
        switch (args.size()) {
            case 0: {
                builder.append(NAME);
                break;
            }
            case 1: {
                builder.append("RETURN ");
                builder.append(((Code)args.get(0)).toString(formatter));
                break;
            }
            default: {
                builder.append("RETURN ");
                builder.append(args.toString(formatter));
            }
        }
        return builder.toString();
    }

    public static class ReturnException
    extends RuntimeException {
        private final Object value;

        public ReturnException(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

