/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dynform.services.dynformfield.Text;

import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynform.DynFormFieldDefinition;
import org.gvsig.tools.dynform.JDynFormField;
import org.gvsig.tools.dynform.spi.DynFormSPIManager;
import org.gvsig.tools.dynform.spi.dynformfield.AbstractJDynFormField;
import org.gvsig.tools.dynform.spi.dynformfield.JDynFormFieldFactory;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.viewer.JViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class JDynFormFieldText
extends AbstractJDynFormField
implements JDynFormField {
    private final int CHAR_ROW_LIMIT = 3;
    private String assignedValue = null;
    private DynFormSPIManager.ComponentsFactory.ScrolledComponent<JTextArea> textArea;

    public JDynFormFieldText(DynFormSPIManager serviceManager, DynFormSPIManager.ComponentsFactory componentsFactory, JDynFormFieldFactory factory, DynFormFieldDefinition definition, Object value) {
        super(serviceManager, componentsFactory, factory, definition, value);
        this.assignedValue = Objects.toString(value, null);
    }

    public Object getAssignedValue() {
        return this.assignedValue;
    }

    private JTextArea getJTextArea() {
        return (JTextArea)this.textArea.getComponent();
    }

    public void initComponent() {
        DynFormSPIManager.ComponentsFactory.ScrolledComponent text;
        this.textArea = text = this.getComponentsFactory().getJTextArea(this.getDefinition(), null);
        ((JTextArea)text.getComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JDynFormFieldText.this.fireFieldChangedEvent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JDynFormFieldText.this.fireFieldChangedEvent();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                JDynFormFieldText.this.fireFieldChangedEvent();
            }
        });
        this.contents = this.textArea.getScrollPane();
        this.getJTextArea().setLineWrap(true);
        this.getJTextArea().setWrapStyleWord(true);
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.addLineNumbers((JTextComponent)this.getJTextArea(), this.textArea.getScrollPane());
        toolsSwingManager.addUndoRedoSupport((JTextComponent)this.getJTextArea());
        toolsSwingManager.addSearchToolbar((JTextComponent)this.getJTextArea());
        JPopupMenu popup = this.getJTextArea().getComponentPopupMenu();
        if (popup != null) {
            popup.add(this.createMenuViewers());
        }
        this.getJTextArea().setRows(this.getTagValueAsInt("dynform.rows", 3));
        if (this.getDefinition().isReadOnly()) {
            this.getJTextArea().setEditable(false);
        }
        this.getJTextArea().addFocusListener((FocusListener)((Object)this));
        this.setValue(this.assignedValue);
    }

    private JMenu createMenuViewers() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        JMenu menu = new JMenu();
        menu.setText(i18n.getTranslation("_Show_as"));
        for (final ViewerFactory factory : manager.getViewerFactories()) {
            AbstractAction action = new AbstractAction(i18n.getTranslation("_Show_as_XDataTypeNameX", new String[]{factory.getDataTypeName()})){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JDynFormFieldText.this.doShowViewer(factory);
                }
            };
            action.setEnabled(factory.isApplicable(new Object[]{""}));
            menu.add(new JMenuItem(action));
        }
        return menu;
    }

    private void doShowViewer(ViewerFactory factory) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        boolean isEditable = !this.isReadOnly() && factory.isEditable();
        String title = isEditable ? i18n.getTranslation("_XDataTypeNameX_editor", new String[]{factory.getDataTypeName()}) : i18n.getTranslation("_XDataTypeNameX_viewer", new String[]{factory.getDataTypeName()});
        try {
            boolean modal = ToolsSwingLocator.getToolsSwingManager().isModalDialogShowing();
            Object value = this.getValue();
            JViewer viewer = factory.createViewer();
            viewer.setContents(value);
            viewer.setEditable(isEditable);
            viewer.setEnabled(true);
            WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog dialog = winmanager.createDialog(viewer.asJComponent(), title, null, 3);
            dialog.setButtonEnabled(1, isEditable);
            dialog.addActionListener(e -> {
                if (isEditable && dialog.getAction() == 1) {
                    try {
                        this.setValue(Objects.toString(viewer.getContents()));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("Can't string from editor.", (Throwable)ex);
                        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                        dialogs.messageDialog(i18n.getTranslation("_Cant_get_string_from_editor"), title, 2);
                    }
                }
            });
            dialog.show(modal ? WindowManager.MODE.DIALOG : WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOGGER.warn("Can't show viewer.", (Throwable)ex);
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Cant_show_viewer"), title, 2);
        }
    }

    public void setValue(Object value) {
        String s = Objects.toString(value, "");
        this.assignedValue = Objects.toString(value, null);
        this.getJTextArea().setText(s);
        this.getJTextArea().setCaretPosition(0);
        this.fixPreferredWidth(this.contents);
        this.setTranslateEmptyToNull(value == null);
    }

    public Object getValue() {
        String s = this.getJTextArea().getText();
        if (this.translateEmptyToNull() && StringUtils.isBlank((CharSequence)s)) {
            return null;
        }
        return s;
    }

    public boolean hasValidValue() {
        return true;
    }

    public boolean isModified() {
        String value = this.getJTextArea().getText();
        String assigned = (String)this.getAssignedValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return StringUtils.isNotBlank((CharSequence)assigned);
        }
        return !Objects.equals(value, assigned);
    }
}

