/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.dataTypes.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gvsig.tools.dataTypes.Coercion;
import org.gvsig.tools.dataTypes.CoercionContext;
import org.gvsig.tools.dataTypes.CoercionException;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.dataTypes.impl.Coercions;
import org.gvsig.tools.dataTypes.impl.DefaultDataTypesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataType
implements DataType {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDataTypesManager.class);
    private static final DataType.NumberPrecisionAndScale EMPTY_PRECISION_AND_SCALE = new DefaultNumberPrecisionAndScale(-1, -1);
    private Coercion coercion;
    private Class defaultClass;
    private String subtype;
    private int type;
    private String name;
    private String iconName;
    private int max_precision;
    private int default_precision;
    private int default_scale;
    private int default_size;
    private int flags;
    private Set<String> alias;

    DefaultDataType(int type, String subtype, String name, Class defaultClass, Coercion coercion) {
        this(type, subtype, name, defaultClass, coercion, "datatype-any");
    }

    DefaultDataType(int type, String subtype, String name, Class defaultClass, Coercion coercion, String iconName) {
        this(type, subtype, name, defaultClass, coercion, "datatype-any", 0, -1, -1, -1);
    }

    DefaultDataType(int type, String subtype, String name, Class defaultClass, Coercion coercion, String iconName, int psflag, int max_precision, int default_precision) {
        this(type, subtype, name, defaultClass, coercion, "datatype-any", psflag, max_precision, default_precision, -1);
    }

    DefaultDataType(int type, String subtype, String name, Class defaultClass, Coercion coercion, String iconName, int flags, int max_precision, int default_precision, int default_scale) {
        if (name == null) {
            LOG.trace("Can't register null type name for type {}.", new Object[]{Integer.toHexString(type).toUpperCase()});
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.subtype = subtype;
        this.name = name;
        this.defaultClass = defaultClass;
        this.coercion = coercion;
        this.iconName = iconName == null ? "datatype-any" : iconName;
        this.flags = flags;
        if ((this.flags & 0x20) == 32) {
            this.flags |= 1;
        }
        if ((this.flags & 2) == 2) {
            this.max_precision = max_precision;
            this.default_precision = this.default_precision > max_precision ? max_precision : default_precision;
            this.default_scale = (this.flags & 4) == 4 ? (this.default_scale > this.max_precision ? this.max_precision - 1 : default_scale) : -1;
        } else {
            this.max_precision = -1;
            this.default_precision = -1;
            this.default_scale = -1;
        }
    }

    @Override
    public DataType clone() throws CloneNotSupportedException {
        DefaultDataType other = (DefaultDataType)super.clone();
        if (other.coercion instanceof Coercions) {
            this.coercion = ((Coercions)this.coercion).clone();
        }
        return other;
    }

    @Override
    public String getLabel() {
        return this.getName();
    }

    @Override
    public DataType getValue() {
        return this;
    }

    @Override
    public Object coerce(Object value) throws CoercionException {
        if (this.coercion != null) {
            return this.coercion.coerce(value);
        }
        if (this.defaultClass == null) {
            return value;
        }
        if (this.defaultClass.isInstance(value)) {
            return value;
        }
        throw new CoercionException();
    }

    @Override
    public Object coerce(Object value, CoercionContext context) throws CoercionException {
        if (this.coercion != null) {
            return this.coercion.coerce(value, context);
        }
        if (this.defaultClass == null) {
            return value;
        }
        if (this.defaultClass.isInstance(value)) {
            return value;
        }
        throw new CoercionException();
    }

    @Override
    public Coercion getCoercion() {
        return this.coercion;
    }

    @Override
    public Class getDefaultClass() {
        return this.defaultClass;
    }

    @Override
    public String getSubtype() {
        return this.subtype;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIconName() {
        return this.iconName;
    }

    @Override
    public boolean isContainer() {
        return (this.type & 0x20) == 32;
    }

    @Override
    public boolean isObject() {
        return (this.type & 0x40) == 64;
    }

    @Override
    public boolean isDynObject() {
        return this.type == 15;
    }

    public void setCoercion(Coercion coercion) {
        this.coercion = coercion;
        LOG.trace("Add coercion operation for data type {}.", new Object[]{this.name});
    }

    @Override
    public void addCoercion(Coercion coercion) {
        Coercions coercions;
        if (this.coercion == null) {
            this.coercion = coercion;
            return;
        }
        if (this.coercion instanceof Coercions) {
            coercions = (Coercions)this.coercion;
        } else {
            coercions = new Coercions();
            coercions.add(this.coercion);
            this.coercion = coercions;
        }
        coercions.add(coercion);
        LOG.trace("Add coercion operation for data type {}.", new Object[]{this.name});
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Override
    public boolean isNumeric() {
        return (this.flags & 1) == 1;
    }

    @Override
    public boolean supportSize() {
        return (this.flags & 0x10) == 16;
    }

    @Override
    public boolean supportPrecision() {
        return (this.flags & 2) == 2;
    }

    @Override
    public boolean supportScale() {
        return (this.flags & 4) == 4;
    }

    @Override
    public boolean isPredefinedPrecision() {
        return (this.flags & 8) == 8;
    }

    @Override
    public boolean isFloatingPoint() {
        return (this.flags & 0x20) == 32;
    }

    @Override
    public int getFlags() {
        return this.flags;
    }

    @Override
    public DataType.NumberPrecisionAndScale fixPrecisionAndScale(int precision, int scale) {
        if ((this.flags & 2) != 2) {
            return EMPTY_PRECISION_AND_SCALE;
        }
        DefaultNumberPrecisionAndScale r = new DefaultNumberPrecisionAndScale(precision, scale);
        if ((this.flags & 8) == 8) {
            r.precision = this.max_precision;
        }
        if ((this.flags & 4) != 4) {
            r.scale = 0;
            if (r.precision > this.max_precision) {
                r.precision = this.max_precision;
            } else if (r.precision < 1) {
                r.precision = this.default_precision;
            }
        } else if (r.precision < 1) {
            if (r.scale < 1) {
                r.precision = this.default_precision;
                r.scale = this.default_scale;
            } else if (r.scale <= this.default_scale) {
                r.precision = this.default_precision;
            } else if (r.scale < this.default_precision) {
                r.precision = this.default_precision;
            } else if (r.scale <= this.max_precision) {
                r.precision = this.max_precision;
            } else {
                r.precision = this.max_precision;
                r.scale = this.max_precision;
            }
        } else if (r.scale < 1) {
            if (r.precision < this.max_precision) {
                if (r.scale != 0) {
                    r.scale = -1;
                }
            } else {
                r.precision = this.max_precision;
                if (r.scale != 0) {
                    r.scale = -1;
                }
            }
        } else {
            if (r.precision > this.max_precision) {
                r.precision = this.max_precision;
            }
            if (r.precision < r.scale) {
                if (r.scale <= this.max_precision) {
                    r.precision = r.scale;
                } else {
                    r.precision = this.max_precision;
                    r.scale = this.max_precision;
                }
            }
        }
        if ((this.flags & 0x20) == 32 && r.scale < 1) {
            r.scale = -1;
        }
        return r;
    }

    @Override
    public int getMaxPrecision() {
        return this.max_precision;
    }

    @Override
    public int getDefaultPrecision() {
        return this.default_precision;
    }

    @Override
    public int getDefaultScale() {
        return this.default_scale;
    }

    @Override
    public int getDefaultSize() {
        return this.default_size;
    }

    @Override
    public DataType setDefaultSize(int size) {
        this.default_size = size;
        return this;
    }

    @Override
    public DataType addAlias(String alias) {
        if (this.alias == null) {
            this.alias = new HashSet<String>();
        }
        this.alias.add(alias);
        return this;
    }

    @Override
    public Collection<String> getAlias() {
        if (this.alias == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.alias);
    }

    private static class DefaultNumberPrecisionAndScale
    implements DataType.NumberPrecisionAndScale {
        private int precision;
        private int scale;

        public DefaultNumberPrecisionAndScale(int precision, int scale) {
            this.precision = precision;
            this.scale = scale;
        }

        @Override
        public int getPrecision() {
            return this.precision;
        }

        @Override
        public int getScale() {
            return this.scale;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public void setScale(int scale) {
            this.scale = scale;
        }
    }
}

