/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.gvsig.tools.dataTypes.impl.coercion.CoerceToBoolean;
import org.gvsig.tools.evaluator.AbstractEvaluator;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.evaluator.EvaluatorData;
import org.gvsig.tools.evaluator.EvaluatorException;
import org.gvsig.tools.lang.Cloneable;

public class AndEvaluator
extends AbstractEvaluator
implements Cloneable {
    private List<Evaluator> evaluators = new ArrayList<Evaluator>();

    public AndEvaluator(Evaluator evaluator) {
        this.addEvaluator(evaluator);
    }

    public List<Evaluator> getEvaluators() {
        return this.evaluators;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        AndEvaluator other = (AndEvaluator)super.clone();
        other.evaluators = new ArrayList<Evaluator>();
        for (Evaluator evaluator : this.evaluators) {
            if (evaluator instanceof Cloneable) {
                evaluator = (Evaluator)((Cloneable)((Object)evaluator)).clone();
            }
            other.evaluators.add(evaluator);
        }
        return other;
    }

    @Override
    public Object evaluate(EvaluatorData data) throws EvaluatorException {
        for (int i = 0; i < this.evaluators.size(); ++i) {
            Evaluator evaluator = this.evaluators.get(i);
            if (evaluator == null || BooleanUtils.toBoolean((Boolean)CoerceToBoolean.convert(evaluator.evaluate(data)))) continue;
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public String getName() {
        return "a set of evaluators";
    }

    public void addEvaluator(Evaluator evaluator) {
        if (evaluator != null) {
            this.evaluators.add(evaluator);
        }
    }

    @Override
    public String getSQL() {
        if (this.evaluators.size() > 0) {
            StringBuilder stringBuffer = new StringBuilder(this.evaluators.get(0).getSQL());
            for (int i = 1; i < this.evaluators.size(); ++i) {
                stringBuffer.append(" and ").append(this.evaluators.get(i).getSQL());
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public String toString() {
        try {
            ToStringBuilder builder = new ToStringBuilder((Object)this);
            builder.append("evaluators", this.evaluators, true);
            return builder.toString();
        }
        catch (Exception e) {
            return super.toString();
        }
    }
}

