/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.exception;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.exception.BaseExceptionIterator;
import org.gvsig.tools.exception.ExceptionTranslator;
import org.gvsig.tools.exception.IBaseException;
import org.gvsig.tools.exception.TranslatorWraper;
import org.gvsig.tools.i18n.I18nManager;

public abstract class BaseException
extends Exception
implements IBaseException {
    private static final long serialVersionUID = 6631799898764636572L;
    static final String BLANKS = "                                                                                                     ";
    static ExceptionTranslator translator = null;
    protected String messageKey;
    protected String formatString;
    protected long code;
    private Map values;

    public BaseException() {
    }

    public BaseException(String message, String key, long code) {
        super(message);
        this.values = null;
        this.formatString = message;
        this.messageKey = key;
        this.code = code;
    }

    public BaseException(String message, Throwable cause, String key, long code) {
        super(message, cause);
        this.formatString = message;
        this.messageKey = key;
        this.code = code;
    }

    private String format(String formatString, Map values) {
        if (values != null) {
            if (formatString == null) {
                return "values = ".concat(values.toString());
            }
            Iterator keys = values.keySet().iterator();
            String message = formatString;
            while (keys.hasNext()) {
                String key;
                Object value = values.get(key = (String)keys.next());
                message = this.replaceVariable(message, key, value == null ? "" : value.toString());
            }
            return message;
        }
        return formatString;
    }

    private String replaceVariable(String text, String varName, String replacementString) {
        String s = StringUtils.replace((String)text, (String)"%(".concat(varName).concat(")s"), (String)replacementString);
        s = StringUtils.replace((String)s, (String)"%(".concat(varName).concat(")"), (String)replacementString);
        return s;
    }

    @Override
    public String getMessage() {
        return this.format(this.formatString, this.values());
    }

    @Override
    public String getMessage(int indent) {
        return BaseException.insertBlanksAtStart(this.format(this.formatString, this.values()), indent);
    }

    @Override
    public String getLocalizedMessage() {
        return this.getLocalizedMessage(translator, 0);
    }

    @Override
    public String getLocalizedMessage(ExceptionTranslator translator, int indent) {
        String fmt;
        if (translator == null) {
            translator = BaseException.translator;
        }
        if (translator == null) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            fmt = i18n.getTranslation(this.getMessageKey());
            if (fmt == null || fmt.startsWith("_")) {
                fmt = this.getFormatString();
            }
        } else {
            fmt = this.getMessageKey();
            if (fmt == null) {
                fmt = this.getFormatString();
            } else {
                String fmt2 = translator.getText(fmt);
                if (fmt2 == null || fmt.equals(fmt2)) {
                    return this.getMessage(indent);
                }
                fmt = fmt2;
            }
        }
        return BaseException.insertBlanksAtStart(this.format(fmt, this.values()), indent);
    }

    @Override
    public String getMessageStack() {
        return this.getMessageStack(0);
    }

    @Override
    public String getMessageStack(int indent) {
        return BaseException.getMessageStack(this, indent);
    }

    public static String getHTMLMessageStack(Throwable th) {
        BaseExceptionIterator iter = new BaseExceptionIterator(th);
        StringBuilder msgBuffer = new StringBuilder();
        int i = 1;
        msgBuffer.append("<ul>\n");
        while (iter.hasNext()) {
            Throwable ex = (Throwable)iter.next();
            if (ex instanceof IBaseException) {
                IBaseException bex = (IBaseException)((Object)ex);
                msgBuffer.append("<li>");
                msgBuffer.append(bex.getMessage());
                msgBuffer.append(" (");
                msgBuffer.append(bex.getClass().getSimpleName());
                msgBuffer.append(")");
                msgBuffer.append("</li>\n");
            } else if (ex != null) {
                msgBuffer.append("<li>");
                msgBuffer.append(ex.getMessage());
                msgBuffer.append(" (");
                msgBuffer.append(ex.getClass().getSimpleName());
                msgBuffer.append(")");
                msgBuffer.append("</li>\n");
            }
            ++i;
        }
        msgBuffer.append("</ul>\n");
        return msgBuffer.toString();
    }

    public static String getMessageStack(Throwable th, int indent) {
        BaseExceptionIterator iter = new BaseExceptionIterator(th);
        StringBuilder msgBuffer = new StringBuilder();
        int i = 1;
        while (iter.hasNext()) {
            Throwable ex = (Throwable)iter.next();
            if (msgBuffer.length() > 0) {
                msgBuffer.append("\n");
            }
            if (ex instanceof IBaseException) {
                IBaseException bex = (IBaseException)((Object)ex);
                msgBuffer.append(bex.getMessage(indent * i));
            } else if (ex != null) {
                msgBuffer.append(BaseException.insertBlanksAtStart(ex.getMessage(), indent * i));
            }
            ++i;
        }
        return msgBuffer.toString();
    }

    @Override
    public String getLocalizedMessageStack() {
        return this.getLocalizedMessageStack(translator, 0);
    }

    @Override
    public String getLocalizedMessageStack(ExceptionTranslator translator, int indent) {
        Iterator iter = this.iterator();
        StringBuilder msgBuffer = new StringBuilder();
        while (iter.hasNext()) {
            Exception ex = (Exception)iter.next();
            if (msgBuffer.length() > 0) {
                msgBuffer.append("\n");
            }
            if (ex instanceof IBaseException) {
                IBaseException bex = (IBaseException)((Object)ex);
                msgBuffer.append(bex.getLocalizedMessage(translator, indent));
                continue;
            }
            if (ex == null) continue;
            msgBuffer.append(ex.getLocalizedMessage());
            msgBuffer.append(" (");
            msgBuffer.append(ex.getClass().getName());
            msgBuffer.append(")");
        }
        return msgBuffer.toString();
    }

    static String insertBlanksAtStart(String str, int len) {
        int blanksLen = len > BLANKS.length() ? BLANKS.length() : (len < 0 ? 0 : len);
        return BLANKS.substring(0, blanksLen) + str;
    }

    @Override
    public long getCode() {
        return this.code;
    }

    public void setCode(long code) {
        this.code = code;
    }

    @Override
    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String formatString) {
        this.formatString = formatString;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    @Override
    public Iterator iterator() {
        return new BaseExceptionIterator(this);
    }

    protected Map values() {
        if (this.values == null) {
            this.values = new HashMap();
        }
        return this.values;
    }

    @Override
    public Object getValue(String name) {
        return this.values.get(name);
    }

    protected void setValue(String name, Object value) {
        if (this.values == null) {
            this.values = new HashMap();
        }
        this.values.put(name, value);
    }

    public static void setTranslator(ExceptionTranslator translator) {
        BaseException.translator = translator;
    }

    public static void setTranslator(Object translator) {
        BaseException.translator = new TranslatorWraper(translator);
    }

    public static boolean containsCause(Throwable ex, Class<? extends Throwable> searchException) {
        if (searchException.isInstance(ex)) {
            return true;
        }
        BaseExceptionIterator it = new BaseExceptionIterator(ex);
        while (it.hasNext()) {
            if (!searchException.isInstance(it.next())) continue;
            return true;
        }
        return false;
    }
}

