/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.observer;

import java.util.ArrayList;
import java.util.List;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.lang.CloneableUtils;
import org.gvsig.tools.observer.BaseNotification;
import org.gvsig.tools.observer.Notification;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObservableHelper
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(ObservableHelper.class);
    private List<Observer> observers = new ArrayList<Observer>();

    @Override
    public ObservableHelper clone() throws CloneNotSupportedException {
        ObservableHelper other = (ObservableHelper)super.clone();
        other.observers = (List)CloneableUtils.cloneQuietly(this.observers);
        return other;
    }

    public synchronized void addObserver(Observer o) {
        if (this.observers.contains(o)) {
            return;
        }
        this.observers.add(o);
    }

    public synchronized void deleteObserver(Observer o) {
        this.observers.remove(o);
    }

    public synchronized void deleteObservers() {
        this.observers = new ArrayList<Observer>();
    }

    public synchronized void notifyObservers(Observable observable, Object data) {
        for (int i = 0; i < this.observers.size(); ++i) {
            Observer o = this.observers.get(i);
            try {
                o.update(observable, data);
                continue;
            }
            catch (Exception ex) {
                logger.warn("Error notifying to the observers.", (Throwable)ex);
            }
        }
    }

    public Notification notifyObservers(Observable observable, String type, Object value) {
        BaseNotification notification = new BaseNotification(type, new Object[]{value});
        this.notifyObservers(observable, notification);
        return notification;
    }

    public Notification notifyObservers(Observable observable, String type, Object value1, Object value2) {
        BaseNotification notification = new BaseNotification(type, new Object[]{value1, value2});
        this.notifyObservers(observable, notification);
        return notification;
    }

    public Notification notifyObservers(Observable observable, String type, Object value1, Object value2, Object value3) {
        BaseNotification notification = new BaseNotification(type, new Object[]{value1, value2, value3});
        this.notifyObservers(observable, notification);
        return notification;
    }
}

