/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.util;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.util.LabeledValue;

public class LabeledValueImpl<T>
implements LabeledValue<T>,
Comparable {
    protected String label;
    protected T value;
    protected int maxlen;

    public LabeledValueImpl(String label, T value, int maxlen) {
        this.label = label;
        this.value = value;
        this.maxlen = maxlen;
    }

    public LabeledValueImpl(String label, T value) {
        this(label, value, -1);
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public String getLabel() {
        if (this.maxlen < 0) {
            return this.label;
        }
        return StringUtils.abbreviate((String)this.label, (int)this.maxlen);
    }

    public int compareTo(Object other) {
        String thisLabel;
        String otherLabel = null;
        if (other != null) {
            otherLabel = other.toString();
        }
        if ((thisLabel = this.getLabel()) == otherLabel) {
            return 0;
        }
        if (thisLabel == null) {
            return -1;
        }
        if (otherLabel == null) {
            return 1;
        }
        return thisLabel.compareTo(otherLabel);
    }
}

