/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.andami.ui.mdiFrame;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiFrame.MDIFrame;
import org.gvsig.andami.ui.mdiFrame.NewStatusBar;
import org.gvsig.andami.ui.mdiFrame.ThreadSafeDialogs;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.WindowPanel;
import org.gvsig.tools.swing.api.reminder.DialogReminder;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.tools.task.RunnableWithParameters;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultThreadSafeDialogs
implements ThreadSafeDialogs {
    private static Logger logger = LoggerFactory.getLogger(DefaultThreadSafeDialogs.class);
    private Component rootComponent;
    private NewStatusBar statusbar;

    public DefaultThreadSafeDialogs() {
        this(null, null);
    }

    public DefaultThreadSafeDialogs(Component rootComponent) {
        this(rootComponent, null);
    }

    public DefaultThreadSafeDialogs(Component rootComponent, NewStatusBar statusbar) {
        this.statusbar = statusbar;
        this.rootComponent = rootComponent;
    }

    private Component getRootComponent() {
        if (this.rootComponent == null) {
            try {
                this.rootComponent = (MDIFrame)PluginServices.getMainFrame();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.rootComponent;
    }

    private NewStatusBar getStatusbar() {
        if (this.statusbar == null) {
            this.statusbar = PluginServices.getMainFrame().getStatusBar();
        }
        return this.statusbar;
    }

    public void message(String message, int messageType) {
        this.getStatusbar().message(message, messageType);
    }

    private String translate(String message) {
        return this.translate(message, null);
    }

    private String translate(String message, String[] args) {
        String msg = message;
        if (msg == null) {
            msg = "";
        }
        if (msg.startsWith("_") && (msg = Messages.getText((String)msg, (String[])args)) == null) {
            msg = "_" + message.replace("_", " ");
        }
        return msg;
    }

    public int confirmDialog(String message, String title, int optionType, int messageType) {
        return this.confirmDialog(message, title, optionType, messageType, null);
    }

    @Override
    public int confirmDialog(final String message, final String title, final int optionType, final int messageType, final String msgid) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                DialogReminder r = null;
                Object msg = message;
                if (msgid != null) {
                    r = ToolsSwingLocator.getDialogReminderManager().add(msgid);
                    if (r.hasValue()) {
                        this.returnValue = r.getValue();
                        return;
                    }
                    msg = new JMessageWithCheck(message, ToolsLocator.getI18nManager().getTranslation("_Remember_answer_and_do_not_ask_again"));
                }
                this.returnValue = JOptionPane.showConfirmDialog(DefaultThreadSafeDialogs.this.getRootComponent(), msg, title, optionType, messageType);
                if (r != null) {
                    if (((JMessageWithCheck)msg).isCheckSelected()) {
                        r.setValue(this.returnValue);
                    } else {
                        r.reset();
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (Integer)runnable.getReturnValue();
    }

    public String inputDialog(final String message, final String title, final int messageType, final String initialValue) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                this.returnValue = JOptionPane.showInputDialog(DefaultThreadSafeDialogs.this.getRootComponent(), DefaultThreadSafeDialogs.this.translate(message), DefaultThreadSafeDialogs.this.translate(title), messageType, null, null, initialValue);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (String)runnable.getReturnValue();
    }

    public String inputDialog(final String message, final String title) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                this.returnValue = JOptionPane.showInputDialog(DefaultThreadSafeDialogs.this.getRootComponent(), DefaultThreadSafeDialogs.this.translate(message), DefaultThreadSafeDialogs.this.translate(title), 3, null, null, null);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show input dialog '" + message + "'.", (Throwable)e);
            }
        }
        return (String)runnable.getReturnValue();
    }

    public void messageDialog(String message, String title, int messageType) {
        this.messageDialog(message, null, title, messageType);
    }

    public void messageDialog(String message, String[] messageArgs, String title, int messageType) {
        this.messageDialog(message, messageArgs, title, messageType, null);
    }

    @Override
    public void messageDialog(final String message, final String[] messageArgs, final String title, final int messageType, final String msgid) {
        Object msg;
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        DefaultThreadSafeDialogs.this.messageDialog(message, messageArgs, title, messageType, msgid);
                    }
                });
            }
            catch (Exception e) {
                logger.info("Can't show message dialog '" + message + "'. redirect to status bar", (Throwable)e);
                this.message(message, messageType);
            }
            return;
        }
        if (message == null) {
            logger.info("message if null, message dialog not show.");
            return;
        }
        DialogReminder r = null;
        if (msgid != null) {
            r = ToolsSwingLocator.getDialogReminderManager().add(msgid);
            if (r.hasValue() && ((Boolean)r.getValue()).booleanValue()) {
                return;
            }
            msg = new JMessageWithCheck(this.translate(message, messageArgs), ToolsLocator.getI18nManager().getTranslation("_do_not_show_again"));
        } else {
            String m = this.translate(message, messageArgs);
            if (m.length() > 200) {
                JLabel lbl = new JLabel();
                if (StringUtils.containsIgnoreCase((CharSequence)m, (CharSequence)"<html>")) {
                    m = StringUtils.replaceIgnoreCase((String)m, (String)"<html>", (String)("<html><table width=\"" + ToolsSwingUtils.cols2px((int)100) + "\"><tr><td>"));
                    m = StringUtils.replaceIgnoreCase((String)m, (String)"</html>", (String)"</td></tr></table></html>");
                } else {
                    m = "<html><table width=\"" + ToolsSwingUtils.cols2px((int)100) + "\"><tr><td>" + StringUtils.replaceIgnoreCase((String)m, (String)"\n", (String)"<br>") + "</td></tr></table></html>";
                }
                lbl.setText(m);
                JScrollPane sc = new JScrollPane(lbl);
                sc.setBorder(null);
                ToolsSwingUtils.ensureRowsCols((JComponent)sc, (int)2, (int)80, (int)20, (int)100);
                msg = sc;
            } else {
                msg = m;
            }
        }
        JOptionPane.showMessageDialog(this.getRootComponent(), msg, this.translate(title), messageType);
        if (r != null) {
            if (((JMessageWithCheck)msg).isCheckSelected()) {
                r.setValue((Object)true);
            } else {
                r.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void showDialog(final Component contents, final String title) {
        if (SwingUtilities.isEventDispatchThread()) {
            DialogWindow window = new DialogWindow();
            window.setDialogFlag();
            window.setContents(contents, title);
            MDIManager manager = PluginServices.getMDIManager();
            manager.addWindow(window, 10);
        } else {
            final DialogWindow window = new DialogWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    window.setContents(contents, title);
                    MDIManager manager = PluginServices.getMDIManager();
                    manager.addWindow(window, 10);
                }
            });
            try {
                DialogWindow manager = window;
                synchronized (manager) {
                    if (contents instanceof CancellableTask) {
                        while (contents.isVisible()) {
                            if (((CancellableTask)contents).isCancellationRequested()) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        contents.setVisible(false);
                                    }
                                });
                            }
                            window.wait(10000L);
                        }
                    } else {
                        while (contents.isVisible()) {
                            window.wait();
                        }
                    }
                }
            }
            catch (InterruptedException e) {
                logger.info("showDialog can wait to close dialog.", (Throwable)e);
            }
        }
    }

    public Component createComponent(Class<? extends Component> theClass, Object ... parameters) {
        return this.createComponentWithParams(theClass, parameters);
    }

    public Component createComponentWithParams(Class<? extends Component> theClass, Object[] parameters) {
        Component component;
        Constructor<? extends Component> constructor;
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i].getClass();
        }
        try {
            constructor = theClass.getConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                component = constructor.newInstance(parameters);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        try {
            RunnableWithParameters runnable = new RunnableWithParameters(parameters){

                public void run() {
                    Constructor cons = constructor;
                    try {
                        this.returnValue = cons.newInstance(this.parameters.toArray());
                    }
                    catch (Exception e) {
                        String msg = "Can't create instance of components, constructor=" + cons.toString() + ", parameters=" + this.parameters.toString() + ".";
                        logger.info(msg, (Throwable)e);
                        throw new IllegalArgumentException(e);
                    }
                }
            };
            SwingUtilities.invokeAndWait((Runnable)runnable);
            component = (Component)runnable.getReturnValue();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return component;
    }

    public File[] showChooserDialog(final String title, final int type, final int selectionMode, final boolean multiselection, final File initialPath, final FileFilter filter, final boolean fileHidingEnabled) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                FileDialogChooser fc = ToolsUtilLocator.getFileDialogChooserManager().create();
                fc.setDialogTitle(title);
                fc.setDialogType(type);
                fc.setFileSelectionMode(selectionMode);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                fc.setFileFilter(filter);
                fc.setFileHidingEnabled(fileHidingEnabled);
                int r = 1;
                switch (type) {
                    case 1: {
                        r = fc.showSaveDialog(DefaultThreadSafeDialogs.this.getRootComponent());
                        break;
                    }
                    default: {
                        r = fc.showOpenDialog(DefaultThreadSafeDialogs.this.getRootComponent());
                    }
                }
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                this.returnValue = fc.isMultiSelectionEnabled() ? fc.getSelectedFiles() : new File[]{fc.getSelectedFile()};
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (File[])runnable.getReturnValue();
    }

    public ImmutablePair<File[], Charset> showChooserDialog(final String title, final int type, final int selectionMode, final boolean multiselection, final File initialPath, final FileFilter filter, final boolean fileHidingEnabled, final boolean askCharset) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                FileDialogChooser fc = ToolsUtilLocator.getFileDialogChooserManager().create();
                fc.setDialogTitle(title);
                fc.setDialogType(type);
                fc.setFileSelectionMode(selectionMode);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                fc.setFileFilter(filter);
                fc.setFileHidingEnabled(fileHidingEnabled);
                fc.setVisibleCharsetPicker(askCharset);
                int r = 1;
                switch (type) {
                    case 1: {
                        r = fc.showSaveDialog(DefaultThreadSafeDialogs.this.getRootComponent());
                        break;
                    }
                    default: {
                        r = fc.showOpenDialog(DefaultThreadSafeDialogs.this.getRootComponent());
                    }
                }
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                this.returnValue = fc.isMultiSelectionEnabled() ? new ImmutablePair((Object)fc.getSelectedFiles(), (Object)fc.getCharset()) : new ImmutablePair((Object)new File[]{fc.getSelectedFile()}, (Object)fc.getCharset());
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (ImmutablePair)runnable.getReturnValue();
    }

    public File[] showOpenDirectoryDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 1, false, initialPath, null, false);
    }

    public File[] showOpenFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 0, 0, false, initialPath, null, false);
    }

    public File[] showSaveFileDialog(String title, File initialPath) {
        return this.showChooserDialog(title, 1, 0, false, initialPath, null, false);
    }

    public File[] showChooserDialog(final String title, final int type, final int selectionMode, final boolean multiselection, final File initialPath, final FileFilter filter, final boolean fileHidingEnabled, final JComponent accesory) {
        RunnableWithParameters runnable = new RunnableWithParameters(){

            public void run() {
                int r;
                FileDialogChooser fc = ToolsUtilLocator.getFileDialogChooserManager().create();
                fc.setDialogTitle(title);
                fc.setDialogType(type);
                fc.setFileSelectionMode(selectionMode);
                fc.setMultiSelectionEnabled(multiselection);
                fc.setCurrentDirectory(initialPath);
                fc.setFileFilter(filter);
                fc.setFileHidingEnabled(fileHidingEnabled);
                fc.setAccessory(accesory);
                switch (type) {
                    case 1: {
                        r = fc.showSaveDialog(DefaultThreadSafeDialogs.this.getRootComponent());
                        break;
                    }
                    default: {
                        r = fc.showOpenDialog(DefaultThreadSafeDialogs.this.getRootComponent());
                    }
                }
                if (r != 0) {
                    this.returnValue = null;
                    return;
                }
                this.returnValue = fc.isMultiSelectionEnabled() ? fc.getSelectedFiles() : new File[]{fc.getSelectedFile()};
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait((Runnable)runnable);
            }
            catch (Exception e) {
                logger.info("Can't show chooser dialog '" + title + "'.", (Throwable)e);
            }
        }
        return (File[])runnable.getReturnValue();
    }

    class DialogWindow
    extends WindowPanel
    implements IWindow,
    ComponentListener {
        private static final long serialVersionUID = 6283975319620714565L;
        protected WindowInfo windowInfo;
        protected Object profile = WindowInfo.DIALOG_PROFILE;
        private int code = 7;

        public void setDialogFlag() {
            this.code |= 8;
        }

        public void setContents(Component contents, String title) {
            this.windowInfo = new WindowInfo(this.code);
            this.windowInfo.setTitle(title);
            this.contents = contents;
            Dimension size = this.contents.getPreferredSize();
            this.windowInfo.setHeight(size.height);
            this.windowInfo.setWidth(size.width);
            this.setLayout(new BorderLayout());
            this.add(this.contents, "Center");
            this.contents.addComponentListener(this);
        }

        @Override
        public WindowInfo getWindowInfo() {
            return this.windowInfo;
        }

        @Override
        public Object getWindowProfile() {
            return this.profile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void componentHidden(ComponentEvent arg0) {
            MDIManager manager = PluginServices.getMDIManager();
            manager.closeWindow(this);
            if ((this.code & 8) == 0) {
                DialogWindow dialogWindow = this;
                synchronized (dialogWindow) {
                    this.notifyAll();
                }
            }
        }

        @Override
        public void componentMoved(ComponentEvent arg0) {
        }

        @Override
        public void componentResized(ComponentEvent arg0) {
        }

        @Override
        public void componentShown(ComponentEvent arg0) {
        }
    }

    private static class JMessageWithCheck
    extends JPanel {
        private static final long serialVersionUID = -1902712909850016361L;
        private final JLabel label;
        private final JCheckBox check;

        public JMessageWithCheck(String msg, String msgchk) {
            if (!msg.toLowerCase().trim().startsWith("<html>")) {
                msg = "<html>" + msg.replace("\n", "<br>\n") + "</html>";
            }
            this.label = new JLabel(msg);
            this.check = new JCheckBox(msgchk);
            this.setLayout(new BorderLayout(10, 10));
            this.add((Component)this.label, "Center");
            this.add((Component)this.check, "Last");
        }

        public boolean isCheckSelected() {
            return this.check.isSelected();
        }
    }
}

