/*
 * Decompiled with CFR 0.152.
 */
package org.fit.cssbox.layout;

import cz.vutbr.web.css.CSSProperty;
import cz.vutbr.web.css.TermLengthOrPercent;
import java.awt.Rectangle;
import org.fit.cssbox.css.HTMLNorm;
import org.fit.cssbox.layout.ElementBox;
import org.fit.cssbox.layout.ReplacedContent;
import org.fit.cssbox.layout.VisualContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

public class CSSDecoder {
    protected static Logger log = LoggerFactory.getLogger(CSSDecoder.class);
    private VisualContext context;

    public CSSDecoder(VisualContext c) {
        this.context = c;
    }

    public VisualContext getContext() {
        return this.context;
    }

    public void setContext(VisualContext c) {
        this.context = c;
    }

    public int getLength(TermLengthOrPercent value, boolean auto, TermLengthOrPercent defval, TermLengthOrPercent autoval, int whole) {
        TermLengthOrPercent val = value;
        if (value == null) {
            val = defval;
        }
        if (auto) {
            val = autoval;
        }
        if (val != null) {
            return (int)this.context.pxLength(val, whole);
        }
        return 0;
    }

    public int getLength(TermLengthOrPercent value, boolean auto, int defval, int autoval, int whole) {
        if (auto) {
            return autoval;
        }
        if (value == null) {
            return defval;
        }
        return (int)this.context.pxLength(value, whole);
    }

    public static Rectangle computeReplacedObjectSize(ReplacedContent obj, ElementBox box) {
        CSSProperty.Height height;
        int boxh;
        int boxw;
        float intr;
        int inth;
        int intw;
        if (obj != null) {
            intw = obj.getIntrinsicWidth();
            inth = obj.getIntrinsicHeight();
            if (intw == 0 || inth == 0) {
                log.warn("Obtained a zero intrinsic width or height for " + obj.toString());
                inth = 1;
                intw = 1;
            }
            intr = (float)intw / (float)inth;
            boxw = intw;
            boxh = inth;
        } else {
            intw = 20;
            boxw = 20;
            inth = 20;
            boxh = 20;
            intr = 1.0f;
        }
        int twidth = box.getContainingBlock().getContentWidth();
        int theight = box.getViewport().getContentHeight();
        Element el = box.getElement();
        int atrw = -1;
        int atrh = -1;
        try {
            if (!el.getAttribute("width").equals("")) {
                atrw = HTMLNorm.computeAttributeLength(el.getAttribute("width"), twidth);
            }
        }
        catch (NumberFormatException e) {
            log.info("Invalid width value: " + el.getAttribute("width"));
        }
        try {
            if (!el.getAttribute("height").equals("")) {
                atrh = HTMLNorm.computeAttributeLength(el.getAttribute("height"), theight);
            }
        }
        catch (NumberFormatException e) {
            log.info("Invalid height value: " + el.getAttribute("width"));
        }
        if (atrw == -1 && atrh == -1) {
            boxw = intw;
            boxh = inth;
        } else if (atrw == -1) {
            boxw = Math.round(intr * (float)atrh);
            boxh = atrh;
        } else if (atrh == -1) {
            boxw = atrw;
            boxh = Math.round((float)atrw / intr);
        } else {
            boxw = atrw;
            boxh = atrh;
            intr = (float)boxw / (float)boxh;
        }
        CSSDecoder dec = new CSSDecoder(box.getVisualContext());
        CSSProperty.Width width = (CSSProperty.Width)box.getStyle().getProperty("width");
        if (width == CSSProperty.Width.AUTO) {
            width = null;
        }
        if ((height = (CSSProperty.Height)box.getStyle().getProperty("height")) == CSSProperty.Height.AUTO) {
            height = null;
        }
        if (width == null && height != null) {
            int autoh = Math.round((float)boxw / intr);
            boxh = dec.getLength(box.getLengthValue("height"), height == CSSProperty.Height.AUTO, boxh, autoh, theight);
            boxw = Math.round(intr * (float)boxh);
        } else if (width != null && height == null) {
            int autow = Math.round(intr * (float)boxh);
            boxw = dec.getLength(box.getLengthValue("width"), width == CSSProperty.Width.AUTO, boxw, autow, twidth);
            boxh = Math.round((float)boxw / intr);
        } else {
            boxw = dec.getLength(box.getLengthValue("width"), width == CSSProperty.Width.AUTO, boxw, intw, twidth);
            boxh = dec.getLength(box.getLengthValue("height"), height == CSSProperty.Height.AUTO, boxh, inth, theight);
        }
        return new Rectangle(boxw, boxh);
    }
}

