/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.json;

import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.gvsig.json.Json;
import org.gvsig.json.JsonArrayBuilder;
import org.gvsig.json.JsonArrayImpl;
import org.gvsig.json.JsonManager;
import org.gvsig.json.JsonObjectBuilderImpl;
import org.gvsig.json.SupportToJson;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.util.GetItemByKeyWithGetKeys;
import org.gvsig.tools.util.GetItemWithSize;

public class JsonArrayBuilderImpl
implements JsonArrayBuilder {
    private final javax.json.JsonArrayBuilder builder;
    private final JsonManager manager;

    public JsonArrayBuilderImpl() {
        this(Json.getManager());
    }

    public JsonArrayBuilderImpl(JsonManager manager) {
        this.manager = manager;
        this.builder = javax.json.Json.createArrayBuilder();
    }

    public JsonArrayBuilder add(SupportToJson value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add((JsonObjectBuilder)value.toJsonBuilder());
        return this;
    }

    public JsonArrayBuilder add(Object value) {
        if (value == null) {
            this.addNull();
        } else if (value instanceof SupportToJson) {
            this.add((JsonObjectBuilder)((SupportToJson)value).toJsonBuilder());
        } else if (value instanceof String) {
            this.builder.add((String)value);
        } else if (value instanceof JsonObject) {
            this.builder.add((JsonValue)((JsonObject)value));
        } else if (value instanceof Integer) {
            this.builder.add(((Integer)value).intValue());
        } else if (value instanceof Long) {
            this.builder.add(((Long)value).longValue());
        } else if (value instanceof BigInteger) {
            this.builder.add((BigInteger)value);
        } else if (value instanceof BigDecimal) {
            this.builder.add((BigDecimal)value);
        } else if (value instanceof Double) {
            this.builder.add(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            this.builder.add(((Boolean)value).booleanValue());
        } else if (value instanceof Class) {
            this.add((Class)value);
        } else {
            JsonManager.JsonSerializer serializer = this.manager.getSerializer(value);
            if (serializer != null) {
                this.add((JsonObjectBuilder)serializer.toJsonBuilder(value));
            } else if (value instanceof GetItemByKeyWithGetKeys) {
                this.add((GetItemByKeyWithGetKeys)value);
            } else if (value instanceof GetItemWithSize) {
                this.add((GetItemWithSize)value);
            } else if (value instanceof DynObject) {
                this.add((DynObject)value);
            } else if (value instanceof List) {
                this.add((List)value);
            } else if (value instanceof Set) {
                this.add((Set)value);
            } else if (value.getClass().isArray()) {
                this.add((Object[])value);
            } else if (value instanceof Map) {
                this.add((Map)value);
            } else {
                throw new IllegalArgumentException("Can't serialize to Json an object of class '" + value.getClass().getName() + "'.");
            }
        }
        return this;
    }

    public JsonArrayBuilder add(Object[] value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        for (Object item : value) {
            this.add(item);
        }
        return this;
    }

    public JsonArrayBuilder add(Iterable value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add((JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            for (Object item : value) {
                this.add(item);
            }
        }
        return this;
    }

    public JsonArrayBuilder add(Map value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add((JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonObjectBuilderImpl objBuilder = new JsonObjectBuilderImpl();
            objBuilder.addAll(value);
            this.add((JsonObjectBuilder)objBuilder);
        }
        return this;
    }

    public JsonArrayBuilder add(GetItemByKeyWithGetKeys value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add((JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonObjectBuilderImpl objBuilder = new JsonObjectBuilderImpl();
            objBuilder.addAll(value);
            this.add((JsonObjectBuilder)objBuilder);
        }
        return this;
    }

    public JsonArrayBuilder add(GetItemWithSize value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add((JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.add((javax.json.JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonArrayBuilder add(Iterator value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add((JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.add((javax.json.JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonArrayBuilder add(List value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add((JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.add((javax.json.JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonArrayBuilder add(Set value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        JsonManager.JsonSerializer serializer = this.manager.getSerializer((Object)value);
        if (serializer != null) {
            this.builder.add((JsonObjectBuilder)serializer.toJsonBuilder((Object)value));
        } else {
            JsonArrayBuilderImpl arrayBuilder = new JsonArrayBuilderImpl();
            arrayBuilder.addAll(value);
            this.add((javax.json.JsonArrayBuilder)arrayBuilder);
        }
        return this;
    }

    public JsonArrayBuilder add(JsonValue value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(String value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(BigDecimal value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(BigInteger value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(int value) {
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(long value) {
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(double value) {
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(boolean value) {
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(JsonObjectBuilder value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(javax.json.JsonArrayBuilder value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add(value);
        return this;
    }

    public JsonArrayBuilder add(Class value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add(value.getName());
        return this;
    }

    public JsonArrayBuilder addAll(Iterable items) {
        if (items == null) {
            return this;
        }
        for (Object item : items) {
            this.add(item);
        }
        return this;
    }

    public JsonArrayBuilder addAll(Object[] items) {
        if (items == null) {
            return this;
        }
        for (Object item : items) {
            this.add(item);
        }
        return this;
    }

    public JsonArrayBuilder addAll(GetItemWithSize items) {
        if (items == null) {
            return this;
        }
        for (int i = 0; i < items.size(); ++i) {
            this.add(items.get(i));
        }
        return this;
    }

    public JsonArrayBuilder addAll(Iterator items) {
        if (items == null) {
            return this;
        }
        while (items.hasNext()) {
            this.add(items.next());
        }
        return this;
    }

    public JsonArrayBuilder addAll(List items) {
        if (items == null) {
            return this;
        }
        for (Object object : items) {
            this.add(object);
        }
        return this;
    }

    public JsonArrayBuilder addAll(Set items) {
        if (items == null) {
            return this;
        }
        for (Object object : items) {
            this.add(object);
        }
        return this;
    }

    public JsonArrayBuilder addNull() {
        this.builder.addNull();
        return this;
    }

    public JsonArray build() {
        return new JsonArrayImpl(this.builder.build());
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        JsonWriterFactory writerFactory = javax.json.Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));
        try (JsonWriter jsonWriter = writerFactory.createWriter((Writer)sw);){
            jsonWriter.writeArray(this.builder.build());
        }
        String s = sw.toString();
        return s;
    }

    public JsonArrayBuilder add(JsonObject value) {
        if (value == null) {
            this.builder.addNull();
            return this;
        }
        this.builder.add((JsonValue)value);
        return this;
    }
}

