/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.vfsjfilechooser2.accessories.bookmarks;

import com.googlecode.vfsjfilechooser2.accessories.bookmarks.BookmarksReader;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.BookmarksWriter;
import com.googlecode.vfsjfilechooser2.accessories.bookmarks.TitledURLEntry;
import com.googlecode.vfsjfilechooser2.constants.VFSJFileChooserConstants;
import com.googlecode.vfsjfilechooser2.utils.VFSResources;
import com.googlecode.vfsjfilechooser2.utils.VFSURIValidator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class Bookmarks
extends AbstractTableModel {
    private static final long serialVersionUID = 6142063286592461932L;
    private static final String COLUMN_TITLE_NAME = VFSResources.getMessage("VFSJFileChooser.fileNameHeaderText");
    private static final String COLUMN_URL_NAME = VFSResources.getMessage("VFSJFileChooser.pathLabelText");
    private static final int COLUMN_TITLE_INDEX = 0;
    private static final int COLUMN_URL_INDEX = 1;
    private static final int NB_COLUMNS = 2;
    private final List<TitledURLEntry> entries = new ArrayList<TitledURLEntry>();
    private File favorites = VFSJFileChooserConstants.BOOKMARKS_FILE;
    private Logger logger = Logger.getLogger(Bookmarks.class.getName());
    private final transient BookmarksWriter writer = new BookmarksWriter();

    public Bookmarks() {
        if (!VFSJFileChooserConstants.CONFIG_DIRECTORY.exists() && !VFSJFileChooserConstants.CONFIG_DIRECTORY.mkdirs()) {
            this.logger.log(Level.SEVERE, "Unable to create config directory");
        }
        List<TitledURLEntry> values = this.load();
        for (TitledURLEntry entry : values) {
            this.add(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TitledURLEntry e) {
        List<TitledURLEntry> list = this.entries;
        synchronized (list) {
            this.entries.add(e);
            this.fireTableRowsInserted(this.entries.size() - 1, this.entries.size() - 1);
            VFSURIValidator v = new VFSURIValidator();
            if (!v.isValid(e.getURL())) {
                JOptionPane.showMessageDialog(null, VFSResources.getMessage("VFSFileChooser.errBADURI"));
            }
            this.save();
        }
    }

    public int getSize() {
        return this.entries.size();
    }

    public String getTitle(int index) {
        TitledURLEntry e = this.getEntry(index);
        return e == null ? null : e.getTitle();
    }

    public String getURL(int index) {
        TitledURLEntry e = this.getEntry(index);
        return e == null ? null : e.getURL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TitledURLEntry getEntry(int index) {
        if (index < 0 || index > this.entries.size()) {
            return null;
        }
        List<TitledURLEntry> list = this.entries;
        synchronized (list) {
            TitledURLEntry e = this.entries.get(index);
            return e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(int row) {
        List<TitledURLEntry> list = this.entries;
        synchronized (list) {
            this.entries.remove(row);
            this.fireTableRowsDeleted(row, row);
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveup(int row) {
        if (row == 0) {
            return;
        }
        TitledURLEntry b = this.getEntry(row);
        List<TitledURLEntry> list = this.entries;
        synchronized (list) {
            this.entries.remove(row);
            this.entries.add(row - 1, b);
            VFSURIValidator v = new VFSURIValidator();
            if (!v.isValid(b.getURL())) {
                JOptionPane.showMessageDialog(null, VFSResources.getMessage("VFSFileChooser.errBADURI"));
            }
            this.save();
        }
        this.fireTableRowsUpdated(row - 1, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void movedown(int row) {
        if (row == this.entries.size() - 1) {
            return;
        }
        TitledURLEntry b = this.getEntry(row);
        List<TitledURLEntry> list = this.entries;
        synchronized (list) {
            this.entries.remove(row);
            this.entries.add(row + 1, b);
            VFSURIValidator v = new VFSURIValidator();
            if (!v.isValid(b.getURL())) {
                JOptionPane.showMessageDialog(null, VFSResources.getMessage("VFSFileChooser.errBADURI"));
            }
            this.save();
        }
        this.fireTableRowsUpdated(row, row + 1);
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.entries.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        String obj = null;
        if (row < this.entries.size()) {
            if (col == 0) {
                obj = this.getEntry(row).getTitle();
            } else if (col == 1) {
                obj = this.getEntry(row).getURL();
            }
        }
        return obj;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        TitledURLEntry e = this.getEntry(row);
        if (col == 0) {
            e.setTitle(value.toString());
        } else if (col == 1) {
            e.setURL(value.toString());
        }
        this.fireTableRowsUpdated(row, row);
    }

    @Override
    public String getColumnName(int index) {
        return index == 0 ? COLUMN_TITLE_NAME : COLUMN_URL_NAME;
    }

    public List<TitledURLEntry> load() {
        try {
            if (this.favorites.exists()) {
                return new BookmarksReader(this.favorites).getParsedEntries();
            }
            this.writeDefaultFavorites();
        }
        catch (Exception e) {
            this.logger.warning("Rebuilding bookmarks");
            this.logger.log(Level.WARNING, e.getMessage(), e);
            this.writeDefaultFavorites();
        }
        return new ArrayList<TitledURLEntry>();
    }

    private void writeDefaultFavorites() {
        try {
            this.writer.writeToFile(new ArrayList<TitledURLEntry>(0), this.favorites);
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Unable to write bookmarks", ex);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unable to write bookmarks", e);
        }
    }

    public void save() {
        try {
            this.writer.writeToFile(this.entries, this.favorites);
        }
        catch (IOException ex) {
            this.logger.log(Level.SEVERE, "Unable to write bookmarks", ex);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Unable to write bookmarks", e);
        }
    }
}

