/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.installer.swing.impl.execution.wizard;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gvsig.gui.beans.wizard.panel.OptionPanel;
import org.gvsig.installer.lib.api.execution.InstallPackageService;
import org.gvsig.installer.swing.impl.execution.InstallWizardPanel_ext;
import org.gvsig.installer.swing.impl.execution.panel.SelectBundlesPanel;
import org.gvsig.installer.swing.impl.panel.DefaultProgressPanel;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.task.AbstractMonitorableTask;
import org.gvsig.tools.task.CancellableTask;
import org.gvsig.tools.task.SimpleTaskStatus;

public class AddBundlesWizardPage
extends DefaultProgressPanel
implements OptionPanel {
    private static final long serialVersionUID = 8531884535246881448L;
    private final InstallWizardPanel_ext wizardPanel;

    public AddBundlesWizardPage(InstallWizardPanel_ext installerExecutionWizard) {
        this.wizardPanel = installerExecutionWizard;
    }

    public JPanel getJPanel() {
        return this;
    }

    public String getPanelTitle() {
        return this.wizardPanel.getTranslation("_Loading_packages");
    }

    public void lastPanel() {
        this.wizardPanel.setFinishButtonEnabled(false);
        this.wizardPanel.setCancelButtonEnabled(true);
    }

    public void nextPanel() {
    }

    public void updatePanel() {
        if (this.wizardPanel.getDirection() == 0) {
            this.wizardPanel.skip();
            return;
        }
        this.wizardPanel.setFinishButtonEnabled(false);
        this.wizardPanel.setBackButtonEnabled(false);
        this.wizardPanel.setNextButtonEnabled(false);
        this.wizardPanel.setCancelButtonEnabled(true);
        UpdatePanel task = new UpdatePanel(this);
        this.wizardPanel.addCancellableTask((CancellableTask)task);
        this.bind(task.getTaskStatus());
        task.setDaemon(true);
        task.start();
    }

    private class UpdatePanel
    extends AbstractMonitorableTask {
        private final AddBundlesWizardPage panel;

        public UpdatePanel(AddBundlesWizardPage panel) {
            super(panel.wizardPanel.getTranslation("_Loading_packages"));
            this.panel = panel;
        }

        public synchronized void run() {
            try {
                logger.info("loading packages");
                SimpleTaskStatus taskStatus = (SimpleTaskStatus)this.getTaskStatus();
                taskStatus.setIndeterminate();
                InstallPackageService installerExecutionService = AddBundlesWizardPage.this.wizardPanel.getInstallerExecutionService();
                SelectBundlesPanel bundlesPanel = AddBundlesWizardPage.this.wizardPanel.getBundlesPanel();
                if (bundlesPanel.isStandardSelected()) {
                    installerExecutionService.addBundlesFromDirectory(AddBundlesWizardPage.this.wizardPanel.getInstallFolder(), taskStatus);
                } else if (bundlesPanel.isURLSelected() && bundlesPanel.getSelectedURL() != null) {
                    installerExecutionService.addBundle(bundlesPanel.getSelectedURL(), taskStatus);
                } else if (bundlesPanel.isFileSelected() && bundlesPanel.getSelectedFile() != null && bundlesPanel.getSelectedFile().exists()) {
                    installerExecutionService.addBundle(bundlesPanel.getSelectedFile(), taskStatus);
                }
                taskStatus.message(this.panel.wizardPanel.getTranslation("_Finished"));
                taskStatus.terminate();
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        AddBundlesWizardPage.this.wizardPanel.setFinishButtonEnabled(false);
                        AddBundlesWizardPage.this.wizardPanel.setBackButtonEnabled(true);
                        AddBundlesWizardPage.this.wizardPanel.setNextButtonEnabled(true);
                        AddBundlesWizardPage.this.wizardPanel.setCancelButtonEnabled(true);
                        AddBundlesWizardPage.this.wizardPanel.doAction(1);
                    }
                });
                logger.info("Loading packages finished");
            }
            catch (Throwable th) {
                logger.warn("Problems loading packages.", th);
                ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog(this.panel.wizardPanel.getTranslation("_Cant_load_packages"), this.panel.wizardPanel.getTranslation("_Warning"), 2);
            }
        }
    }
}

