/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.utils.swing.jcomboServer;

import java.util.Date;
import java.util.Properties;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.utils.DateTime;

public class ServerData
implements Persistent {
    public static final String PERSISTENT_NAME = "ServerData_Persistent";
    public static final String PERSISTENT_DESCRIPTION = "ServerData Persistent";
    public static final String SERVER_TYPE_CATALOG = "CATALOG";
    public static final String SERVER_TYPE_GAZETTEER = "GAZETTEER";
    public static final String SERVER_TYPE_MULTIPLE = "MULTIPLE";
    public static final String SERVER_TYPE_WMS = "WMS";
    public static final String SERVER_TYPE_WCS = "WCS";
    public static final String SERVER_TYPE_WFS = "WFS";
    public static final String SERVER_TYPE_WMTS = "WMTS";
    public static final String SERVER_SUBTYPE_CATALOG_Z3950 = "Z3950";
    public static final String SERVER_SUBTYPE_CATALOG_SRW = "SRW";
    public static final String SERVER_SUBTYPE_CATALOG_CSW = "CSW";
    public static final String SERVER_SUBTYPE_GAZETTEER_WFSG = "WFS-G";
    public static final String SERVER_SUBTYPE_GAZETTEER_ADL = "ADL";
    public static final String SERVER_SUBTYPE_GAZETTEER_IDEC = "IDEC";
    public static final String SERVER_SUBTYPE_GAZETTEER_WFS = "WFS";
    private Date added = null;
    private Date lastAccess = null;
    private String serviceType = null;
    private String serviceSubType = null;
    private String serverAddress = null;
    private String database = null;
    private Properties properies = new Properties();

    public ServerData(String serverAddress, Date added, Date lastAccess, String serviceType, String serviceSubType) {
        this.added = added;
        this.lastAccess = lastAccess;
        this.serviceType = serviceType;
        this.serviceSubType = serviceSubType;
        this.serverAddress = serverAddress;
    }

    public ServerData() {
    }

    public ServerData(String serverAddress, Date added, Date lastAccess, String serviceType, String serviceSubType, String database) {
        this.added = added;
        this.lastAccess = lastAccess;
        this.serviceType = serviceType;
        this.serviceSubType = serviceSubType;
        this.serverAddress = serverAddress;
        this.database = database;
    }

    public ServerData(String serverAddress, String serviceType, String serviceSubType) {
        this.serverAddress = serverAddress;
        this.added = DateTime.getCurrentDate();
        this.lastAccess = DateTime.getCurrentDate();
        this.serviceType = serviceType;
        this.serviceSubType = serviceSubType;
    }

    public ServerData(String serverAddress, String serviceType, String serviceSubType, String database) {
        this.serverAddress = serverAddress;
        this.added = DateTime.getCurrentDate();
        this.lastAccess = DateTime.getCurrentDate();
        this.serviceType = serviceType;
        this.serviceSubType = serviceSubType;
        this.database = database;
    }

    public ServerData(String serverAddress, String serviceType) {
        this.serverAddress = serverAddress;
        this.added = DateTime.getCurrentDate();
        this.lastAccess = DateTime.getCurrentDate();
        this.serviceType = serviceType;
        this.serviceSubType = "";
        this.database = "";
    }

    public void updateLastAccess() {
        this.lastAccess = DateTime.getCurrentDate();
    }

    public String toString() {
        return this.getServerAddress();
    }

    public Date getAdded() {
        return this.added;
    }

    public void setAdded(Date added) {
        this.added = added;
    }

    public Date getLastAccess() {
        return this.lastAccess;
    }

    public void setLastAccess(Date lastAccess) {
        this.lastAccess = lastAccess;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public String getServiceSubType() {
        return this.serviceSubType;
    }

    public void setServiceSubType(String serviceSubType) {
        this.serviceSubType = serviceSubType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public Properties getProperies() {
        return this.properies;
    }

    public void setProperies(Properties properies) {
        this.properies = properies;
    }

    public String getProperty(String propertyName) {
        return this.getProperies().getProperty(propertyName);
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set("serverAddress", this.serverAddress);
        state.set("serviceType", this.serviceType);
        state.set("serviceSubType", this.serviceSubType);
        state.set("added", this.added.getTime());
        state.set("lastAccess", this.lastAccess.getTime());
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.serverAddress = state.getString("serverAddress");
        this.serviceType = state.getString("serviceType");
        this.serviceSubType = state.getString("serviceSubType");
        this.added = new Date(state.getLong("added"));
        this.lastAccess = new Date(state.getLong("lastAccess"));
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        DynStruct definition = manager.getDefinition(PERSISTENT_NAME);
        if (definition == null) {
            definition = manager.addDefinition(ServerData.class, PERSISTENT_NAME, PERSISTENT_DESCRIPTION, null, null);
        }
        definition.addDynFieldString("serverAddress").setMandatory(true);
        definition.addDynFieldString("serviceType").setMandatory(true);
        definition.addDynFieldString("serviceSubType").setMandatory(false);
        definition.addDynFieldLong("added").setMandatory(false);
        definition.addDynFieldLong("lastAccess").setMandatory(false);
    }
}

