/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.components.line;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.properties.CompoundLineProperty;
import com.jeta.forms.store.properties.LineProperty;
import java.awt.Dimension;
import java.util.Iterator;
import javax.swing.JComponent;

public abstract class LineComponent
extends JComponent {
    private boolean m_design_mode = false;
    private CompoundLineProperty m_prop = new CompoundLineProperty();
    private Dimension m_pref_size;

    public LineComponent() {
        this.m_prop.addLine(new LineProperty());
        this.m_design_mode = FormUtils.isDesignMode();
    }

    public CompoundLineProperty getLineDefinition() {
        return this.m_prop;
    }

    public int getPosition() {
        return this.m_prop.getPosition();
    }

    public Dimension getPreferredSize() {
        if (this.m_pref_size == null) {
            if (this.isHorizontal()) {
                int width = 0;
                int height = 0;
                if (this.m_prop != null) {
                    height = this.getThickness();
                }
                if (width == 0) {
                    width = 10;
                }
                if (height == 0) {
                    height = 1;
                }
                this.m_pref_size = new Dimension(width, height);
            } else {
                int width = 0;
                int height = 0;
                if (this.m_prop != null) {
                    width = this.getThickness();
                }
                if (width == 0) {
                    width = 1;
                }
                if (height == 0) {
                    height = 10;
                }
                this.m_pref_size = new Dimension(width, height);
            }
        }
        return this.m_pref_size;
    }

    public int getThickness() {
        int t = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            LineProperty prop = (LineProperty)iter.next();
            t += prop.getThickness();
        }
        return t;
    }

    boolean isDesignMode() {
        return this.m_design_mode;
    }

    public abstract boolean isHorizontal();

    public Iterator iterator() {
        return this.m_prop.iterator();
    }

    public void setLineDefinition(CompoundLineProperty prop) {
        this.m_prop = prop;
        this.m_pref_size = null;
        this.revalidate();
        this.repaint();
    }

    public void setLineDefinitionEx(LineProperty prop) {
        this.setLineDefinition(new CompoundLineProperty(prop));
    }

    public void print() {
        System.out.println("LineComponent.....................");
        this.m_prop.print();
    }

    public void setPosition(int pos) {
        this.m_prop.setPosition(pos);
    }
}

