/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.effects;

import com.jeta.forms.gui.effects.Painter;
import com.jeta.forms.store.properties.effects.GradientProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.batik.ext.awt.LinearGradientPaint;

public class LinearGradientPainter
implements Painter {
    private GradientProperty m_gradient_prop;
    private Paint m_cached_paint;
    private Rectangle m_last_rect = new Rectangle();
    private LookAndFeel m_look_and_feel;

    public LinearGradientPainter() {
    }

    public LinearGradientPainter(GradientProperty prop) {
        this.m_gradient_prop = prop;
    }

    private Paint createPaint(Rectangle rect, GradientProperty gp) {
        Color startcolor = gp.getStartColor().getColor();
        Color endcolor = gp.getEndColor().getColor();
        int x1 = rect.x;
        int y1 = rect.y;
        int x2 = rect.x;
        int y2 = rect.y + (int)((float)rect.height * gp.getMagnitude());
        if (startcolor == null) {
            startcolor = Color.white;
        }
        if (endcolor == null) {
            endcolor = Color.white;
        }
        if (gp.getDirection() == 0) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = rect.x;
            y2 = rect.y + (int)((float)rect.height * gp.getMagnitude());
        } else if (gp.getDirection() == 1) {
            x1 = rect.x;
            y2 = rect.y;
            x2 = rect.x;
            y1 = rect.y + (int)((float)rect.height * gp.getMagnitude());
        } else if (gp.getDirection() == 2) {
            x1 = rect.x;
            y1 = rect.y;
            x2 = rect.x + (int)((float)rect.width * gp.getMagnitude());
            y2 = rect.y;
        } else if (gp.getDirection() == 3) {
            x2 = rect.x;
            y1 = rect.y;
            x1 = rect.x + (int)((float)rect.width * gp.getMagnitude());
            y2 = rect.y;
        } else if (gp.getDirection() == 5) {
            x1 = rect.x;
            y1 = rect.y + (int)((float)rect.height * gp.getMagnitude());
            x2 = rect.x + (int)((float)rect.width * gp.getMagnitude());
            y2 = rect.y;
        } else {
            x1 = rect.x;
            y1 = rect.y;
            x2 = rect.x + (int)((float)rect.width * gp.getMagnitude());
            y2 = rect.y + (int)((float)rect.height * gp.getMagnitude());
        }
        float[] fractions = new float[]{0.0f, 1.0f};
        Color[] colors = new Color[]{startcolor, endcolor};
        LinearGradientPaint paint = new LinearGradientPaint(x1, y1, x2, y2, fractions, colors);
        return paint;
    }

    public void paint(Component c, Graphics g, Rectangle rect) {
        if (rect == null || this.m_gradient_prop == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Paint old_paint = g2.getPaint();
        LookAndFeel lf = UIManager.getLookAndFeel();
        if (this.m_look_and_feel != lf) {
            this.m_cached_paint = null;
            this.m_look_and_feel = lf;
        }
        if (this.m_cached_paint == null || !rect.equals(this.m_last_rect)) {
            this.m_last_rect.setBounds(rect.x, rect.y, rect.width, rect.height);
            this.m_cached_paint = this.createPaint(rect, this.m_gradient_prop);
        }
        g2.setPaint(this.m_cached_paint);
        Rectangle clip_rect = g.getClipBounds();
        if (rect.intersects(clip_rect)) {
            Rectangle irect = rect.intersection(clip_rect);
            g.fillRect(irect.x, irect.y, irect.width, irect.height);
            g2.setPaint(old_paint);
        }
    }

    public void setGradientProperty(GradientProperty prop) {
        this.m_cached_paint = null;
        this.m_gradient_prop = prop;
    }
}

