/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.open.resources;

import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.ResourceLoader;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public class AppResourceLoader
implements ResourceLoader {
    private ClassLoader m_classloader;
    private static ImageIcon m_empty_icon;
    private static Hashtable m_imagecache;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassLoader getClassLoader() {
        if (this.m_classloader == null) {
            return AppResourceLoader.class.getClassLoader();
        }
        return this.m_classloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon getEmptyIcon() {
        Class clazz = AppResourceLoader.class;
        synchronized (clazz) {
            if (m_empty_icon == null) {
                int width = 16;
                int height = 16;
                BufferedImage img = new BufferedImage(width, height, 1);
                Graphics2D bg = img.createGraphics();
                bg.setColor(UIManager.getColor("control"));
                bg.fillRect(0, 0, width, height);
                bg.setColor(Color.red);
                bg.drawRect(0, 0, width - 1, height - 1);
                bg.drawLine(0, 0, width - 1, height - 1);
                bg.drawLine(0, height - 1, width - 1, 0);
                bg.dispose();
                m_empty_icon = new ImageIcon(img);
            }
        }
        return m_empty_icon;
    }

    public InputStream getResourceAsStream(String resourceName) throws IOException {
        ClassLoader classloader = this.getClassLoader();
        return classloader.getResourceAsStream(resourceName);
    }

    public static ImageIcon getImage(String imageName) {
        if (imageName != null) {
            ImageIcon icon = (ImageIcon)m_imagecache.get(imageName);
            if (icon == null) {
                try {
                    ResourceLoader loader = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
                    if (!$assertionsDisabled && loader == null) {
                        throw new AssertionError();
                    }
                    icon = loader.loadImage(imageName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (icon == null) {
                    icon = new ImageIcon();
                }
                m_imagecache.put(imageName, icon);
            }
            return icon;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return m_empty_icon;
    }

    public ImageIcon loadImage(String imageName) {
        try {
            ClassLoader classloader = this.getClassLoader();
            URL url = classloader.getResource(imageName);
            if (url != null) {
                ImageIcon icon = new ImageIcon(url);
                return icon;
            }
            System.err.println("AppResourceLoader.loadImage failed: " + imageName);
        }
        catch (Exception e) {
            System.err.println("AppResourceLoader.loadImage failed: " + imageName);
            e.printStackTrace();
        }
        return AppResourceLoader.getEmptyIcon();
    }

    public void setClassLoader(ClassLoader loader) {
        this.m_classloader = loader;
    }

    static {
        $assertionsDisabled = !AppResourceLoader.class.desiredAssertionStatus();
        m_imagecache = new Hashtable();
    }
}

