/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi.formatter.value;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;

public class Dict
implements Formatter<ExpressionBuilder.Value> {
    private final Formatter<ExpressionBuilder.Value> formatter;

    public Dict(Formatter<ExpressionBuilder.Value> formatter) {
        this.formatter = formatter;
    }

    @Override
    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof ExpressionBuilder.Function) {
            return StringUtils.equalsIgnoreCase((CharSequence)"DICT", (CharSequence)((ExpressionBuilder.Function)value).name());
        }
        return false;
    }

    @Override
    public String format(ExpressionBuilder.Value function0) {
        ExpressionBuilder.Function function = (ExpressionBuilder.Function)function0;
        List<ExpressionBuilder.Value> args = function.parameters();
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        boolean needcomma = false;
        int i_key = 0;
        int i_val = args.size() / 2;
        while (i_key < args.size() / 2) {
            ExpressionBuilder.Value key = args.get(i_key);
            ExpressionBuilder.Value value = args.get(i_val);
            if (needcomma) {
                builder.append(", ");
            } else {
                needcomma = true;
            }
            builder.append(key.toString(this.formatter));
            builder.append(":");
            builder.append(value.toString(this.formatter));
            ++i_key;
            ++i_val;
        }
        builder.append(" }");
        return builder.toString();
    }
}

