/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.c14n.implementations;

import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizerSpi;
import com.sun.org.apache.xml.internal.security.c14n.helper.AttrCompare;
import com.sun.org.apache.xml.internal.security.c14n.implementations.NameSpaceSymbTable;
import com.sun.org.apache.xml.internal.security.c14n.implementations.UtfHelpper;
import com.sun.org.apache.xml.internal.security.parser.XMLParserException;
import com.sun.org.apache.xml.internal.security.signature.NodeFilter;
import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

public abstract class CanonicalizerBase
extends CanonicalizerSpi {
    public static final String XML = "xml";
    public static final String XMLNS = "xmlns";
    public static final String XMLNS_URI = "http://www.w3.org/2000/xmlns/";
    public static final String XML_LANG_URI = "http://www.w3.org/XML/1998/namespace";
    protected static final AttrCompare COMPARE = new AttrCompare();
    protected static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    protected static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    protected static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    private static final byte[] END_PI = new byte[]{63, 62};
    private static final byte[] BEGIN_PI = new byte[]{60, 63};
    private static final byte[] END_COMM = new byte[]{45, 45, 62};
    private static final byte[] BEGIN_COMM = new byte[]{60, 33, 45, 45};
    private static final byte[] XA = new byte[]{38, 35, 120, 65, 59};
    private static final byte[] X9 = new byte[]{38, 35, 120, 57, 59};
    private static final byte[] QUOT = new byte[]{38, 113, 117, 111, 116, 59};
    private static final byte[] XD = new byte[]{38, 35, 120, 68, 59};
    private static final byte[] GT = new byte[]{38, 103, 116, 59};
    private static final byte[] LT = new byte[]{38, 108, 116, 59};
    private static final byte[] END_TAG = new byte[]{60, 47};
    private static final byte[] AMP = new byte[]{38, 97, 109, 112, 59};
    private static final byte[] EQUALS_STR = new byte[]{61, 34};
    private boolean includeComments;
    private List<NodeFilter> nodeFilter;
    private Set<Node> xpathNodeSet;
    private Attr nullNode;

    protected CanonicalizerBase(boolean bl) {
        this.includeComments = bl;
    }

    @Override
    public void engineCanonicalizeSubTree(Node node, OutputStream outputStream) throws CanonicalizationException {
        this.engineCanonicalizeSubTree(node, (Node)null, outputStream);
    }

    @Override
    public void engineCanonicalizeXPathNodeSet(Set<Node> set, OutputStream outputStream) throws CanonicalizationException {
        this.xpathNodeSet = set;
        this.engineCanonicalizeXPathNodeSetInternal(XMLUtils.getOwnerDocument(this.xpathNodeSet), outputStream);
    }

    public void engineCanonicalize(XMLSignatureInput xMLSignatureInput, OutputStream outputStream, boolean bl) throws CanonicalizationException {
        try {
            if (xMLSignatureInput.isExcludeComments()) {
                this.includeComments = false;
            }
            if (xMLSignatureInput.isOctetStream()) {
                this.engineCanonicalize(xMLSignatureInput.getBytes(), outputStream, bl);
            } else if (xMLSignatureInput.isElement()) {
                this.engineCanonicalizeSubTree(xMLSignatureInput.getSubNode(), xMLSignatureInput.getExcludeNode(), outputStream);
            } else if (xMLSignatureInput.isNodeSet()) {
                this.nodeFilter = xMLSignatureInput.getNodeFilters();
                this.circumventBugIfNeeded(xMLSignatureInput);
                if (xMLSignatureInput.getSubNode() != null) {
                    this.engineCanonicalizeXPathNodeSetInternal(xMLSignatureInput.getSubNode(), outputStream);
                } else {
                    this.engineCanonicalizeXPathNodeSet(xMLSignatureInput.getNodeSet(), outputStream);
                }
            }
        }
        catch (XMLParserException | IOException exception) {
            throw new CanonicalizationException(exception);
        }
    }

    protected void engineCanonicalizeSubTree(Node node, Node node2, OutputStream outputStream) throws CanonicalizationException {
        try {
            NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
            int n = -1;
            if (node != null && 1 == node.getNodeType()) {
                this.getParentNameSpaces((Element)node, nameSpaceSymbTable);
                n = 0;
            }
            this.canonicalizeSubTree(node, nameSpaceSymbTable, node, n, node2, outputStream);
            outputStream.flush();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CanonicalizationException(unsupportedEncodingException);
        }
        catch (IOException iOException) {
            throw new CanonicalizationException(iOException);
        }
    }

    private void canonicalizeSubTree(Node node, NameSpaceSymbTable nameSpaceSymbTable, Node node2, int n, Node node3, OutputStream outputStream) throws CanonicalizationException, IOException {
        if (node == null || this.isVisibleInt(node) == -1) {
            return;
        }
        Node node4 = null;
        Node node5 = null;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        while (true) {
            switch (node.getNodeType()) {
                case 2: 
                case 6: 
                case 12: {
                    throw new CanonicalizationException("empty", new Object[]{"illegal node type during traversal"});
                }
                case 9: 
                case 11: {
                    nameSpaceSymbTable.outputNodePush();
                    node4 = node.getFirstChild();
                    break;
                }
                case 8: {
                    if (!this.includeComments) break;
                    this.outputCommentToWriter((Comment)node, outputStream, n);
                    break;
                }
                case 7: {
                    this.outputPItoWriter((ProcessingInstruction)node, outputStream, n);
                    break;
                }
                case 3: 
                case 4: {
                    CanonicalizerBase.outputTextToWriter(node.getNodeValue(), outputStream);
                    break;
                }
                case 1: {
                    n = 0;
                    if (node == node3) break;
                    Element element = (Element)node;
                    nameSpaceSymbTable.outputNodePush();
                    outputStream.write(60);
                    String string = element.getTagName();
                    UtfHelpper.writeByte(string, outputStream, hashMap);
                    this.outputAttributesSubtree(element, nameSpaceSymbTable, hashMap, outputStream);
                    outputStream.write(62);
                    node4 = node.getFirstChild();
                    if (node4 == null) {
                        outputStream.write((byte[])END_TAG.clone());
                        UtfHelpper.writeStringToUtf8(string, outputStream);
                        outputStream.write(62);
                        nameSpaceSymbTable.outputNodePop();
                        if (node5 == null) break;
                        node4 = node.getNextSibling();
                        break;
                    }
                    node5 = element;
                    break;
                }
            }
            while (node4 == null && node5 != null) {
                outputStream.write((byte[])END_TAG.clone());
                UtfHelpper.writeByte(((Element)node5).getTagName(), outputStream, hashMap);
                outputStream.write(62);
                nameSpaceSymbTable.outputNodePop();
                if (node5 == node2) {
                    return;
                }
                node4 = node5.getNextSibling();
                if ((node5 = node5.getParentNode()) != null && 1 == node5.getNodeType()) continue;
                n = 1;
                node5 = null;
            }
            if (node4 == null) {
                return;
            }
            node = node4;
            node4 = node.getNextSibling();
        }
    }

    private void engineCanonicalizeXPathNodeSetInternal(Node node, OutputStream outputStream) throws CanonicalizationException {
        try {
            this.canonicalizeXPathNodeSet(node, node, outputStream);
            outputStream.flush();
        }
        catch (IOException iOException) {
            throw new CanonicalizationException(iOException);
        }
    }

    private void canonicalizeXPathNodeSet(Node node, Node node2, OutputStream outputStream) throws CanonicalizationException, IOException {
        if (this.isVisibleInt(node) == -1) {
            return;
        }
        boolean bl = false;
        NameSpaceSymbTable nameSpaceSymbTable = new NameSpaceSymbTable();
        if (node != null && 1 == node.getNodeType()) {
            this.getParentNameSpaces((Element)node, nameSpaceSymbTable);
        }
        if (node == null) {
            return;
        }
        Node node3 = null;
        Node node4 = null;
        int n = -1;
        HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
        while (true) {
            switch (node.getNodeType()) {
                case 2: 
                case 6: 
                case 12: {
                    throw new CanonicalizationException("empty", new Object[]{"illegal node type during traversal"});
                }
                case 9: 
                case 11: {
                    nameSpaceSymbTable.outputNodePush();
                    node3 = node.getFirstChild();
                    break;
                }
                case 8: {
                    if (!this.includeComments || this.isVisibleDO(node, nameSpaceSymbTable.getLevel()) != 1) break;
                    this.outputCommentToWriter((Comment)node, outputStream, n);
                    break;
                }
                case 7: {
                    if (!this.isVisible(node)) break;
                    this.outputPItoWriter((ProcessingInstruction)node, outputStream, n);
                    break;
                }
                case 3: 
                case 4: {
                    Node node5;
                    if (!this.isVisible(node)) break;
                    CanonicalizerBase.outputTextToWriter(node.getNodeValue(), outputStream);
                    for (node5 = node.getNextSibling(); node5 != null && (node5.getNodeType() == 3 || node5.getNodeType() == 4); node5 = node5.getNextSibling()) {
                        CanonicalizerBase.outputTextToWriter(node5.getNodeValue(), outputStream);
                        node = node5;
                        node3 = node.getNextSibling();
                    }
                    break;
                }
                case 1: {
                    n = 0;
                    Node node5 = (Element)node;
                    String string = null;
                    int n2 = this.isVisibleDO(node, nameSpaceSymbTable.getLevel());
                    if (n2 == -1) {
                        node3 = node.getNextSibling();
                        break;
                    }
                    boolean bl2 = bl = n2 == 1;
                    if (bl) {
                        nameSpaceSymbTable.outputNodePush();
                        outputStream.write(60);
                        string = node5.getTagName();
                        UtfHelpper.writeByte(string, outputStream, hashMap);
                    } else {
                        nameSpaceSymbTable.push();
                    }
                    this.outputAttributes((Element)node5, nameSpaceSymbTable, hashMap, outputStream);
                    if (bl) {
                        outputStream.write(62);
                    }
                    if ((node3 = node.getFirstChild()) == null) {
                        if (bl) {
                            outputStream.write((byte[])END_TAG.clone());
                            UtfHelpper.writeByte(string, outputStream, hashMap);
                            outputStream.write(62);
                            nameSpaceSymbTable.outputNodePop();
                        } else {
                            nameSpaceSymbTable.pop();
                        }
                        if (node4 == null) break;
                        node3 = node.getNextSibling();
                        break;
                    }
                    node4 = node5;
                    break;
                }
            }
            while (node3 == null && node4 != null) {
                if (this.isVisible(node4)) {
                    outputStream.write((byte[])END_TAG.clone());
                    UtfHelpper.writeByte(((Element)node4).getTagName(), outputStream, hashMap);
                    outputStream.write(62);
                    nameSpaceSymbTable.outputNodePop();
                } else {
                    nameSpaceSymbTable.pop();
                }
                if (node4 == node2) {
                    return;
                }
                node3 = node4.getNextSibling();
                if ((node4 = node4.getParentNode()) != null && 1 == node4.getNodeType()) continue;
                node4 = null;
                n = 1;
            }
            if (node3 == null) {
                return;
            }
            node = node3;
            node3 = node.getNextSibling();
        }
    }

    protected int isVisibleDO(Node node, int n) {
        if (this.nodeFilter != null) {
            Iterator<NodeFilter> iterator = this.nodeFilter.iterator();
            while (iterator.hasNext()) {
                int n2 = iterator.next().isNodeIncludeDO(node, n);
                if (n2 == 1) continue;
                return n2;
            }
        }
        if (this.xpathNodeSet != null && !this.xpathNodeSet.contains(node)) {
            return 0;
        }
        return 1;
    }

    protected int isVisibleInt(Node node) {
        if (this.nodeFilter != null) {
            Iterator<NodeFilter> iterator = this.nodeFilter.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next().isNodeInclude(node);
                if (n == 1) continue;
                return n;
            }
        }
        if (this.xpathNodeSet != null && !this.xpathNodeSet.contains(node)) {
            return 0;
        }
        return 1;
    }

    protected boolean isVisible(Node node) {
        if (this.nodeFilter != null) {
            Iterator<NodeFilter> iterator = this.nodeFilter.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().isNodeInclude(node) == 1) continue;
                return false;
            }
        }
        return this.xpathNodeSet == null || this.xpathNodeSet.contains(node);
    }

    protected void handleParent(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        Object object;
        String string;
        Object object2;
        if (!element.hasAttributes() && element.getNamespaceURI() == null) {
            return;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = namedNodeMap.getLength();
        for (int i = 0; i < n; ++i) {
            object2 = (Attr)namedNodeMap.item(i);
            string = object2.getLocalName();
            object = object2.getNodeValue();
            if (!XMLNS_URI.equals(object2.getNamespaceURI()) || XML.equals(string) && XML_LANG_URI.equals(object)) continue;
            nameSpaceSymbTable.addMapping(string, (String)object, (Attr)object2);
        }
        if (element.getNamespaceURI() != null) {
            String string2 = element.getPrefix();
            object2 = element.getNamespaceURI();
            if (string2 == null || string2.isEmpty()) {
                string2 = XMLNS;
                string = XMLNS;
            } else {
                string = "xmlns:" + string2;
            }
            object = element.getOwnerDocument().createAttributeNS(XMLNS_URI, string);
            object.setValue((String)object2);
            nameSpaceSymbTable.addMapping(string2, (String)object2, (Attr)object);
        }
    }

    private void getParentNameSpaces(Element element, NameSpaceSymbTable nameSpaceSymbTable) {
        Node node;
        Node node2 = element.getParentNode();
        if (node2 == null || 1 != node2.getNodeType()) {
            return;
        }
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node3 = node2; node3 != null && 1 == node3.getNodeType(); node3 = node3.getParentNode()) {
            arrayList.add((Element)node3);
        }
        ListIterator listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            node = (Element)listIterator.previous();
            this.handleParent((Element)node, nameSpaceSymbTable);
        }
        arrayList.clear();
        node = nameSpaceSymbTable.getMappingWithoutRendered(XMLNS);
        if (node != null && "".equals(node.getValue())) {
            nameSpaceSymbTable.addMappingAndRender(XMLNS, "", this.getNullNode(node.getOwnerDocument()));
        }
    }

    abstract void outputAttributes(Element var1, NameSpaceSymbTable var2, Map<String, byte[]> var3, OutputStream var4) throws CanonicalizationException, DOMException, IOException;

    abstract void outputAttributesSubtree(Element var1, NameSpaceSymbTable var2, Map<String, byte[]> var3, OutputStream var4) throws CanonicalizationException, DOMException, IOException;

    abstract void circumventBugIfNeeded(XMLSignatureInput var1) throws XMLParserException, IOException;

    protected static final void outputAttrToWriter(String string, String string2, OutputStream outputStream, Map<String, byte[]> map) throws IOException {
        outputStream.write(32);
        UtfHelpper.writeByte(string, outputStream, map);
        outputStream.write((byte[])EQUALS_STR.clone());
        int n = string2.length();
        int n2 = 0;
        block8: while (n2 < n) {
            byte[] byArray;
            int n3 = string2.codePointAt(n2);
            n2 += Character.charCount(n3);
            switch (n3) {
                case 38: {
                    byArray = (byte[])AMP.clone();
                    break;
                }
                case 60: {
                    byArray = (byte[])LT.clone();
                    break;
                }
                case 34: {
                    byArray = (byte[])QUOT.clone();
                    break;
                }
                case 9: {
                    byArray = (byte[])X9.clone();
                    break;
                }
                case 10: {
                    byArray = (byte[])XA.clone();
                    break;
                }
                case 13: {
                    byArray = (byte[])XD.clone();
                    break;
                }
                default: {
                    if (n3 < 128) {
                        outputStream.write(n3);
                        continue block8;
                    }
                    UtfHelpper.writeCodePointToUtf8(n3, outputStream);
                    continue block8;
                }
            }
            outputStream.write(byArray);
        }
        outputStream.write(34);
    }

    protected void outputPItoWriter(ProcessingInstruction processingInstruction, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (n == 1) {
            outputStream.write(10);
        }
        outputStream.write((byte[])BEGIN_PI.clone());
        String string = processingInstruction.getTarget();
        int n3 = string.length();
        for (int i = 0; i < n3; i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (n2 == 13) {
                outputStream.write((byte[])XD.clone());
                continue;
            }
            if (n2 < 128) {
                outputStream.write(n2);
                continue;
            }
            UtfHelpper.writeCodePointToUtf8(n2, outputStream);
        }
        String string2 = processingInstruction.getData();
        n3 = string2.length();
        if (n3 > 0) {
            int n4;
            outputStream.write(32);
            for (n2 = 0; n2 < n3; n2 += Character.charCount(n4)) {
                n4 = string2.codePointAt(n2);
                if (n4 == 13) {
                    outputStream.write((byte[])XD.clone());
                    continue;
                }
                UtfHelpper.writeCodePointToUtf8(n4, outputStream);
            }
        }
        outputStream.write((byte[])END_PI.clone());
        if (n == -1) {
            outputStream.write(10);
        }
    }

    protected void outputCommentToWriter(Comment comment, OutputStream outputStream, int n) throws IOException {
        int n2;
        if (n == 1) {
            outputStream.write(10);
        }
        outputStream.write((byte[])BEGIN_COMM.clone());
        String string = comment.getData();
        int n3 = string.length();
        for (int i = 0; i < n3; i += Character.charCount(n2)) {
            n2 = string.codePointAt(i);
            if (n2 == 13) {
                outputStream.write((byte[])XD.clone());
                continue;
            }
            if (n2 < 128) {
                outputStream.write(n2);
                continue;
            }
            UtfHelpper.writeCodePointToUtf8(n2, outputStream);
        }
        outputStream.write((byte[])END_COMM.clone());
        if (n == -1) {
            outputStream.write(10);
        }
    }

    private static final void outputTextToWriter(String string, OutputStream outputStream) throws IOException {
        int n = string.length();
        int n2 = 0;
        block6: while (n2 < n) {
            byte[] byArray;
            int n3 = string.codePointAt(n2);
            n2 += Character.charCount(n3);
            switch (n3) {
                case 38: {
                    byArray = (byte[])AMP.clone();
                    break;
                }
                case 60: {
                    byArray = (byte[])LT.clone();
                    break;
                }
                case 62: {
                    byArray = (byte[])GT.clone();
                    break;
                }
                case 13: {
                    byArray = (byte[])XD.clone();
                    break;
                }
                default: {
                    if (n3 < 128) {
                        outputStream.write(n3);
                        continue block6;
                    }
                    UtfHelpper.writeCodePointToUtf8(n3, outputStream);
                    continue block6;
                }
            }
            outputStream.write(byArray);
        }
    }

    protected Attr getNullNode(Document document) {
        if (this.nullNode == null) {
            try {
                this.nullNode = document.createAttributeNS(XMLNS_URI, XMLNS);
                this.nullNode.setValue("");
            }
            catch (Exception exception) {
                throw new RuntimeException("Unable to create nullNode: " + exception);
            }
        }
        return this.nullNode;
    }
}

