/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.FilePermissionCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.InvalidPathException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;

public final class FilePermission
extends Permission
implements Serializable {
    private static final int EXECUTE = 1;
    private static final int WRITE = 2;
    private static final int READ = 4;
    private static final int DELETE = 8;
    private static final int READLINK = 16;
    private static final int ALL = 31;
    private static final int NONE = 0;
    private transient int mask;
    private transient boolean directory;
    private transient boolean recursive;
    private String actions;
    private transient String cpath;
    private transient boolean invalid;
    private transient boolean allFiles;
    private static final char RECURSIVE_CHAR = '-';
    private static final char WILD_CHAR = '*';
    private static final long serialVersionUID = 7930732926638008763L;

    private void init(int n) {
        int n2;
        if ((n & 0x1F) != n) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        if (n == 0) {
            throw new IllegalArgumentException("invalid actions mask");
        }
        this.cpath = this.getName();
        if (this.cpath == null) {
            throw new NullPointerException("name can't be null");
        }
        this.mask = n;
        if (this.cpath.equals("<<ALL FILES>>")) {
            this.allFiles = true;
            this.directory = true;
            this.recursive = true;
            this.cpath = "";
            return;
        }
        if (this.isPathInvalid()) {
            this.invalid = true;
            return;
        }
        this.cpath = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    String string = FilePermission.this.cpath;
                    if (FilePermission.this.cpath.endsWith("*")) {
                        string = string.substring(0, string.length() - 1) + "-";
                        string = new File(string).getCanonicalPath();
                        return string.substring(0, string.length() - 1) + "*";
                    }
                    return new File(string).getCanonicalPath();
                }
                catch (IOException iOException) {
                    return FilePermission.this.cpath;
                }
            }
        });
        int n3 = this.cpath.length();
        int n4 = n2 = n3 > 0 ? (int)this.cpath.charAt(n3 - 1) : 0;
        if (n2 == 45 && this.cpath.charAt(n3 - 2) == File.separatorChar) {
            this.directory = true;
            this.recursive = true;
            this.cpath = this.cpath.substring(0, --n3);
        } else if (n2 == 42 && this.cpath.charAt(n3 - 2) == File.separatorChar) {
            this.directory = true;
            this.cpath = this.cpath.substring(0, --n3);
        }
    }

    private boolean isPathInvalid() {
        if (this.cpath.indexOf(". ") != -1) {
            try {
                String string = this.cpath.endsWith("*") ? this.cpath.substring(0, this.cpath.length() - 1) + "-" : this.cpath;
                new File(string).toPath();
            }
            catch (InvalidPathException invalidPathException) {
                return true;
            }
        }
        return false;
    }

    public FilePermission(String string, String string2) {
        super(string);
        this.init(FilePermission.getMask(string2));
    }

    FilePermission(String string, int n) {
        super(string);
        this.init(n);
    }

    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)permission;
        return (this.mask & filePermission.mask) == filePermission.mask && this.impliesIgnoreMask(filePermission);
    }

    boolean impliesIgnoreMask(FilePermission filePermission) {
        if (this == filePermission) {
            return true;
        }
        if (this.allFiles) {
            return true;
        }
        if (this.invalid || filePermission.invalid) {
            return false;
        }
        if (filePermission.allFiles) {
            return false;
        }
        if (this.directory) {
            if (this.recursive) {
                if (filePermission.directory) {
                    return filePermission.cpath.length() >= this.cpath.length() && filePermission.cpath.startsWith(this.cpath);
                }
                return filePermission.cpath.length() > this.cpath.length() && filePermission.cpath.startsWith(this.cpath);
            }
            if (filePermission.directory) {
                if (filePermission.recursive) {
                    return false;
                }
                return this.cpath.equals(filePermission.cpath);
            }
            int n = filePermission.cpath.lastIndexOf(File.separatorChar);
            if (n == -1) {
                return false;
            }
            return this.cpath.length() == n + 1 && this.cpath.regionMatches(0, filePermission.cpath, 0, n + 1);
        }
        if (filePermission.directory) {
            return false;
        }
        return this.cpath.equals(filePermission.cpath);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)object;
        if (this.invalid || filePermission.invalid) {
            return false;
        }
        return this.mask == filePermission.mask && this.allFiles == filePermission.allFiles && this.cpath.equals(filePermission.cpath) && this.directory == filePermission.directory && this.recursive == filePermission.recursive;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private static int getMask(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        if (string == "read") {
            return 4;
        }
        if (string == "write") {
            return 2;
        }
        if (string == "execute") {
            return 1;
        }
        if (string == "delete") {
            return 8;
        }
        if (string == "readlink") {
            return 16;
        }
        char[] cArray = string.toCharArray();
        int n2 = cArray.length - 1;
        if (n2 < 0) {
            return n;
        }
        while (n2 != -1) {
            int n3;
            char c;
            while (n2 != -1 && ((c = cArray[n2]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) {
                --n2;
            }
            if (!(n2 < 3 || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 'a' && cArray[n2 - 1] != 'A' || cArray[n2] != 'd' && cArray[n2] != 'D')) {
                n3 = 4;
                n |= 4;
            } else if (!(n2 < 4 || cArray[n2 - 4] != 'w' && cArray[n2 - 4] != 'W' || cArray[n2 - 3] != 'r' && cArray[n2 - 3] != 'R' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 5;
                n |= 2;
            } else if (!(n2 < 6 || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 'x' && cArray[n2 - 5] != 'X' || cArray[n2 - 4] != 'e' && cArray[n2 - 4] != 'E' || cArray[n2 - 3] != 'c' && cArray[n2 - 3] != 'C' || cArray[n2 - 2] != 'u' && cArray[n2 - 2] != 'U' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 7;
                n |= 1;
            } else if (!(n2 < 5 || cArray[n2 - 5] != 'd' && cArray[n2 - 5] != 'D' || cArray[n2 - 4] != 'e' && cArray[n2 - 4] != 'E' || cArray[n2 - 3] != 'l' && cArray[n2 - 3] != 'L' || cArray[n2 - 2] != 'e' && cArray[n2 - 2] != 'E' || cArray[n2 - 1] != 't' && cArray[n2 - 1] != 'T' || cArray[n2] != 'e' && cArray[n2] != 'E')) {
                n3 = 6;
                n |= 8;
            } else if (!(n2 < 7 || cArray[n2 - 7] != 'r' && cArray[n2 - 7] != 'R' || cArray[n2 - 6] != 'e' && cArray[n2 - 6] != 'E' || cArray[n2 - 5] != 'a' && cArray[n2 - 5] != 'A' || cArray[n2 - 4] != 'd' && cArray[n2 - 4] != 'D' || cArray[n2 - 3] != 'l' && cArray[n2 - 3] != 'L' || cArray[n2 - 2] != 'i' && cArray[n2 - 2] != 'I' || cArray[n2 - 1] != 'n' && cArray[n2 - 1] != 'N' || cArray[n2] != 'k' && cArray[n2] != 'K')) {
                n3 = 8;
                n |= 0x10;
            } else {
                throw new IllegalArgumentException("invalid permission: " + string);
            }
            boolean bl = false;
            while (n2 >= n3 && !bl) {
                switch (cArray[n2 - n3]) {
                    case ',': {
                        bl = true;
                        break;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + string);
                    }
                }
                --n2;
            }
            n2 -= n3;
        }
        return n;
    }

    int getMask() {
        return this.mask;
    }

    private static String getActions(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        if ((n & 4) == 4) {
            bl = true;
            stringBuilder.append("read");
        }
        if ((n & 2) == 2) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("write");
        }
        if ((n & 1) == 1) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("execute");
        }
        if ((n & 8) == 8) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("delete");
        }
        if ((n & 0x10) == 16) {
            if (bl) {
                stringBuilder.append(',');
            } else {
                bl = true;
            }
            stringBuilder.append("readlink");
        }
        return stringBuilder.toString();
    }

    @Override
    public String getActions() {
        if (this.actions == null) {
            this.actions = FilePermission.getActions(this.mask);
        }
        return this.actions;
    }

    @Override
    public PermissionCollection newPermissionCollection() {
        return new FilePermissionCollection();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init(FilePermission.getMask(this.actions));
    }
}

