/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectIntBufferRS;
import java.nio.IntBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectIntBufferS
extends IntBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(int[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectIntBufferS(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.att = directBuffer;
    }

    @Override
    public IntBuffer slice() {
        int n;
        int n2 = this.position();
        int n3 = n2 <= (n = this.limit()) ? n - n2 : 0;
        int n4 = n2 << 2;
        assert (n4 >= 0);
        return new DirectIntBufferS(this, -1, 0, n3, n3, n4);
    }

    @Override
    public IntBuffer duplicate() {
        return new DirectIntBufferS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public IntBuffer asReadOnlyBuffer() {
        return new DirectIntBufferRS(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + ((long)n << 2);
    }

    @Override
    public int get() {
        return Bits.swap(unsafe.getInt(this.ix(this.nextGetIndex())));
    }

    @Override
    public int get(int n) {
        return Bits.swap(unsafe.getInt(this.ix(this.checkIndex(n))));
    }

    @Override
    public IntBuffer get(int[] nArray, int n, int n2) {
        if ((long)n2 << 2 > 6L) {
            int n3;
            DirectIntBufferS.checkBounds(n, n2, nArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToIntArray(this.ix(n4), nArray, (long)n << 2, (long)n2 << 2);
            } else {
                Bits.copyToArray(this.ix(n4), nArray, arrayBaseOffset, (long)n << 2, (long)n2 << 2);
            }
            this.position(n4 + n2);
        } else {
            super.get(nArray, n, n2);
        }
        return this;
    }

    @Override
    public IntBuffer put(int n) {
        unsafe.putInt(this.ix(this.nextPutIndex()), Bits.swap(n));
        return this;
    }

    @Override
    public IntBuffer put(int n, int n2) {
        unsafe.putInt(this.ix(this.checkIndex(n)), Bits.swap(n2));
        return this;
    }

    @Override
    public IntBuffer put(IntBuffer intBuffer) {
        if (intBuffer instanceof DirectIntBufferS) {
            int n;
            int n2;
            if (intBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectIntBufferS directIntBufferS = (DirectIntBufferS)intBuffer;
            int n3 = directIntBufferS.position();
            int n4 = n3 <= (n2 = directIntBufferS.limit()) ? n2 - n3 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directIntBufferS.ix(n3), this.ix(n5), (long)n4 << 2);
            directIntBufferS.position(n3 + n4);
            this.position(n5 + n4);
        } else if (intBuffer.hb != null) {
            int n = intBuffer.position();
            int n8 = intBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(intBuffer.hb, intBuffer.offset + n, n9);
            intBuffer.position(n + n9);
        } else {
            super.put(intBuffer);
        }
        return this;
    }

    @Override
    public IntBuffer put(int[] nArray, int n, int n2) {
        if ((long)n2 << 2 > 6L) {
            int n3;
            DirectIntBufferS.checkBounds(n, n2, nArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromIntArray(nArray, (long)n << 2, this.ix(n4), (long)n2 << 2);
            } else {
                Bits.copyFromArray(nArray, arrayBaseOffset, (long)n << 2, this.ix(n4), (long)n2 << 2);
            }
            this.position(n4 + n2);
        } else {
            super.put(nArray, n, n2);
        }
        return this;
    }

    @Override
    public IntBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), (long)n3 << 2);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

