/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.process;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.Panel;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.installer.data.GUIInstallData;
import com.izforge.izpack.installer.gui.InstallerFrame;
import com.izforge.izpack.installer.gui.IzPanel;
import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.izforge.izpack.panels.process.ProcessPanelWorker;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ProcessPanel
extends IzPanel
implements AbstractUIProcessHandler {
    private static final long serialVersionUID = 3258417209583155251L;
    protected JLabel processLabel;
    protected JProgressBar overallProgressBar;
    private boolean validated = false;
    private ProcessPanelWorker worker;
    private int noOfJobs = 0;
    private int currentJob = 0;
    private JTextArea outputPane;
    private boolean finishedWork = false;

    public ProcessPanel(Panel panel, InstallerFrame parent, GUIInstallData installData, Resources resources, RulesEngine rules, PlatformModelMatcher matcher) {
        super(panel, parent, installData, resources);
        this.worker = new ProcessPanelWorker(installData, rules, resources, matcher);
        this.worker.setHandler(this);
        JLabel heading = new JLabel();
        Font font = heading.getFont();
        font = font.deriveFont(1, (float)font.getSize() * 2.0f);
        heading.setFont(font);
        heading.setHorizontalAlignment(0);
        heading.setText(this.getString("ProcessPanel.heading"));
        heading.setVerticalAlignment(1);
        BorderLayout layout = new BorderLayout();
        layout.setHgap(2);
        layout.setVgap(2);
        this.setLayout(layout);
        this.add((Component)heading, "North");
        JPanel subpanel = new JPanel();
        subpanel.setAlignmentX(0.5f);
        subpanel.setLayout(new BoxLayout(subpanel, 1));
        this.processLabel = new JLabel();
        this.processLabel.setAlignmentX(0.5f);
        this.processLabel.setText(" ");
        subpanel.add(this.processLabel);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setAlignmentX(0.5f);
        this.overallProgressBar.setStringPainted(true);
        subpanel.add(this.overallProgressBar);
        this.outputPane = new JTextArea();
        this.outputPane.setEditable(false);
        JScrollPane outputScrollPane = new JScrollPane(this.outputPane);
        subpanel.add(outputScrollPane);
        this.add((Component)subpanel, "Center");
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void startProcessing(final int no_of_jobs) {
        this.noOfJobs = no_of_jobs;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProcessPanel.this.overallProgressBar.setMaximum(no_of_jobs);
                ProcessPanel.this.overallProgressBar.setIndeterminate(true);
                ProcessPanel.this.parent.lockPrevButton();
            }
        });
    }

    @Override
    public void finishProcessing(final boolean unlockPrev, final boolean unlockNext) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProcessPanel.this.overallProgressBar.setIndeterminate(false);
                String no_of_jobs = Integer.toString(ProcessPanel.this.noOfJobs);
                ProcessPanel.this.overallProgressBar.setString(no_of_jobs + " / " + no_of_jobs);
                ProcessPanel.this.processLabel.setText(" ");
                ProcessPanel.this.processLabel.setEnabled(false);
                ProcessPanel.this.validated = true;
                ProcessPanel.this.installData.setInstallSuccess(ProcessPanel.this.worker.getResult());
                if (ProcessPanel.this.installData.getPanels().indexOf(ProcessPanel.this) != ProcessPanel.this.installData.getPanels().size() - 1 && unlockNext) {
                    ProcessPanel.this.parent.unlockNextButton();
                }
                if (unlockPrev) {
                    ProcessPanel.this.parent.unlockPrevButton();
                }
                ProcessPanel.this.finishedWork = ProcessPanel.this.installData.isInstallSuccess();
            }
        });
    }

    @Override
    public void logOutput(String message, boolean stderr) {
        this.outputPane.append(message + '\n');
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProcessPanel.this.outputPane.setCaretPosition(ProcessPanel.this.outputPane.getText().length());
            }
        });
    }

    @Override
    public void startProcess(final String jobName) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProcessPanel.this.processLabel.setText(jobName);
                ProcessPanel.this.currentJob++;
                ProcessPanel.this.overallProgressBar.setValue(ProcessPanel.this.currentJob);
                ProcessPanel.this.overallProgressBar.setString(String.valueOf(ProcessPanel.this.currentJob) + " / " + String.valueOf(ProcessPanel.this.noOfJobs));
            }
        });
    }

    @Override
    public void finishProcess() {
    }

    @Override
    public void panelActivate() {
        Dimension dimension = this.parent.getPanelsContainerSize();
        dimension.width -= dimension.width / 4;
        dimension.height = 150;
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.parent.lockNextButton();
        this.currentJob = 0;
        if (!this.finishedWork) {
            this.worker.startThread();
        }
    }

    public void makeXMLData(IXMLElement panelRoot) {
    }
}

