/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.MessageBarController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageBarControllerImpl
implements MessageBarController {
    private JLabel label;
    private int time;
    private final Timer timer;
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageBarControllerImpl.class);

    public MessageBarControllerImpl(JLabel label, int time) {
        this.label = label;
        this.time = time;
        this.timer = this.buildTimer();
    }

    private Timer buildTimer() {
        Timer newTimer = new Timer(this.time, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MessageBarControllerImpl.this.clear();
                }
                catch (Throwable ex) {
                    LOGGER.info("Can't clear message", ex);
                }
            }
        });
        return newTimer;
    }

    private String toHTML(String s) {
        s = StringUtils.replace((String)s, (String)"\n", (String)"\n<br>");
        s = StringUtils.replace((String)s, (String)"<html>", (String)"");
        s = StringUtils.replace((String)s, (String)"</html>", (String)"");
        s = "<html>" + s + "</html>";
        return s;
    }

    public void setTime(int time) {
        this.time = time;
        this.timer.setDelay(this.time);
    }

    public void setText(final String msg, final int messageType) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MessageBarControllerImpl.this.setText(msg, messageType);
                }
            });
            return;
        }
        this.timer.stop();
        if (StringUtils.isBlank((CharSequence)msg)) {
            this.clear();
            return;
        }
        this.label.setText(this.toHTML(msg));
        this.label.paintImmediately(this.label.getVisibleRect());
        this.label.paintImmediately(this.label.getVisibleRect());
        this.timer.start();
    }

    public void setText(String text) {
        this.setText(text, -1);
    }

    public void clear() {
        this.label.setText("");
    }
}

