/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.bookmarkshistory;

import java.sql.Timestamp;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.bookmarksandhistory.Bookmark;
import org.gvsig.tools.bookmarksandhistory.Bookmarks;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.identitymanagement.SimpleIdentity;
import org.gvsig.tools.identitymanagement.SimpleIdentityManager;
import org.gvsig.tools.swing.api.ActionListenerSupport;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.impl.bookmarkshistory.DefaultBookmarksController;
import org.gvsig.tools.swing.impl.bookmarkshistory.DefaultBookmarksPanelView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBookmarksPanel<T>
extends DefaultBookmarksPanelView {
    public static final Logger LOGGER = LoggerFactory.getLogger(DefaultBookmarksPanel.class);
    public static final int STATE_VIEWING = 0;
    public static final int STATE_MODIFYING = 1;
    private Bookmarks<T> bookmarks;
    private final ActionListenerSupport listenerHelper;
    private int state;
    private Bookmark<T> currentBookmark;
    private BookmarkListModel bookmarkListModel;

    public DefaultBookmarksPanel(Bookmarks<T> bookmarks) {
        this(bookmarks, null);
    }

    public DefaultBookmarksPanel(Bookmarks<T> bookmarks, ActionListenerSupport listenerHelper) {
        this.bookmarks = bookmarks;
        this.listenerHelper = listenerHelper;
        this.state = 0;
        this.initComponents();
    }

    public int getState() {
        return this.state;
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager swingManager = ToolsSwingLocator.getToolsSwingManager();
        swingManager.translate((AbstractButton)this.btnAccept);
        swingManager.translate((AbstractButton)this.btnDelete);
        swingManager.translate((AbstractButton)this.btnDiscard);
        swingManager.translate((AbstractButton)this.btnModify);
        swingManager.translate(this.lblLabel);
        swingManager.translate(this.lblLastUse);
        swingManager.translate(this.lblName);
        swingManager.translate(this.lblCanByUsedBy);
        swingManager.translate((AbstractButton)this.rdbLastUseOrder);
        swingManager.translate((AbstractButton)this.rdbAlphabeticallyOrder);
        switch (this.bookmarks.getOrder()) {
            default: {
                this.rdbAlphabeticallyOrder.setSelected(true);
                this.rdbLastUseOrder.setSelected(false);
                break;
            }
            case 1: {
                this.rdbAlphabeticallyOrder.setSelected(false);
                this.rdbLastUseOrder.setSelected(true);
            }
        }
        this.rdbLastUseOrder.setVisible(true);
        this.rdbAlphabeticallyOrder.setVisible(true);
        this.txtLabel.setLineWrap(true);
        this.currentBookmark = null;
        this.updateBookmarksModel();
        this.lstBookmarks.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (this.state != 0) {
                return;
            }
            Bookmark value = (Bookmark)this.lstBookmarks.getSelectedValue();
            if (value == null) {
                return;
            }
            this.put(value);
            this.changeStateTo(this.state);
        });
        this.btnDelete.addActionListener(e -> this.doDelete());
        this.btnModify.addActionListener(e -> this.doModify());
        this.btnAccept.addActionListener(e -> this.doAccept());
        this.btnDiscard.addActionListener(e -> this.doDiscard());
        this.rdbLastUseOrder.addActionListener(e -> this.updateBookmarksModel());
        this.rdbAlphabeticallyOrder.addActionListener(e -> this.updateBookmarksModel());
        this.txtLastUse.setEditable(false);
        this.txtLabel.setEditable(false);
        this.cboCanByUsedBy.setEnabled(false);
        this.txtName.setEnabled(false);
        this.changeStateTo(0);
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)28, (int)100, (int)35, (int)120);
    }

    private void setCurrentUser(boolean global) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        SimpleIdentityManager userManager = ToolsLocator.getIdentityManager();
        SimpleIdentity user = userManager.getCurrentIdentity();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(i18n.getTranslation("_All_users"));
        if (user != null) {
            String userName = user.getID();
            model.addElement(i18n.getTranslation("_Only_the_current_user") + " (" + userName + ")");
        }
        this.cboCanByUsedBy.setModel(model);
        if (global) {
            this.cboCanByUsedBy.setSelectedIndex(0);
        } else {
            this.cboCanByUsedBy.setSelectedIndex(user == null ? 0 : 1);
        }
    }

    private boolean isGlobal() {
        return this.cboCanByUsedBy.getSelectedIndex() == 0;
    }

    private void updateBookmarksModel() {
        if (this.rdbAlphabeticallyOrder.isSelected()) {
            this.bookmarks.setOrder(0);
        } else {
            this.bookmarks.setOrder(1);
        }
        this.bookmarkListModel = this.createBookmarksModel();
        this.lstBookmarks.setModel(this.bookmarkListModel);
    }

    private BookmarkListModel createBookmarksModel() {
        BookmarkListModel model = new BookmarkListModel();
        for (Bookmark bookmark : this.bookmarks.getOrdered()) {
            model.addElement(bookmark);
        }
        return model;
    }

    public Bookmark<T> getSelectedValue() {
        return this.currentBookmark;
    }

    private void put(Bookmark<T> bookmark) {
        this.currentBookmark = bookmark;
        this.txtLabel.setText(bookmark.getValue().toString());
        this.txtLabel.setCaretPosition(0);
        this.txtName.setText(bookmark.getName());
        Timestamp date = new Timestamp(bookmark.getLastUse());
        this.txtLastUse.setText(date.toString());
        this.setCurrentUser(bookmark.isGlobal());
    }

    private void fetch(Bookmark<T> bookmark) {
        String name = StringUtils.strip((String)this.txtName.getText());
        bookmark.setName(name);
        bookmark.setGlobal(this.isGlobal());
        this.bookmarks.update(bookmark);
        if (this.listenerHelper != null) {
            try {
                DefaultBookmarksController.BookmarkEventImpl<Object> event = new DefaultBookmarksController.BookmarkEventImpl<Object>(this.listenerHelper, 1003, "set-name");
                event.setCurrentBookmark(bookmark);
                event.setCurrentValue(bookmark.getValue());
                this.listenerHelper.fireActionEvent(event);
                this.txtLabel.setText(bookmark.getValue().toString());
                this.txtLabel.setCaretPosition(0);
            }
            catch (Exception ex) {
                LOGGER.warn("Can't fetch bookmark " + name, (Throwable)ex);
            }
        }
    }

    private void doDelete() {
        Bookmark bookmark = (Bookmark)this.lstBookmarks.getSelectedValue();
        if (bookmark == null) {
            return;
        }
        this.bookmarks.remove(bookmark.getName());
        this.updateBookmarksModel();
        this.changeStateTo(0);
    }

    private void doModify() {
        Bookmark bookmark = (Bookmark)this.lstBookmarks.getSelectedValue();
        if (bookmark == null) {
            return;
        }
        this.put(bookmark);
        this.changeStateTo(1);
    }

    private void doAccept() {
        Bookmark bookmark = (Bookmark)this.lstBookmarks.getSelectedValue();
        if (bookmark == null) {
            return;
        }
        String bookmarkName = (String)StringUtils.defaultIfBlank((CharSequence)this.txtName.getText(), null);
        if (StringUtils.containsAny((CharSequence)bookmarkName, (CharSequence)".!@\"\\':/*?")) {
            ToolsSwingLocator.getThreadSafeDialogsManager().messageDialog("_The_bookmark_name_contains_invalid_characters_CHARS", "_Bookmarks", 2);
            return;
        }
        boolean exists = false;
        for (int i = 0; i < this.bookmarkListModel.getSize(); ++i) {
            Bookmark value = (Bookmark)this.bookmarkListModel.get(i);
            if (i == this.lstBookmarks.getSelectedIndex() || !bookmarkName.equalsIgnoreCase(value.getName())) continue;
            exists = true;
            break;
        }
        if (exists) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            int resp = ToolsSwingLocator.getThreadSafeDialogsManager().confirmDialog(i18n.getTranslation("_Bookmark_already_exists_with_this_name") + "\n" + i18n.getTranslation("_Do_you_want_to_replace_it"), "_Bookmarks", 0, 2);
            if (resp != 0) {
                return;
            }
            this.bookmarks.remove(bookmark);
        }
        this.fetch(bookmark);
        this.bookmarkListModel.contentsChanged();
        this.changeStateTo(0);
    }

    private void doDiscard() {
        Bookmark bookmark = (Bookmark)this.lstBookmarks.getSelectedValue();
        if (bookmark == null) {
            return;
        }
        this.put(bookmark);
        this.changeStateTo(0);
    }

    public void changeStateTo(int newstate) {
        switch (newstate) {
            case 0: {
                this.btnAccept.setEnabled(false);
                this.btnDelete.setEnabled(true);
                this.btnDiscard.setEnabled(false);
                this.btnModify.setEnabled(true);
                this.txtName.setEnabled(false);
                this.txtLastUse.setEnabled(false);
                this.txtLabel.setEnabled(false);
                this.lstBookmarks.setEnabled(true);
                this.cboCanByUsedBy.setEnabled(false);
                break;
            }
            case 1: {
                this.btnAccept.setEnabled(true);
                this.btnDelete.setEnabled(true);
                this.btnDiscard.setEnabled(true);
                this.btnModify.setEnabled(false);
                this.txtName.setEnabled(true);
                this.txtLastUse.setEnabled(true);
                this.txtLabel.setEnabled(true);
                this.lstBookmarks.setEnabled(false);
                this.cboCanByUsedBy.setEnabled(true);
                this.txtName.selectAll();
                this.txtName.requestFocusInWindow();
            }
        }
        this.state = newstate;
    }

    public int setSelected(Bookmark<T> bookmark) {
        for (int i = 0; i < this.bookmarkListModel.getSize(); ++i) {
            Bookmark value = (Bookmark)this.bookmarkListModel.get(i);
            if (!bookmark.getName().equals(value.getName())) continue;
            this.lstBookmarks.setSelectedIndex(i);
            return i;
        }
        return -1;
    }

    private static class BookmarkListModel
    extends DefaultListModel<Bookmark> {
        private BookmarkListModel() {
        }

        public void contentsChanged() {
            super.fireContentsChanged(this, 0, this.getSize());
        }

        public boolean containsName(String name) {
            for (int i = 0; i < this.getSize(); ++i) {
                Bookmark value = (Bookmark)this.get(i);
                if (!StringUtils.equalsIgnoreCase((CharSequence)value.getName(), (CharSequence)name)) continue;
                return true;
            }
            return false;
        }
    }
}

