/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.evaluator.EvaluatorWithDescriptions;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.evaluator.EvaluatorPanel;

public class DefaultEvaluatorPanel
extends EvaluatorPanel
implements ListSelectionListener,
MouseListener,
ActionListener {
    private DynClass dynclass = null;
    private EvaluatorWithDescriptions eval_wdesc = null;
    private JTextArea expressionArea = null;
    private JList fieldList = null;
    private JList opfuList = null;
    private JPanel categRadioPanel = null;
    private JTextArea fieldExplainLabel = null;
    private JTextArea opfuDescLabel = null;
    private JRadioButton num_CategRB = null;
    private JRadioButton str_CategRB = null;
    private JRadioButton dat_CategRB = null;
    private JRadioButton geo_CategRB = null;
    private JRadioButton boo_CategRB = null;
    private JRadioButton all_CategRB = null;
    private JPanel opfuDescPanel = null;
    private JScrollPane opfuDescScroll = null;
    private JPanel opfuPanel = null;
    private JPanel fieldsPanel = null;
    private JPanel topPanel = null;
    private JPanel expressionPanel = null;
    private JButton clearButton = null;
    private JButton validateButton = null;
    private static I18nManager im = ToolsLocator.getI18nManager();

    public DefaultEvaluatorPanel(DynClass dcla, EvaluatorWithDescriptions evaluator) {
        this.initialize(dcla, evaluator);
    }

    public String getExpression() {
        return this.getExpressionArea().getText();
    }

    public void initialize(DynClass dcla, EvaluatorWithDescriptions evaluator) {
        this.dynclass = dcla;
        this.eval_wdesc = evaluator;
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 0.8;
        gbc.gridheight = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add(this.getTopPanel(), gbc);
        gbc.weightx = 1.0;
        gbc.weighty = 0.2;
        gbc.gridheight = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.add(this.getExpressionPanel(), gbc);
    }

    private JTextArea getExpressionArea() {
        if (this.expressionArea == null) {
            this.expressionArea = new JTextArea();
            this.expressionArea.setLineWrap(true);
            this.expressionArea.setWrapStyleWord(true);
            if (this.eval_wdesc != null) {
                this.expressionArea.setText(this.eval_wdesc.getSQL());
            }
        }
        return this.expressionArea;
    }

    private JPanel getExpressionPanel() {
        if (this.expressionPanel == null) {
            this.expressionPanel = new JPanel();
            this.expressionPanel.setLayout(new BorderLayout());
            this.expressionPanel.setBorder(BorderFactory.createTitledBorder(im.getTranslation("_User_expression")));
            JScrollPane scroll = new JScrollPane(this.getExpressionArea());
            scroll.setHorizontalScrollBarPolicy(30);
            scroll.setVerticalScrollBarPolicy(20);
            this.expressionPanel.add((Component)scroll, "Center");
            JPanel buttonsp = new JPanel();
            buttonsp.setLayout(new GridLayout(1, 1));
            JPanel aux = new JPanel();
            aux.add(this.getClearButton());
            buttonsp.add(aux);
            this.expressionPanel.add((Component)buttonsp, "East");
        }
        return this.expressionPanel;
    }

    private Component getClearButton() {
        if (this.clearButton == null) {
            this.clearButton = new JButton(im.getTranslation("clear_expression"));
            this.clearButton.addActionListener(this);
        }
        return this.clearButton;
    }

    private JButton getValidateButton() {
        if (this.validateButton == null) {
            this.validateButton = new JButton(im.getTranslation("_Validate"));
            this.validateButton.addActionListener(this);
        }
        return this.validateButton;
    }

    private JList getFieldList() {
        if (this.fieldList == null) {
            this.fieldList = new JList();
            if (this.dynclass != null) {
                this.fieldList.addListSelectionListener(this);
                DynField[] ff = this.dynclass.getDynFields();
                DefaultListModel<String> resultList = new DefaultListModel<String>();
                for (int i = 0; i < ff.length; ++i) {
                    resultList.addElement(ff[i].getName());
                }
                this.fieldList.setModel(resultList);
                this.fieldList.setSelectionMode(0);
                this.fieldList.addMouseListener(this);
            }
        }
        return this.fieldList;
    }

    private JList getOpfuList() {
        if (this.opfuList == null) {
            this.opfuList = new JList();
            this.reloadOpfuList(this.opfuList);
            this.opfuList.setSelectionMode(0);
            this.opfuList.addListSelectionListener(this);
            this.opfuList.addMouseListener(this);
        }
        return this.opfuList;
    }

    private void reloadOpfuList(JList list) {
        DefaultListModel<DescriptionListItem> dlm = new DefaultListModel<DescriptionListItem>();
        if (this.eval_wdesc != null) {
            EvaluatorWithDescriptions.Description[] descs = this.getCurrentDescriptions(this.eval_wdesc);
            for (int i = 0; i < descs.length; ++i) {
                dlm.addElement(new DescriptionListItem(descs[i]));
            }
        }
        list.setModel(dlm);
    }

    private EvaluatorWithDescriptions.Description[] getCurrentDescriptions(EvaluatorWithDescriptions eval) {
        int i;
        int goodbits = 0;
        if (this.getAllCategRB().isSelected()) {
            goodbits = 0;
        } else if (this.getNumCategRB().isSelected()) {
            goodbits = 1;
        } else if (this.getStrCategRB().isSelected()) {
            goodbits = 2;
        } else if (this.getDatCategRB().isSelected()) {
            goodbits = 4;
        } else if (this.getGeoCategRB().isSelected()) {
            goodbits = 16;
        } else if (this.getBooCategRB().isSelected()) {
            goodbits = 8;
        }
        ArrayList<EvaluatorWithDescriptions.Description> list = new ArrayList<EvaluatorWithDescriptions.Description>();
        EvaluatorWithDescriptions.Description[] dd = eval.getAvailableOperators();
        int andop = 0;
        for (i = 0; i < dd.length; ++i) {
            andop = dd[i].getDataTypeCategories() & goodbits;
            if (goodbits != 0 && andop == 0) continue;
            list.add(dd[i]);
        }
        dd = eval.getAvailableFunctions();
        for (i = 0; i < dd.length; ++i) {
            andop = dd[i].getDataTypeCategories() & goodbits;
            if (goodbits != 0 && andop == 0) continue;
            list.add(dd[i]);
        }
        return list.toArray(new EvaluatorWithDescriptions.Description[0]);
    }

    private JRadioButton getAllCategRB() {
        if (this.all_CategRB == null) {
            this.all_CategRB = new JRadioButton(im.getTranslation("_All"));
            this.all_CategRB.addActionListener(this);
        }
        return this.all_CategRB;
    }

    private JRadioButton getNumCategRB() {
        if (this.num_CategRB == null) {
            this.num_CategRB = new JRadioButton(im.getTranslation("_Numeric"));
            this.num_CategRB.addActionListener(this);
        }
        return this.num_CategRB;
    }

    private JRadioButton getStrCategRB() {
        if (this.str_CategRB == null) {
            this.str_CategRB = new JRadioButton(im.getTranslation("_String"));
            this.str_CategRB.addActionListener(this);
        }
        return this.str_CategRB;
    }

    private JRadioButton getDatCategRB() {
        if (this.dat_CategRB == null) {
            this.dat_CategRB = new JRadioButton(im.getTranslation("_Date_or_time"));
            this.dat_CategRB.addActionListener(this);
        }
        return this.dat_CategRB;
    }

    private JRadioButton getGeoCategRB() {
        if (this.geo_CategRB == null) {
            this.geo_CategRB = new JRadioButton(im.getTranslation("_Geometry"));
            this.geo_CategRB.addActionListener(this);
        }
        return this.geo_CategRB;
    }

    private JPanel getCategRadioPanel() {
        if (this.categRadioPanel == null) {
            this.categRadioPanel = new JPanel();
            ButtonGroup bg = new ButtonGroup();
            bg.add(this.getAllCategRB());
            bg.add(this.getNumCategRB());
            bg.add(this.getStrCategRB());
            bg.add(this.getDatCategRB());
            bg.add(this.getBooCategRB());
            bg.add(this.getGeoCategRB());
            this.getAllCategRB().setSelected(true);
            this.categRadioPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.weightx = 0.5;
            gbc.gridx = 0;
            gbc.gridy = 0;
            this.categRadioPanel.add((Component)this.getAllCategRB(), gbc);
            gbc.gridy = 1;
            this.categRadioPanel.add((Component)this.getNumCategRB(), gbc);
            gbc.gridy = 2;
            this.categRadioPanel.add((Component)this.getStrCategRB(), gbc);
            gbc.gridy = 3;
            this.categRadioPanel.add((Component)this.getDatCategRB(), gbc);
            gbc.gridy = 4;
            this.categRadioPanel.add((Component)this.getBooCategRB(), gbc);
            gbc.gridy = 5;
            this.categRadioPanel.add((Component)this.getGeoCategRB(), gbc);
            gbc.gridy = 6;
            gbc.weighty = 1.0;
            this.categRadioPanel.add((Component)new JPanel(), gbc);
        }
        return this.categRadioPanel;
    }

    private JRadioButton getBooCategRB() {
        if (this.boo_CategRB == null) {
            this.boo_CategRB = new JRadioButton(im.getTranslation("_Boolean"));
            this.boo_CategRB.addActionListener(this);
        }
        return this.boo_CategRB;
    }

    private JTextArea getOpfuDescLabel(Color bgcolor) {
        if (this.opfuDescLabel == null) {
            this.opfuDescLabel = new JTextArea();
            this.opfuDescLabel.setEditable(false);
            this.opfuDescLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
            if (bgcolor != null) {
                this.opfuDescLabel.setBackground(bgcolor);
            }
            this.opfuDescLabel.setWrapStyleWord(true);
            this.opfuDescLabel.setLineWrap(true);
            this.opfuDescLabel.setFont(new JLabel().getFont());
            this.opfuDescLabel.setText(" \n \n \n ");
        }
        return this.opfuDescLabel;
    }

    private JPanel getOpfuListCategPanel() {
        if (this.opfuDescPanel == null) {
            this.opfuDescPanel = new JPanel();
            this.opfuDescPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.anchor = 18;
            gbc.weightx = 0.5;
            gbc.weighty = 1.0;
            gbc.gridx = 0;
            gbc.gridy = 0;
            JScrollPane scroll = new JScrollPane(this.getOpfuList());
            scroll.setHorizontalScrollBarPolicy(30);
            scroll.setVerticalScrollBarPolicy(20);
            this.opfuDescPanel.add((Component)scroll, gbc);
            gbc.weightx = 0.5;
            gbc.weighty = 1.0;
            gbc.gridx = 1;
            gbc.insets = new Insets(0, 5, 0, 0);
            this.opfuDescPanel.add((Component)this.getCategRadioPanel(), gbc);
        }
        return this.opfuDescPanel;
    }

    private JPanel getOpfuPanel() {
        if (this.opfuPanel == null) {
            this.opfuPanel = new JPanel();
            this.opfuPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 1;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridheight = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.5;
            this.opfuPanel.add((Component)this.getOpfuListCategPanel(), gbc);
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.weightx = 1.0;
            gbc.weighty = 0.5;
            gbc.gridheight = 1;
            gbc.insets = new Insets(5, 0, 0, 0);
            this.opfuPanel.add((Component)this.getOpfuDescScroll(this.opfuPanel.getBackground()), gbc);
            this.opfuPanel.setBorder(BorderFactory.createTitledBorder(im.getTranslation("_Available_functions_and_operators")));
            ActionEvent aev = new ActionEvent(this.getAllCategRB(), 0, "");
            this.actionPerformed(aev);
        }
        return this.opfuPanel;
    }

    private JScrollPane getOpfuDescScroll(Color bg) {
        if (this.opfuDescScroll == null) {
            this.opfuDescScroll = new JScrollPane(this.getOpfuDescLabel(bg));
            this.opfuDescScroll.setHorizontalScrollBarPolicy(31);
            this.opfuDescScroll.setVerticalScrollBarPolicy(20);
            this.opfuDescScroll.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        return this.opfuDescScroll;
    }

    private JTextArea getFieldExplainLabel(Color bgcolor) {
        if (this.fieldExplainLabel == null) {
            this.fieldExplainLabel = new JTextArea();
            this.fieldExplainLabel.setEditable(false);
            this.fieldExplainLabel.setBorder(new EmptyBorder(2, 2, 2, 2));
            this.fieldExplainLabel.setBackground(bgcolor);
            this.fieldExplainLabel.setLineWrap(true);
            this.fieldExplainLabel.setWrapStyleWord(true);
            this.fieldExplainLabel.setFont(new JLabel().getFont());
            this.fieldExplainLabel.setText(im.getTranslation("_Double-click_to_paste_into_expression_box"));
        }
        return this.fieldExplainLabel;
    }

    private JPanel getFieldsPanel() {
        if (this.fieldsPanel == null) {
            this.fieldsPanel = new JPanel();
            this.fieldsPanel.setLayout(new GridLayout(1, 2, 12, 0));
            JScrollPane scroll = new JScrollPane(this.getFieldList());
            scroll.setHorizontalScrollBarPolicy(30);
            scroll.setVerticalScrollBarPolicy(20);
            scroll.setMinimumSize(new Dimension(100, 100));
            this.fieldsPanel.add(scroll);
            this.fieldsPanel.add(this.getFieldExplainLabel(this.fieldsPanel.getBackground()));
            this.fieldsPanel.setBorder(BorderFactory.createTitledBorder(im.getTranslation("_Available_fields")));
        }
        return this.fieldsPanel;
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridLayout(1, 2, 12, 0));
            this.topPanel.add(this.getFieldsPanel());
            this.topPanel.add(this.getOpfuPanel());
        }
        return this.topPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() == this.getOpfuList()) {
            Object sel = this.getOpfuList().getSelectedValue();
            if (sel instanceof DescriptionListItem) {
                DescriptionListItem item = (DescriptionListItem)sel;
                String txt = item.getDescription().getTemplate() + " : " + item.getDescription().getDescription();
                this.getOpfuDescLabel(null).setText(txt);
                this.getOpfuDescLabel(null).scrollRectToVisible(new Rectangle(0, 0, 10, 10));
                this.getOpfuDescLabel(null).setCaretPosition(0);
            } else {
                this.getOpfuDescLabel(null).setText(" \n \n \n ");
            }
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        Object src = e.getSource();
        if (src == this.getFieldList() && e.getClickCount() == 2) {
            Object sel = this.getFieldList().getSelectedValue();
            if (sel instanceof String) {
                int pos = this.getExpressionArea().getCaretPosition();
                this.getExpressionArea().insert((String)sel, pos);
            }
            return;
        }
        if (src == this.getOpfuList() && e.getClickCount() == 2) {
            Object sel = this.getOpfuList().getSelectedValue();
            if (sel instanceof DescriptionListItem) {
                DescriptionListItem item = (DescriptionListItem)sel;
                int pos = this.getExpressionArea().getCaretPosition();
                this.getExpressionArea().insert(item.getDescription().getName(), pos);
            }
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JRadioButton) {
            this.reloadOpfuList(this.getOpfuList());
        }
        if (e.getSource() == this.getClearButton()) {
            this.getExpressionArea().setText("");
        }
        if (e.getSource() == this.getValidateButton()) {
            // empty if block
        }
    }

    private class DescriptionListItem {
        private EvaluatorWithDescriptions.Description desc = null;

        public DescriptionListItem(EvaluatorWithDescriptions.Description d) {
            this.desc = d;
        }

        public String toString() {
            return this.desc.getName();
        }

        public EvaluatorWithDescriptions.Description getDescription() {
            return this.desc;
        }
    }
}

