/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.icontheme;

import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.impl.DefaultSimpleImage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseIconTheme
implements IconTheme {
    protected static Logger logger = LoggerFactory.getLogger(BaseIconTheme.class);
    protected String id = null;
    protected String name = null;
    protected String description = null;
    protected Map<String, IconTheme.Icon> iconList = null;
    protected IconTheme defaultTheme = null;
    protected String defaultIconName = null;
    protected Map<String, String> groupsDescriptions = new HashMap<String, String>();
    protected Map<String, String> subgroupsDescriptions = new HashMap<String, String>();
    private Map<String, List<URL>> groupsImages = new HashMap<String, List<URL>>();
    private Map<String, List<URL>> subgroupsImages = new HashMap<String, List<URL>>();

    public BaseIconTheme() {
        this(null);
    }

    public BaseIconTheme(IconTheme defaultIconTheme) {
        this.setDefault(defaultIconTheme);
        this.id = "default";
        this.name = "default";
        this.description = "Default icon theme";
        this.iconList = new HashMap<String, IconTheme.Icon>();
    }

    public void load(Object resource) {
    }

    protected void deferredLoad() {
    }

    private void logstack(String msg) {
        try {
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException e) {
            logger.debug(msg, (Throwable)e);
            return;
        }
    }

    public void setDefault(IconTheme def) {
        this.defaultTheme = def == this ? null : def;
    }

    public IconTheme getDefault() {
        return this.defaultTheme;
    }

    public boolean exists(String iconName) {
        if (StringUtils.isEmpty((CharSequence)iconName)) {
            return false;
        }
        this.deferredLoad();
        if (this.iconList.containsKey(iconName)) {
            return true;
        }
        return this.defaultTheme != null && this.defaultTheme.exists(iconName);
    }

    public Iterator<String> iterator() {
        Iterator<String> it;
        HashSet<String> names = new HashSet<String>();
        this.deferredLoad();
        if (this.defaultTheme != null) {
            it = this.defaultTheme.iterator();
            while (it.hasNext()) {
                names.add(it.next());
            }
        }
        it = this.iconList.keySet().iterator();
        while (it.hasNext()) {
            names.add(it.next());
        }
        ArrayList names2 = new ArrayList(names);
        Collections.sort(names2);
        return names2.iterator();
    }

    public Iterator<IconTheme.Icon> getThemeIcons() {
        HashMap<String, IconTheme.Icon> themeIcons = new HashMap<String, IconTheme.Icon>();
        this.deferredLoad();
        if (this.defaultTheme != null) {
            Iterator<IconTheme.Icon> it = this.defaultTheme.getThemeIcons();
            while (it.hasNext()) {
                IconTheme.Icon icon = it.next();
                themeIcons.put(icon.getName(), icon);
            }
        }
        for (IconTheme.Icon icon : this.iconList.values()) {
            themeIcons.put(icon.getName(), icon);
        }
        ArrayList themeIcons2 = new ArrayList(themeIcons.values());
        Collections.sort(themeIcons2);
        return themeIcons2.iterator();
    }

    public IconTheme.Icon getThemeIcon(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        this.deferredLoad();
        IconTheme.Icon themeIcon = this.iconList.get(name);
        if (themeIcon != null) {
            return themeIcon;
        }
        if (this.defaultTheme != null && this.defaultTheme.exists(name)) {
            return this.defaultTheme.getThemeIcon(name);
        }
        return null;
    }

    public boolean isMyIcon(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        this.deferredLoad();
        IconTheme.Icon themeIcon = this.iconList.get(name);
        return themeIcon != null;
    }

    public ImageIcon get(String name) {
        if (!StringUtils.isEmpty((CharSequence)name)) {
            ImageIcon icon;
            this.deferredLoad();
            IconTheme.Icon themeIcon = this.iconList.get(name);
            if (themeIcon != null && (icon = themeIcon.getImageIcon()) != null) {
                return icon;
            }
            if (this.defaultTheme != null && this.defaultTheme.exists(name)) {
                return this.defaultTheme.get(name);
            }
        }
        logger.info("get('" + name + "') icon not found");
        this.logstack("get('" + name + "') icon not found");
        return this.getNoIcon();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String themeName) {
        this.name = themeName;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        String s = this.getName();
        if (StringUtils.isEmpty((CharSequence)s)) {
            s = this.getID();
        }
        return s;
    }

    public ImageIcon getDefaultIcon() {
        ImageIcon imageIcon;
        IconTheme.Icon icon = this.getThemeIcon(this.defaultIconName);
        if (icon != null && (imageIcon = icon.getImageIcon()) != null) {
            return imageIcon;
        }
        icon = this.getThemeIcon("-no-icon-");
        if (icon != null && (imageIcon = icon.getImageIcon()) != null) {
            return imageIcon;
        }
        return new ImageIcon();
    }

    public void setDefaultIcon(ImageIcon icon) {
        this.defaultIconName = null;
        this.register(null, null, "-no-icon-", icon, null);
    }

    public void setDefaultIcon(URL resource) {
        this.defaultIconName = null;
        this.register(null, null, "-no-icon-", null, resource);
    }

    public void setDefaultIcon(String name) {
        this.defaultIconName = name;
    }

    public void register(String provider, String group, String name, ImageIcon icon, URL resource) {
        this.register(provider, group, null, name, icon, resource);
    }

    public IconTheme.Icon register(String provider, String group, String subgroup, String name, ImageIcon icon, URL resource) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("name is empty");
        }
        this.deferredLoad();
        if (icon == null && resource == null) {
            DefaultIcon themeIcon = new DefaultIcon(provider, group, name, null, null);
            themeIcon.setSubgroup(subgroup);
            this.iconList.put(name, themeIcon);
            throw new IllegalArgumentException("icon and resource for '" + this.getIconIdentifier(provider, group, name) + "' are null");
        }
        DefaultIcon themeIcon = new DefaultIcon(provider, group, name, icon, resource);
        themeIcon.setSubgroup(subgroup);
        this.iconList.put(name, themeIcon);
        if (!themeIcon.existsIcon()) {
            throw new IllegalArgumentException("Resource not found for icon '" + this.getIconIdentifier(provider, group, name) + "'");
        }
        return themeIcon;
    }

    private String getIconIdentifier(String provider, String group, String name) {
        this.deferredLoad();
        String identifier = null;
        if (!StringUtils.isEmpty((CharSequence)provider)) {
            identifier = provider;
        }
        if (group != null) {
            identifier = identifier + "/" + group;
        }
        identifier = name == null ? identifier + "/unknow" : identifier + "/" + name;
        return identifier;
    }

    public void registerDefault(String provider, String group, String name, ImageIcon icon, URL resource) throws IllegalArgumentException {
        this.registerDefault(provider, group, null, name, icon, resource);
    }

    public IconTheme.Icon registerDefault(String provider, String group, String subgroup, String name, ImageIcon icon, URL resource) {
        this.deferredLoad();
        if (this.defaultTheme != null) {
            IconTheme.Icon themeIcon = this.defaultTheme.getThemeIcon(name);
            if (themeIcon == null) {
                return this.defaultTheme.register(provider, group, subgroup, name, icon, resource);
            }
            return themeIcon;
        }
        return this.register(provider, group, subgroup, name, icon, resource);
    }

    public void export(File folder) {
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!(folder = new File(folder, this.getID())).exists()) {
            folder.mkdir();
        }
        URL url_no_icon = this.getThemeIcon("-no-icon-").getURL();
        Iterator<IconTheme.Icon> themeIcons = this.getThemeIcons();
        while (themeIcons.hasNext()) {
            File target;
            IconTheme.Icon themeIcon = themeIcons.next();
            URL url_src = themeIcon.getURL();
            if (url_src == null) {
                url_src = url_no_icon;
            }
            if (themeIcon.getGroup() != null) {
                target = new File(folder, themeIcon.getGroup());
                target.mkdir();
            } else {
                target = new File(folder.getAbsolutePath());
            }
            target = new File(target, themeIcon.getName() + ".png");
            try {
                FileUtils.copyURLToFile((URL)url_src, (File)target);
            }
            catch (IOException iOException) {}
        }
    }

    public ImageIcon getNoIcon() {
        return this.getDefaultIcon();
    }

    public void registerDefault(String name, ImageIcon image) {
        this.logstack("registerDefault('" + name + "'), deprecated method.");
        try {
            this.registerDefault(null, null, name, image, null);
        }
        catch (IllegalArgumentException e) {
            logger.info(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void registerDefault(String name, Object resource) {
        this.logstack("registerDefault('" + name + "'), deprecated method.");
        try {
            this.registerDefault(null, null, name, null, (URL)resource);
        }
        catch (IllegalArgumentException e) {
            logger.info(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void register(String name, ImageIcon image) {
        this.logstack("register('" + name + "'), deprecated method.");
        try {
            this.register(null, null, name, image, null);
        }
        catch (IllegalArgumentException e) {
            logger.info(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void register(String name, Object resource) {
        this.logstack("register('" + name + "'), deprecated method.");
        try {
            this.register(null, null, name, null, (URL)resource);
        }
        catch (IllegalArgumentException e) {
            logger.info(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public ImageIcon get(String iconName, ClassLoader loader) {
        this.logstack("get('" + iconName + "', loader), deprecated method.");
        return this.get(iconName);
    }

    public String getGroupDescription(String group) {
        return this.groupsDescriptions.get(group);
    }

    public void setGroupDescription(String group, String description) {
        this.groupsDescriptions.put(group, description);
    }

    public String getSubgroupDescription(String group, String subgroup) {
        return this.subgroupsDescriptions.get(group + "|" + subgroup);
    }

    public void setSubgroupDescription(String group, String subgroup, String description) {
        this.subgroupsDescriptions.put(group + "|" + subgroup, description);
    }

    public void addGroupImage(String group, URL resource) {
        List<URL> images = this.groupsImages.get(group);
        if (images == null) {
            images = new ArrayList<URL>();
            this.groupsImages.put(group, images);
        }
        images.add(resource);
    }

    public List<SimpleImage> getGroupImages(String group) {
        List<URL> images = this.groupsImages.get(group);
        if (images == null) {
            return Collections.EMPTY_LIST;
        }
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        ArrayList<SimpleImage> simpleImages = new ArrayList<SimpleImage>();
        for (URL image : images) {
            SimpleImage simpleImage = manager.createSimpleImage((Object)image);
            simpleImages.add(simpleImage);
        }
        return simpleImages;
    }

    public void addSubgroupImage(String group, String subgroup, URL resource) {
        String key = group + "|" + subgroup;
        List<URL> images = this.subgroupsImages.get(key);
        if (images == null) {
            images = new ArrayList<URL>();
            this.subgroupsImages.put(key, images);
        }
        images.add(resource);
    }

    public List<SimpleImage> getSubgroupImages(String group, String subgroup) {
        String key = group + "|" + subgroup;
        List<URL> images = this.subgroupsImages.get(key);
        if (images == null) {
            return Collections.EMPTY_LIST;
        }
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        ArrayList<SimpleImage> simpleImages = new ArrayList<SimpleImage>();
        for (URL image : images) {
            SimpleImage simpleImage = manager.createSimpleImage((Object)image);
            simpleImages.add(simpleImage);
        }
        return simpleImages;
    }

    public boolean matchID(String id) {
        return StringUtils.equalsIgnoreCase((CharSequence)id, (CharSequence)this.id);
    }

    class DefaultIcon
    implements IconTheme.Icon {
        private ImageIcon image;
        private ImageIcon scaledImage;
        private final URL resource;
        private final String name;
        private final String group;
        private final String provider;
        private String description;
        private String subgroup;

        DefaultIcon(String provider, String group, String name, ImageIcon image, URL resource) {
            double scaleFactor;
            this.scaledImage = this.image = image;
            if (this.image != null && (scaleFactor = ToolsSwingLocator.getIconThemeManager().getScaleFactor()) != 1.0) {
                DefaultSimpleImage simpleImage = new DefaultSimpleImage(this.image);
                simpleImage = simpleImage.resize(scaleFactor);
                this.scaledImage = new ImageIcon(simpleImage.getBufferedImage());
            }
            this.resource = resource;
            this.group = group;
            this.name = name;
            this.provider = provider;
        }

        public boolean existsIcon() {
            boolean resp;
            if (this.image != null) {
                return true;
            }
            InputStream ist = null;
            try {
                ist = this.resource.openStream();
                resp = true;
            }
            catch (Exception ex) {
                resp = false;
            }
            try {
                if (ist != null) {
                    ist.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return resp;
        }

        public ImageIcon getImageIcon() {
            if (this.image == null) {
                try {
                    this.image = new ImageIcon(this.resource);
                    double scaleFactor = ToolsSwingLocator.getIconThemeManager().getScaleFactor();
                    if (scaleFactor != 1.0) {
                        DefaultSimpleImage simpleImage = new DefaultSimpleImage(this.image);
                        simpleImage = simpleImage.resize(scaleFactor);
                        this.scaledImage = new ImageIcon(simpleImage.getBufferedImage());
                    } else {
                        this.scaledImage = this.image;
                    }
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return this.scaledImage;
        }

        public Image getImage() {
            ImageIcon icon = this.getImageIcon();
            if (icon == null) {
                return null;
            }
            return icon.getImage();
        }

        public String getName() {
            return this.name;
        }

        public String getGroup() {
            return this.group;
        }

        public Object getResource() {
            return this.resource;
        }

        public URL getURL() {
            if (this.resource instanceof URL) {
                return this.resource;
            }
            return null;
        }

        public String getLabel() {
            if (this.resource != null) {
                return this.resource.toString();
            }
            if (this.image != null) {
                return this.image.toString();
            }
            return "";
        }

        public int compareTo(IconTheme.Icon other) {
            String this_id = this.getProviderName() + "/" + this.getGroup() + "/" + this.getName();
            String other_id = other.getProviderName() + "/" + other.getGroup() + "/" + other.getName();
            return this_id.compareTo(other_id);
        }

        public String getProviderName() {
            return this.provider;
        }

        public String getDescription() {
            return this.description;
        }

        public String getSubgroup() {
            return this.subgroup;
        }

        public String getGroupDescription() {
            if (BaseIconTheme.this.defaultTheme == null) {
                return BaseIconTheme.this.groupsDescriptions.get(this.group);
            }
            return BaseIconTheme.this.defaultTheme.getGroupDescription(this.group);
        }

        public String getSubgroupDescription() {
            if (BaseIconTheme.this.defaultTheme == null) {
                return BaseIconTheme.this.subgroupsDescriptions.get(this.group + "|" + this.subgroup);
            }
            return BaseIconTheme.this.defaultTheme.getSubgroupDescription(this.group, this.subgroup);
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setSubgroup(String subgroup) {
            this.subgroup = subgroup;
        }
    }
}

