/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.pickercontroller;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.folders.FoldersManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.pickercontroller.AbstractPickerController;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.viewer.JViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class BytearrayPickerControllerImpl
extends AbstractPickerController<byte[]> {
    private final JTextComponent jtext;
    private final JButton btnUpload;
    private final JButton btnDownload;
    private final JButton btnEdit;
    private byte[] value;
    private final String fileChooserID;
    private final File initialPath;

    public BytearrayPickerControllerImpl(JTextComponent jtext, JButton btnUpload, JButton btnDownload, JButton btnEdiAsText, String fileChooserID, File initialPath) {
        this.jtext = jtext;
        this.btnUpload = btnUpload;
        this.btnDownload = btnDownload;
        this.btnEdit = btnEdiAsText == null ? new JButton() : btnEdiAsText;
        this.fileChooserID = fileChooserID;
        this.initialPath = initialPath;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.btnDownload.setCursor(Cursor.getPredefinedCursor(12));
        this.btnDownload.setText("");
        if (StringUtils.isBlank((CharSequence)this.btnDownload.getToolTipText())) {
            this.btnDownload.setToolTipText(i18n.getTranslation("_Download_data"));
        }
        this.btnDownload.setIcon(this.getIcon("picker-bytearray-download"));
        this.btnDownload.addActionListener(e -> this.doDownload());
        this.btnUpload.setCursor(Cursor.getPredefinedCursor(12));
        this.btnUpload.setText("");
        if (StringUtils.isBlank((CharSequence)this.btnUpload.getToolTipText())) {
            this.btnUpload.setToolTipText(i18n.getTranslation("_Upload_data"));
        }
        this.btnUpload.setIcon(this.getIcon("picker-bytearray-upload"));
        this.btnUpload.addActionListener(e -> this.doUpload());
        this.btnEdit.setCursor(Cursor.getPredefinedCursor(12));
        this.btnEdit.setText("");
        if (StringUtils.isBlank((CharSequence)this.btnEdit.getToolTipText())) {
            this.btnEdit.setToolTipText(i18n.getTranslation("_Edit"));
        }
        this.btnEdit.setIcon(this.getIcon("picker-bytearray-editastext"));
        this.btnEdit.addActionListener(e -> this.doEdit((e.getModifiers() & 2) != 2));
        this.jtext.setEditable(false);
        ToolsSwingLocator.getToolsSwingManager().addClearButton(jtext, e -> {
            this.value = null;
            this.jtext.setText("");
            this.btnDownload.setEnabled(false);
            this.btnEdit.setEnabled(true);
        });
    }

    public byte[] get() {
        return this.value;
    }

    public void set(byte[] value) {
        this.value = value;
        if (this.value == null) {
            this.btnDownload.setEnabled(false);
            this.btnEdit.setEnabled(true);
            this.jtext.setText("");
        } else {
            this.btnDownload.setEnabled(true);
            this.btnEdit.setEnabled(true);
            int size = this.value.length;
            this.jtext.setText(String.format("%d bytes", size));
        }
        this.fireChangeEvent();
    }

    public void coerceAndSet(Object value) {
        this.set((byte[])this.coerce(12, value, null));
    }

    public void setEnabled(boolean enabled) {
        this.btnDownload.setEnabled(true);
        this.btnUpload.setEnabled(enabled);
        this.btnEdit.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.btnUpload.isEnabled();
    }

    private File fileChooser(String title, int mode) {
        FoldersManager folderManager;
        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
        Object[] f = dialogs.showChooserDialog(title, mode, 0, true, (folderManager = ToolsLocator.getFoldersManager()).getLastPath(this.fileChooserID, this.initialPath), null, true);
        if (ArrayUtils.isEmpty((Object[])f)) {
            return null;
        }
        return f[0];
    }

    private void doDownload() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String title = i18n.getTranslation("_Download_data");
        File f = this.fileChooser(title, 1);
        if (f == null) {
            return;
        }
        try {
            FileUtils.writeByteArrayToFile((File)f, (byte[])this.value);
        }
        catch (Exception ex) {
            LOG.warn("Can't save bytes from file '" + f.getAbsolutePath() + "'.", (Throwable)ex);
        }
    }

    private void doUpload() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        String title = i18n.getTranslation("_Upload_data");
        File f = this.fileChooser(title, 0);
        if (f == null) {
            return;
        }
        try {
            byte[] bytes = FileUtils.readFileToByteArray((File)f);
            this.set(bytes);
            this.fireChangeEvent();
        }
        catch (Exception ex) {
            LOG.warn("Can't load bytes from file '" + f.getAbsolutePath() + "'.", (Throwable)ex);
        }
    }

    private void doEdit(final boolean modal) {
        JPopupMenu popup = new JPopupMenu();
        I18nManager i18n = ToolsLocator.getI18nManager();
        ToolsSwingManager manager = ToolsSwingLocator.getToolsSwingManager();
        for (final ViewerFactory factory : manager.getViewerFactories()) {
            AbstractAction action = new AbstractAction(i18n.getTranslation("_Show_as_XDataTypeNameX", new String[]{factory.getDataTypeName()})){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BytearrayPickerControllerImpl.this.doShowViewer(factory, modal);
                }
            };
            action.setEnabled(factory.isApplicable(new Object[]{this.value}));
            popup.add(new JMenuItem(action));
        }
        popup.show(this.btnEdit, 0, this.btnEdit.getHeight());
    }

    private void doShowViewer(ViewerFactory factory, boolean modal) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        boolean isEditable = this.isEditable() && this.isEnabled() && factory.isEditable();
        String title = isEditable ? i18n.getTranslation("_XDataTypeNameX_editor", new String[]{factory.getDataTypeName()}) : i18n.getTranslation("_XDataTypeNameX_viewer", new String[]{factory.getDataTypeName()});
        try {
            JViewer viewer = factory.createViewer();
            viewer.setContents((Object)this.value);
            viewer.setEditable(isEditable);
            viewer.setEnabled(true);
            WindowManager_v2 winmanager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog dialog = winmanager.createDialog(viewer.asJComponent(), title, null, 3);
            dialog.setButtonEnabled(1, isEditable);
            dialog.addActionListener(e -> {
                if (isEditable && dialog.getAction() == 1) {
                    try {
                        this.set(viewer.getBytes());
                    }
                    catch (Exception ex) {
                        LOG.warn("Can't bytes from editor.", (Throwable)ex);
                        ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
                        dialogs.messageDialog(i18n.getTranslation("_Cant_get_bytes_from_editor"), title, 2);
                    }
                }
            });
            dialog.show(modal ? WindowManager.MODE.DIALOG : WindowManager.MODE.WINDOW);
        }
        catch (Exception ex) {
            LOG.warn("Can't show editor.", (Throwable)ex);
            ThreadSafeDialogsManager dialogs = ToolsSwingLocator.getThreadSafeDialogsManager();
            dialogs.messageDialog(i18n.getTranslation("_Cant_show_viewer"), title, 2);
            return;
        }
    }

    public static void selfRegister() {
    }
}

