/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.usability;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import org.gvsig.tools.dynobject.DynField;
import org.gvsig.tools.swing.api.usability.UsabilitySwingManager;
import org.gvsig.tools.swing.impl.usability.JBlank;
import org.gvsig.tools.swing.impl.usability.button.JStandardizedButton;
import org.gvsig.tools.swing.impl.usability.button.JStandardizedToolButton;
import org.gvsig.tools.swing.impl.usability.spinner.date.JNullSpinner;
import org.gvsig.tools.swing.impl.usability.spinner.editor.DefaultDynFieldEditor;
import org.gvsig.tools.swing.impl.usability.text.JStandardizedTextArea;

public class DefaultUsabilitySwingManager
implements UsabilitySwingManager {
    public JPanel createGridBagRowPanel(JPanel gridBagPanel, Component labelComponent, Component fieldComponent, Integer labelMargin, Integer fieldMargin) {
        JPanel panel;
        if (gridBagPanel == null) {
            panel = new JPanel();
            panel.setLayout(new GridBagLayout());
        } else {
            panel = gridBagPanel;
        }
        GridBagConstraints constr = this.getDefaultParametersConstraints();
        constr.fill = 2;
        constr.gridwidth = -1;
        constr.weighty = 0.0;
        if (labelComponent != null) {
            if (labelMargin != null) {
                constr.weightx = labelMargin.intValue();
            }
            panel.add(labelComponent, constr);
        }
        constr.fill = 0;
        if (fieldComponent != null) {
            constr.weightx = 0.0;
            if (fieldMargin != null) {
                constr.weightx = labelMargin.intValue();
            }
            panel.add(fieldComponent, constr);
        }
        return panel;
    }

    public JButton createJButton() {
        return new JStandardizedButton();
    }

    public JButton createJButton(Action action) {
        return new JStandardizedButton(action);
    }

    public JButton createJButton(Icon icon) {
        return new JStandardizedButton(icon);
    }

    public JButton createJButton(String text) {
        return new JStandardizedButton(text);
    }

    public JButton createJButton(String text, Icon icon) {
        return new JStandardizedButton(text, icon);
    }

    public JButton createJToolButton(String text) {
        return new JStandardizedToolButton(text);
    }

    private GridBagConstraints getDefaultParametersConstraints() {
        GridBagConstraints constr = new GridBagConstraints();
        constr.insets = new Insets(2, 2, 2, 2);
        constr.ipadx = 2;
        constr.ipady = 2;
        constr.anchor = 19;
        return constr;
    }

    public Border setLightMarkedBorder(JComponent component) {
        return this.setLightMarkedBorder(component, 1, Color.red);
    }

    public Border setLightMarkedBorder(JComponent component, int thickness, Color color) {
        Border oldBorder = component.getBorder();
        Border one = BorderFactory.createEtchedBorder();
        MatteBorder two = BorderFactory.createMatteBorder(thickness, thickness, thickness, thickness, color);
        component.setBorder(BorderFactory.createCompoundBorder(one, two));
        return oldBorder;
    }

    public JTextArea createJTextArea(String text) {
        return new JStandardizedTextArea(text);
    }

    public JTextArea createJTextArea(String text, int maxWidth) {
        JStandardizedTextArea ta = new JStandardizedTextArea(text);
        ta.setFill(maxWidth);
        return ta;
    }

    public JSpinner createJNullSpinner(int dataType, Object value, int defaultMaximumWidth) {
        JNullSpinner spinner = new JNullSpinner(dataType, value, defaultMaximumWidth);
        return spinner;
    }

    public JSpinner createJNullSpinner(int dataType, Object value) {
        JNullSpinner spinner = new JNullSpinner(dataType, value);
        return spinner;
    }

    public DefaultDynFieldEditor createNullSpinnerEditor(FocusListener listener, DynField dynField, Locale locale) {
        return new DefaultDynFieldEditor(listener, dynField, locale);
    }

    public Component createJBlank(int width, int height) {
        return new JBlank(width, height);
    }
}

