/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.impl.zipviewer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.apache.commons.io.IOUtils;
import org.gvsig.tools.swing.api.viewer.AbstractJViewer;
import org.gvsig.tools.swing.api.viewer.JViewer;
import org.gvsig.tools.swing.api.viewer.ViewerFactory;
import org.gvsig.tools.swing.impl.zipviewer.ZipTableModel;

public class ZipViewerImpl
extends AbstractJViewer
implements JViewer {
    private JTable zipTable;
    private ZipTableModel zipTableModel;
    private final JPanel panel = new JPanel();

    public ZipViewerImpl(ViewerFactory factory) {
        super(factory);
        this.panel.setLayout(new BorderLayout());
        this.zipTable = new JTable();
        JScrollPane scrollPane = new JScrollPane(this.zipTable);
        this.zipTable.setShowVerticalLines(true);
        this.zipTable.setShowHorizontalLines(false);
        this.panel.add((Component)scrollPane, "Center");
        this.panel.setPreferredSize(new Dimension(800, 400));
        this.panel.setVisible(true);
    }

    public void setContents(File zipile) {
        try {
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            ZipFile zipFile = new ZipFile(zipile);
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                entries.add(zipEntries.nextElement());
            }
            this.zipTableModel = new ZipTableModel(entries);
            this.zipTable.setModel(this.zipTableModel);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't open zip file", ex);
        }
    }

    public void setContents(InputStream in) {
        try {
            ZipEntry entry;
            ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
            final ZipInputStream zipIn = new ZipInputStream(in);
            while ((entry = zipIn.getNextEntry()) != null) {
                entries.add(entry);
                this.readContents(new FilterInputStream(zipIn){

                    @Override
                    public void close() throws IOException {
                        zipIn.closeEntry();
                    }
                });
            }
            this.zipTableModel = new ZipTableModel(entries);
            this.zipTable.setModel(this.zipTableModel);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't open zip stream", ex);
        }
    }

    private void readContents(InputStream contentsIn) throws IOException {
        int direct;
        byte[] contents = new byte[4096];
        while ((direct = contentsIn.read(contents, 0, contents.length)) >= 0) {
        }
    }

    public void setContents(Object data) {
        if (data instanceof byte[]) {
            ByteArrayInputStream bis = new ByteArrayInputStream((byte[])data);
            this.setContents(bis);
            IOUtils.closeQuietly((InputStream)bis);
            return;
        }
        if (data instanceof File) {
            this.setContents((File)data);
            return;
        }
        if (data instanceof InputStream) {
            this.setContents((InputStream)data);
            return;
        }
        super.setContents(data);
    }

    public JComponent asJComponent() {
        return this.panel;
    }

    public void clean() {
        this.zipTableModel = new ZipTableModel(Collections.EMPTY_LIST);
        this.zipTable.setModel(this.zipTableModel);
    }
}

