/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.PrettyFormaterImpl;
import org.gvsig.tools.lang.Cloneable;
import org.gvsig.tools.visitor.FilteredVisitable;

public interface Code
extends FilteredVisitable,
Cloneable {
    public static final int UNDEFINED = -1;
    public static final int CONSTANT = 0;
    public static final int IDENTIFIER = 1;
    public static final int CALLABLE = 2;
    public static final int METHOD = 3;
    public static final int CODES = 4;
    public static final Formatter<Code> EMPTY_FORMATTER = new EmptyFormatter();

    public static boolean isFunction(Code code, String name) {
        return code.code() == 2 && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)((Callable)code).name());
    }

    public static boolean isIdentifier(Code code, String name) {
        return code.code() == 1 && StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)((Identifier)code).name());
    }

    public int code();

    public ExpressionBuilder.Value toValue();

    public ExpressionBuilder.Value toValue(ExpressionBuilder var1);

    public String toString(Formatter<Code> var1);

    public void link(SymbolTable var1);

    public void link(SymbolTable var1, boolean var2);

    public void link();

    public void replace(Code var1, Code var2);

    public Code clone() throws CloneNotSupportedException;

    public static class EmptyFormatter
    extends PrettyFormaterImpl
    implements Formatter<Code> {
        public EmptyFormatter() {
        }

        public EmptyFormatter(boolean useNl, int indentSize) {
            super.setIndentSize(indentSize);
            super.setUseNl(useNl);
        }

        @Override
        public boolean canApply(Code value) {
            return false;
        }

        @Override
        public String format(Code value) {
            return "";
        }

        @Override
        public void setIndentSize(int indentSize) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setUseNl(boolean useNl) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Method
    extends Callable {
        public Code instance();

        public String methodname();

        @Override
        public Codes parameters();

        @Override
        public Object call(Interpreter var1, Object[] var2) throws Exception;
    }

    public static interface Callable
    extends Code {
        public static final int FUNCTION = 0;
        public static final int BINARY_OPERATOR = 1;
        public static final int UNARY_OPERATOR = 2;

        public static String name(Code code) {
            if (code instanceof Callable) {
                return ((Callable)code).name();
            }
            return null;
        }

        public static Codes parameters(Code code) {
            if (code instanceof Callable) {
                return ((Callable)code).parameters();
            }
            return null;
        }

        public String name();

        public Object call(Interpreter var1, Object[] var2) throws Exception;

        public Function function();

        public Function function(Function var1);

        public Codes parameters();

        public int type();
    }

    public static interface Identifier
    extends Code {
        public static String name(Code code) {
            if (code instanceof Identifier) {
                return ((Identifier)code).name();
            }
            return null;
        }

        public String name();
    }

    public static interface Constant
    extends Code {
        public static Object value(Code code) {
            if (code instanceof Constant) {
                return ((Constant)code).value();
            }
            return null;
        }

        public Object value();
    }
}

