/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.expressionevaluator.spi;

import java.io.File;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.Range;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math.exception.OutOfRangeException;
import org.apache.commons.math.util.MathUtils;
import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Codes;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionRuntimeException;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.Function;
import org.gvsig.expressionevaluator.I18N;
import org.gvsig.expressionevaluator.Interpreter;
import org.gvsig.expressionevaluator.spi.JsonUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.util.GetItem;
import org.gvsig.tools.util.GetItem64;
import org.gvsig.tools.util.GetItemWithSize64;
import org.gvsig.tools.util.Size;
import org.gvsig.tools.util.Size64;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFunction
implements Function {
    protected static Logger LOGGER = LoggerFactory.getLogger(AbstractFunction.class);
    private final String name;
    private String group;
    private Range argc;
    private String description;
    private String[] descriptionArgs;
    private List<String> alias;
    private String template;
    private String returnType;
    private boolean sqlCompatible;
    protected static final int TYPE_INT = 1;
    protected static final int TYPE_LONG = 2;
    protected static final int TYPE_FLOAT = 4;
    protected static final int TYPE_DOUBLE = 8;
    protected static final int TYPE_BOOLEAN = 16;
    protected static final int TYPE_STRING = 32;
    protected static final int TYPE_DATE = 64;
    protected static final int TYPE_NULL = 128;
    protected static final int TYPE_BIGDECIMAL = 256;

    protected AbstractFunction(String group, String name, Range argc, String description, String template, String[] descriptionArgs, String returnType, boolean sqlCompatible) {
        this.name = name;
        this.group = group;
        this.argc = argc;
        this.description = description;
        this.template = template;
        this.descriptionArgs = descriptionArgs;
        this.returnType = returnType;
        this.sqlCompatible = sqlCompatible;
        this.load_from_resource();
    }

    protected AbstractFunction(String group, String name, Range argc, String description, String template, String[] descriptionArgs, String returnType) {
        this(group, name, argc, description, template, descriptionArgs, returnType, false);
    }

    protected AbstractFunction(String group, String name, Range argc, String description, String template, String[] descriptionArgs) {
        this(group, name, argc, description, template, null, null);
    }

    protected AbstractFunction(String group, String name, Range argc, String description, String template) {
        this(group, name, argc, description, template, null, null);
    }

    protected AbstractFunction(String group, String name, Range argc) {
        this(group, name, argc, null, null, null, null);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String returnType() {
        return this.returnType;
    }

    @Override
    public String group() {
        return this.group;
    }

    @Override
    public Range argc() {
        return this.argc;
    }

    @Override
    public String description() {
        if (StringUtils.equalsIgnoreCase((CharSequence)System.getProperty("ExpressionEvaluatorReloadFunctionResources"), (CharSequence)"true")) {
            this.load_from_resource();
        }
        return this.description;
    }

    @Override
    public String[] descriptionArgs() {
        return this.descriptionArgs;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setDescriptionArgs(String[] descriptionArgs) {
        this.descriptionArgs = descriptionArgs;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    @Override
    public String getFullDescription() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        StringBuilder html = new StringBuilder();
        html.append("<html>\n");
        String functionDescription = this.description();
        html.append("<b>").append(i18n.getTranslation("_Function")).append("</b> ").append(this.name()).append("<br>\n<br>\n");
        List<String> aliases = this.aliases();
        if (aliases != null && !aliases.isEmpty()) {
            html.append("<b>").append(i18n.getTranslation("_Aliases")).append(":</b> ").append("<ul>\n");
            for (String theAlias : aliases) {
                html.append("<li>").append(theAlias).append("</li>\n");
            }
            html.append("</ul>\n");
        }
        html.append("<b>").append(i18n.getTranslation("_Return")).append("</b> ");
        html.append(StringUtils.isEmpty((CharSequence)this.returnType()) ? "Objec" : this.returnType());
        html.append("<br>\n");
        html.append("<b>").append(i18n.getTranslation("_Template")).append("</b> ");
        html.append(StringUtils.isEmpty((CharSequence)this.template()) ? this.name() + "()" : this.template());
        html.append("<br>\n");
        String[] args = this.descriptionArgs();
        if (args != null) {
            html.append("<b>").append(i18n.getTranslation("_Arguments")).append(":</b> ").append("<ul>\n");
            for (String arg : args) {
                html.append("<li>").append(arg).append("</li>\n");
            }
            html.append("</ul>\n");
            html.append("<br>\n");
        }
        html.append("<b>").append(i18n.getTranslation("_SQL_compatible")).append("</b> ");
        html.append(this.isSQLCompatible()).append("<br>\n");
        if (!StringUtils.isBlank((CharSequence)functionDescription)) {
            html.append("<b>").append(i18n.getTranslation("_Description")).append("</b><br>\n");
            html.append(functionDescription.replace("\n", "<br>")).append("<br>\n");
        }
        html.append("</html>\n");
        return html.toString();
    }

    @Override
    public void addAlias(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return;
        }
        if (this.alias == null) {
            this.alias = new ArrayList<String>();
        }
        if (this.alias.contains(name)) {
            return;
        }
        this.alias.add(name);
    }

    @Override
    public List<String> aliases() {
        return this.alias;
    }

    @Override
    public String template() {
        return this.template;
    }

    @Override
    public boolean isOperator() {
        return false;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public boolean useArgumentsInsteadObjects() {
        return false;
    }

    @Override
    public boolean isSQLCompatible() {
        return this.sqlCompatible;
    }

    @Override
    public boolean allowConstantFolding() {
        return false;
    }

    @Override
    public Object call(Interpreter interpreter, Codes args) throws Exception {
        return null;
    }

    protected int getInt(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getInt(args[n], n);
    }

    protected int getInt(Object value, int n) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.Illegal_null_value_for_argument_XargnX_of_XIdentifierX_function(this.name(), n));
        }
        if (!(value instanceof Number)) {
            String type = value.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("Number", type));
        }
        return ((Number)value).intValue();
    }

    protected int getInt(Interpreter interpreter, Codes args, int n) {
        Object value = this.getObject(interpreter, args, n);
        return this.getInt(value, n);
    }

    protected long getLong(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getLong(args[n], n);
    }

    protected long getLong(Object value, int n) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.Illegal_null_value_for_argument_XargnX_of_XIdentifierX_function(this.name(), n));
        }
        if (!(value instanceof Number)) {
            String type = value.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("Number", type));
        }
        return ((Number)value).longValue();
    }

    protected double getDouble(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getDouble(args[n], n);
    }

    protected double getDouble(Object value, int arg) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.Illegal_null_value_for_argument_XargnX_of_XIdentifierX_function(this.name(), arg));
        }
        if (!(value instanceof Number)) {
            String type = value.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), arg) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("Number", type));
        }
        return ((Number)value).doubleValue();
    }

    protected BigDecimal getBigDecimal(Object value, int arg) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.Illegal_null_value_for_argument_XargnX_of_XIdentifierX_function(this.name(), arg));
        }
        if (!(value instanceof Number)) {
            String type = value.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), arg) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("Number", type));
        }
        if (value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte) {
            return BigDecimal.valueOf(((Number)value).longValue());
        }
        return BigDecimal.valueOf(((Number)value).doubleValue());
    }

    protected float getFloat(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getFloat(args[n], n);
    }

    protected float getFloat(Object value, int arg) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.Illegal_null_value_for_argument_XargnX_of_XIdentifierX_function(this.name(), arg));
        }
        if (!(value instanceof Number)) {
            String type = value.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), arg) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("Number", type));
        }
        return ((Number)value).floatValue();
    }

    protected String getStr(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getStr(args[n], n);
    }

    protected String getStr(Object value, int n) {
        return Objects.toString(value, "");
    }

    protected File getFile(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getFile(args[n], n);
    }

    protected File getFile(Object value, int n) {
        if (value == null) {
            return null;
        }
        if (value instanceof File) {
            return (File)value;
        }
        if (value instanceof URL) {
            try {
                return new File(((URL)value).toURI());
            }
            catch (URISyntaxException ex) {
                return null;
            }
        }
        if (value instanceof URI) {
            return new File((URI)value);
        }
        String s = Objects.toString(value, null);
        if (s == null) {
            return null;
        }
        File f = new File(s);
        return f;
    }

    protected boolean isNull(Object[] args, int n) {
        return this.getObject(args, n) == null;
    }

    protected Object getObject(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return args[n];
    }

    protected JsonObject getJsonObject(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getJsonObject(args[n], n);
    }

    protected JsonObject getJsonObject(Object value, int n) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.Illegal_null_value_for_argument_XargnX_of_XIdentifierX_function(this.name(), n));
        }
        if (!(value instanceof JSONObject)) {
            try {
                value = JsonUtils.toJsonObject(value);
            }
            catch (Throwable th) {
                String type = value.getClass().getCanonicalName();
                throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("JsonObject", type), th);
            }
        }
        return (JsonObject)value;
    }

    protected JsonArray getJsonArray(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getJsonArray(args[n], n);
    }

    protected JsonArray getJsonArray(Object value, int n) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.Illegal_null_value_for_argument_XargnX_of_XIdentifierX_function(this.name(), n));
        }
        if (!(value instanceof JsonArray)) {
            try {
                value = JsonUtils.toJsonArray(value);
            }
            catch (Throwable th) {
                String type = value.getClass().getCanonicalName();
                throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("JsonObject", type), th);
            }
        }
        return (JsonArray)value;
    }

    protected JsonStructure getJsonStructure(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getJsonStructure(args[n], n);
    }

    protected JsonStructure getJsonStructure(Object value, int n) {
        if (value == null) {
            throw new IllegalArgumentException(I18N.Illegal_null_value_for_argument_XargnX_of_XIdentifierX_function(this.name(), n));
        }
        if (!(value instanceof JsonStructure)) {
            try {
                value = JsonUtils.toJson(value);
            }
            catch (Throwable th) {
                String type = value.getClass().getCanonicalName();
                throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("JsonObject", type), th);
            }
        }
        return (JsonStructure)value;
    }

    protected Object getObject(Interpreter interpreter, Codes args, int n) {
        if (args.size() < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.size(), n));
        }
        Code arg = (Code)args.get(n);
        if (arg == null) {
            return null;
        }
        Object value = null;
        try {
            value = interpreter.runCode(arg);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionRuntimeException(arg, "", ex);
        }
        return value;
    }

    protected Comparable getComparable(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getComparable(args[n], n);
    }

    protected Comparable getComparable(Object value, int n) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof Comparable)) {
            String type = value.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("Comparable", type));
        }
        return (Comparable)value;
    }

    protected Comparable getDate(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getDate(args[n], n);
    }

    protected java.util.Date getDate(Object value, int n) {
        if (value == null) {
            return null;
        }
        if (!(value instanceof java.util.Date)) {
            String type = value.getClass().getCanonicalName();
            throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("Date", type));
        }
        return (java.util.Date)value;
    }

    protected LocalDateTime getLocalDateTime(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getLocalDateTime(args[n], n);
    }

    protected LocalDateTime getLocalDateTime(Object value, int n) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date sqlDate = (Date)value;
            LocalDate date = sqlDate.toLocalDate();
            return date.atStartOfDay(ZoneOffset.UTC).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof TemporalAccessor) {
            return LocalDateTime.from((TemporalAccessor)value);
        }
        String type = value.getClass().getCanonicalName();
        throw new IllegalArgumentException(I18N.The_type_of_the_argument_XargnX_for_the_XIdentifierX_function_is_incorrect(this.name(), n) + " " + I18N.Expected_XexpectedX_and_found_XfoundX("Temporal/Date", type));
    }

    public URL getURL(Object[] args, int index) throws MalformedURLException {
        URL url;
        Object obj = this.getObject(args, index);
        if (obj == null) {
            return null;
        }
        if (obj instanceof URL) {
            url = (URL)obj;
        } else if (obj instanceof CharSequence) {
            url = new URL(((CharSequence)obj).toString());
        } else if (obj instanceof File) {
            url = ((File)obj).toURI().toURL();
        } else if (obj instanceof URI) {
            url = ((URI)obj).toURL();
        } else {
            throw new ExpressionRuntimeException("The " + this.name() + " function require a File, URI or a String and a received a '" + obj.getClass().getSimpleName() + "'.");
        }
        return url;
    }

    protected boolean getBoolean(Object[] args, int n, Double accuracy) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getBoolean(args[n], n, accuracy);
    }

    protected boolean getBoolean(Object[] args, int n) {
        if (args.length < n) {
            throw new IllegalArgumentException(I18N.Required_argument_XargnX_and_only_found_XargcX_in_call_to_XIdentifierX(this.name(), args.length, n));
        }
        return this.getBoolean(args[n], n, (Double)1.110223E-16f);
    }

    protected boolean getBoolean(Object value, int n) {
        return this.getBoolean(value, n, (Double)1.110223E-16f);
    }

    protected boolean getBoolean(Object value, int n, Double accuracy) {
        return this.toBoolean(value, accuracy);
    }

    protected boolean getBoolean(Interpreter interpreter, Codes args, int n) {
        Object value = this.getObject(interpreter, args, n);
        return this.toBoolean(value, interpreter.getAccuracy());
    }

    protected boolean toBoolean(Object value, Double accuracy) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return MathUtils.compareTo((double)((Number)value).doubleValue(), (double)0.0, (double)(accuracy == null ? (double)1.110223E-16f : accuracy)) == 0;
        }
        return BooleanUtils.toBoolean((String)value.toString());
    }

    protected GetItemWithSize64 getList(Object[] args, int index) {
        final Object value = this.getObject(args, index);
        if (value == null) {
            return null;
        }
        Object list = null;
        if (value instanceof List) {
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return ((List)value).size();
                }

                public Object get64(long index) {
                    return ((List)value).get((int)index);
                }
            };
        } else if (value instanceof Object[]) {
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return ((Object[])value).length;
                }

                public Object get64(long index) {
                    return ((Object[])value)[(int)index];
                }
            };
        } else if (value instanceof GetItemWithSize64) {
            list = (GetItemWithSize64)value;
        } else if (value instanceof GetItem && value instanceof Size) {
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return ((Size)value).size();
                }

                public Object get64(long index) {
                    return ((GetItem)value).get((int)index);
                }
            };
        } else if (value instanceof GetItem64 && value instanceof Size64) {
            list = new GetItemWithSize64<Object>(){

                public long size64() {
                    return ((Size64)value).size64();
                }

                public Object get64(long index) {
                    return ((GetItem64)value).get64((long)((int)index));
                }
            };
        }
        return list;
    }

    private void load_from_resource() {
        int i;
        Object x;
        JSONObject json;
        String lang = Locale.getDefault().getLanguage();
        URL url = this.getClass().getResource("/org/gvsig/expressionevaluator/functions/" + lang + "/" + this.name() + ".json");
        if (url == null && (url = this.getClass().getResource("/org/gvsig/expressionevaluator/functions/en/" + this.name() + ".json")) == null) {
            return;
        }
        try {
            json = new JSONObject(IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            return;
        }
        if (json.has("group")) {
            this.group = json.getString("group");
        }
        if (json.has("description")) {
            x = json.get("description");
            if (x instanceof String) {
                this.description = (String)x;
            } else if (x instanceof JSONArray) {
                StringBuilder builder = new StringBuilder();
                for (i = 0; i < ((JSONArray)x).length(); ++i) {
                    if (i > 0) {
                        builder.append(" ");
                    }
                    builder.append(((JSONArray)x).getString(i));
                }
                this.description = builder.toString();
            } else {
                this.description = Objects.toString(x, null);
            }
            this.description = this.process_includes(url, this.description);
            this.description = StringUtils.replace((String)this.description, (String)"@@@", (String)url.toString());
        }
        if (json.has("template")) {
            this.template = json.getString("template");
        }
        if (json.has("returnType")) {
            this.returnType = json.getString("returnType");
        }
        if (json.has("sqlCompatible")) {
            this.sqlCompatible = json.getBoolean("sqlCompatible");
        }
        if (json.has("args")) {
            x = json.getJSONArray("args");
            String[] args = new String[x.length()];
            for (i = 0; i < x.length(); ++i) {
                args[i] = x.getString(i);
            }
            this.descriptionArgs = args;
        }
        if (json.has("alias")) {
            x = json.getJSONArray("alias");
            for (int i2 = 0; i2 < x.length(); ++i2) {
                this.addAlias(x.getString(i2));
            }
        }
    }

    private String process_includes(URL pathname, String text) {
        Pattern p1 = Pattern.compile("[<][%]include (?<fname>[a-zA-Z0-9_$.]+)[%][>]", 32);
        Matcher m;
        while ((m = p1.matcher(text)) != null && m.find()) {
            String path = FilenameUtils.getPathNoEndSeparator((String)pathname.toString());
            String fname = m.group("fname");
            try {
                URL url = new URL(path + "/" + fname);
                String replacement = IOUtils.toString((URL)url);
                StringBuilder builder = new StringBuilder(text.length() + replacement.length());
                builder.append(text.substring(0, m.start()));
                builder.append(replacement);
                builder.append(text.substring(m.end()));
                text = builder.toString();
            }
            catch (Exception ex) {
                return text;
            }
        }
        return text;
    }

    protected int getType(Object op1, Object op2) {
        int r = 0;
        if (op1 == null) {
            r |= 0x80;
        } else if (op1 instanceof BigDecimal) {
            r |= 0x100;
        } else if (op1 instanceof Double) {
            r |= 8;
        } else if (op1 instanceof Float) {
            r |= 4;
        } else if (op1 instanceof Long) {
            r |= 2;
        } else if (op1 instanceof Integer) {
            r |= 1;
        } else if (op1 instanceof Boolean) {
            r |= 0x10;
        } else if (op1 instanceof String) {
            r |= 0x20;
        } else if (op1 instanceof java.util.Date) {
            r |= 0x40;
        }
        if (op2 == null) {
            r |= 0x80;
        } else if (op2 instanceof BigDecimal) {
            r |= 0x100;
        } else if (op2 instanceof Double) {
            r |= 8;
        } else if (op2 instanceof Float) {
            r |= 4;
        } else if (op2 instanceof Long) {
            r |= 2;
        } else if (op2 instanceof Integer) {
            r |= 1;
        } else if (op2 instanceof Boolean) {
            r |= 0x10;
        } else if (op2 instanceof String) {
            r |= 0x20;
        } else if (op2 instanceof java.util.Date) {
            r |= 0x40;
        }
        return r;
    }

    @Override
    public String toString(Codes args, Formatter<Code> formatter) {
        return null;
    }

    public String toString() {
        return this.name;
    }

    protected void checkDoubleValue(double value) {
        if (Double.isInfinite(value)) {
            throw new OutOfRangeException((Number)value, (Number)Double.MIN_VALUE, (Number)Double.MAX_VALUE);
        }
    }

    protected void checkFloatValue(float value) {
        if (Float.isInfinite(value)) {
            throw new OutOfRangeException((Number)Float.valueOf(value), (Number)Float.valueOf(Float.MIN_VALUE), (Number)Float.valueOf(Float.MAX_VALUE));
        }
    }

    @Override
    public ExpressionBuilder.Value toValue(ExpressionBuilder builder, Codes parameters) {
        ExpressionBuilder.Function f = builder.function(this.name(), new ExpressionBuilder.Value[0]);
        if (parameters != null) {
            Iterator iterator = parameters.iterator();
            while (iterator.hasNext()) {
                Code parameter = (Code)iterator.next();
                if (parameter == null) {
                    f.parameter(null);
                    continue;
                }
                f.parameter(parameter.toValue(builder));
            }
        }
        return f;
    }
}

